/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.type;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlCallBinding;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperandCountRange;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlOperatorBinding;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.type.SqlOperandCountRanges;
import org.eigenbase.sql.type.SqlSingleOperandTypeChecker;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.util.Static;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SameOperandTypeChecker
implements SqlSingleOperandTypeChecker {
    protected final int nOperands;

    public SameOperandTypeChecker(int nOperands) {
        this.nOperands = nOperands;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        return this.checkOperandTypesImpl(callBinding, throwOnFailure, callBinding);
    }

    protected List<Integer> getOperandList(int operandCount) {
        return this.nOperands == -1 ? Util.range(0, operandCount) : Util.range(0, this.nOperands);
    }

    private boolean checkOperandTypesImpl(SqlOperatorBinding operatorBinding, boolean throwOnFailure, SqlCallBinding callBinding) {
        int nOperandsActual = this.nOperands;
        if (nOperandsActual == -1) {
            nOperandsActual = operatorBinding.getOperandCount();
        }
        assert (!throwOnFailure || callBinding != null);
        RelDataType[] types = new RelDataType[nOperandsActual];
        List<Integer> operandList = this.getOperandList(operatorBinding.getOperandCount());
        for (int i : operandList) {
            if (operatorBinding.isOperandNull(i, false)) {
                if (throwOnFailure) {
                    throw callBinding.getValidator().newValidationError((SqlNode)callBinding.getCall().operand(i), Static.RESOURCE.nullIllegal());
                }
                return false;
            }
            types[i] = operatorBinding.getOperandType(i);
        }
        int prev = -1;
        for (int i : operandList) {
            if (prev >= 0 && !SqlTypeUtil.isComparable(types[i], types[prev])) {
                if (!throwOnFailure) {
                    return false;
                }
                throw callBinding.newValidationError(Static.RESOURCE.needSameTypeParameter());
            }
            prev = i;
        }
        return true;
    }

    public boolean checkOperandTypes(SqlOperatorBinding operatorBinding) {
        return this.checkOperandTypesImpl(operatorBinding, false, null);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        if (this.nOperands == -1) {
            return SqlOperandCountRanges.any();
        }
        return SqlOperandCountRanges.of(this.nOperands);
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        return SqlUtil.getAliasedSignature(op, opName, this.nOperands == -1 ? ImmutableList.of((Object)"EQUIVALENT_TYPE", (Object)"EQUIVALENT_TYPE", (Object)"...") : Collections.nCopies(this.nOperands, "EQUIVALENT_TYPE"));
    }

    @Override
    public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode operand, int iFormalOperand, boolean throwOnFailure) {
        throw new UnsupportedOperationException();
    }
}

