/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.type;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypePrecedenceList;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.util.ImmutableNullableList;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlTypeExplicitPrecedenceList
implements RelDataTypePrecedenceList {
    private static final List<SqlTypeName> NUMERIC_TYPES = ImmutableNullableList.of(SqlTypeName.TINYINT, null, SqlTypeName.SMALLINT, null, SqlTypeName.INTEGER, null, SqlTypeName.BIGINT, null, new SqlTypeName[]{SqlTypeName.DECIMAL, null, SqlTypeName.REAL, null, SqlTypeName.FLOAT, SqlTypeName.DOUBLE});
    private static final List<SqlTypeName> COMPACT_NUMERIC_TYPES = ImmutableList.copyOf((Iterable)Iterables.filter(NUMERIC_TYPES, (Predicate)Predicates.notNull()));
    private static final Map<SqlTypeName, SqlTypeExplicitPrecedenceList> TYPE_NAME_TO_PRECEDENCE_LIST = ImmutableMap.builder().put((Object)SqlTypeName.BOOLEAN, (Object)SqlTypeExplicitPrecedenceList.list(SqlTypeName.BOOLEAN)).put((Object)SqlTypeName.TINYINT, (Object)SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.TINYINT)).put((Object)SqlTypeName.INTEGER, (Object)SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.INTEGER)).put((Object)SqlTypeName.BIGINT, (Object)SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.BIGINT)).put((Object)SqlTypeName.DECIMAL, (Object)SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.DECIMAL)).put((Object)SqlTypeName.REAL, (Object)SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.REAL)).put((Object)SqlTypeName.FLOAT, (Object)SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.FLOAT)).put((Object)SqlTypeName.DOUBLE, (Object)SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.DOUBLE)).put((Object)SqlTypeName.CHAR, (Object)SqlTypeExplicitPrecedenceList.list(SqlTypeName.CHAR, SqlTypeName.VARCHAR)).put((Object)SqlTypeName.VARCHAR, (Object)SqlTypeExplicitPrecedenceList.list(SqlTypeName.VARCHAR)).put((Object)SqlTypeName.BINARY, (Object)SqlTypeExplicitPrecedenceList.list(SqlTypeName.BINARY, SqlTypeName.VARBINARY)).put((Object)SqlTypeName.VARBINARY, (Object)SqlTypeExplicitPrecedenceList.list(SqlTypeName.VARBINARY)).put((Object)SqlTypeName.DATE, (Object)SqlTypeExplicitPrecedenceList.list(SqlTypeName.DATE)).put((Object)SqlTypeName.TIME, (Object)SqlTypeExplicitPrecedenceList.list(SqlTypeName.TIME)).put((Object)SqlTypeName.TIMESTAMP, (Object)SqlTypeExplicitPrecedenceList.list(SqlTypeName.TIMESTAMP)).put((Object)SqlTypeName.INTERVAL_YEAR_MONTH, (Object)SqlTypeExplicitPrecedenceList.list(SqlTypeName.INTERVAL_YEAR_MONTH)).put((Object)SqlTypeName.INTERVAL_DAY_TIME, (Object)SqlTypeExplicitPrecedenceList.list(SqlTypeName.INTERVAL_DAY_TIME)).build();
    private final List<SqlTypeName> typeNames;

    public SqlTypeExplicitPrecedenceList(List<SqlTypeName> typeNames) {
        this.typeNames = ImmutableNullableList.copyOf(typeNames);
    }

    private static SqlTypeExplicitPrecedenceList list(SqlTypeName ... array) {
        return new SqlTypeExplicitPrecedenceList((List<SqlTypeName>)ImmutableList.copyOf((Object[])array));
    }

    private static SqlTypeExplicitPrecedenceList numeric(SqlTypeName typeName) {
        int i = SqlTypeExplicitPrecedenceList.getListPosition(typeName, COMPACT_NUMERIC_TYPES);
        return new SqlTypeExplicitPrecedenceList(Util.skip(COMPACT_NUMERIC_TYPES, i));
    }

    @Override
    public boolean containsType(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        return typeName != null && this.typeNames.contains((Object)typeName);
    }

    @Override
    public int compareTypePrecedence(RelDataType type1, RelDataType type2) {
        assert (this.containsType(type1));
        assert (this.containsType(type2));
        int p1 = SqlTypeExplicitPrecedenceList.getListPosition(type1.getSqlTypeName(), this.typeNames);
        int p2 = SqlTypeExplicitPrecedenceList.getListPosition(type2.getSqlTypeName(), this.typeNames);
        return p2 - p1;
    }

    private static int getListPosition(SqlTypeName type, List<SqlTypeName> list) {
        int i = list.indexOf((Object)type);
        assert (i != -1);
        for (int j = i - 1; j >= 0; --j) {
            if (list.get(j) != null) continue;
            return j;
        }
        return i;
    }

    static RelDataTypePrecedenceList getListForType(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return null;
        }
        return TYPE_NAME_TO_PRECEDENCE_LIST.get((Object)typeName);
    }
}

