/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.validate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlFunction;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlOperatorTable;
import org.eigenbase.sql.SqlSyntax;
import org.eigenbase.sql.util.SqlBasicVisitor;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AggFinder
extends SqlBasicVisitor<Void> {
    private final SqlOperatorTable opTab;
    private final boolean over;

    AggFinder(SqlOperatorTable opTab, boolean over) {
        this.opTab = opTab;
        this.over = over;
    }

    public SqlNode findAgg(SqlNode node) {
        try {
            node.accept(this);
            return null;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return (SqlNode)e.getNode();
        }
    }

    public SqlNode findAgg(List<SqlNode> nodes) {
        try {
            for (SqlNode node : nodes) {
                node.accept(this);
            }
            return null;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return (SqlNode)e.getNode();
        }
    }

    @Override
    public Void visit(SqlCall call) {
        SqlOperator operator = call.getOperator();
        if (operator.isAggregator()) {
            throw new Util.FoundOne(call);
        }
        if (operator instanceof SqlFunction && ((SqlFunction)operator).getFunctionType() == SqlFunctionCategory.USER_DEFINED_FUNCTION) {
            ArrayList list = Lists.newArrayList();
            this.opTab.lookupOperatorOverloads(((SqlFunction)operator).getSqlIdentifier(), SqlFunctionCategory.USER_DEFINED_FUNCTION, SqlSyntax.FUNCTION, list);
            for (SqlOperator sqlOperator : list) {
                if (!sqlOperator.isAggregator()) continue;
                throw new Util.FoundOne(call);
            }
        }
        if (call.isA(SqlKind.QUERY)) {
            return null;
        }
        if (call.getKind() == SqlKind.OVER) {
            if (this.over) {
                throw new Util.FoundOne(call);
            }
            return null;
        }
        return (Void)super.visit(call);
    }
}

