/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.validate;

import java.util.ArrayList;
import java.util.List;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlSelect;
import org.eigenbase.sql.SqlWindow;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.validate.EmptyScope;
import org.eigenbase.sql.validate.ListScope;
import org.eigenbase.sql.validate.SqlMonotonicity;
import org.eigenbase.sql.validate.SqlValidatorNamespace;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.sql.validate.SqlValidatorTable;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectScope
extends ListScope {
    private final SqlSelect select;
    protected final List<String> windowNames = new ArrayList<String>();
    private List<SqlNode> expandedSelectList = null;
    private SqlNodeList orderList;
    private final SqlValidatorScope windowParent;

    SelectScope(SqlValidatorScope parent, SqlValidatorScope winParent, SqlSelect select) {
        super(parent);
        this.select = select;
        this.windowParent = winParent;
    }

    public SqlValidatorTable getTable() {
        return null;
    }

    @Override
    public SqlSelect getNode() {
        return this.select;
    }

    @Override
    public SqlWindow lookupWindow(String name) {
        SqlNodeList windowList = this.select.getWindowList();
        for (int i = 0; i < windowList.size(); ++i) {
            SqlWindow window = (SqlWindow)windowList.get(i);
            SqlIdentifier declId = window.getDeclName();
            assert (declId.isSimple());
            if (!((String)declId.names.get(0)).equals(name)) continue;
            return window;
        }
        if (this.windowParent != null) {
            return this.windowParent.lookupWindow(name);
        }
        return null;
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlNode expr) {
        SqlMonotonicity monotonicity = expr.getMonotonicity(this);
        if (monotonicity != SqlMonotonicity.NOT_MONOTONIC) {
            return monotonicity;
        }
        SqlNodeList orderList = this.getOrderList();
        if (orderList.size() > 0) {
            SqlNode order0 = orderList.get(0);
            monotonicity = SqlMonotonicity.INCREASING;
            if (order0 instanceof SqlCall && ((SqlCall)order0).getOperator() == SqlStdOperatorTable.DESC) {
                monotonicity = monotonicity.reverse();
                order0 = ((SqlCall)order0).operand(0);
            }
            if (expr.equalsDeep(order0, false)) {
                return monotonicity;
            }
        }
        return SqlMonotonicity.NOT_MONOTONIC;
    }

    @Override
    public SqlNodeList getOrderList() {
        if (this.orderList == null) {
            SqlValidatorNamespace child;
            List<Pair<SqlNode, SqlMonotonicity>> monotonicExprs;
            this.orderList = new SqlNodeList(SqlParserPos.ZERO);
            if (this.children.size() == 1 && (monotonicExprs = (child = (SqlValidatorNamespace)((Pair)this.children.get((int)0)).right).getMonotonicExprs()).size() > 0) {
                this.orderList.add((SqlNode)monotonicExprs.get((int)0).left);
            }
        }
        return this.orderList;
    }

    public void addWindowName(String winName) {
        this.windowNames.add(winName);
    }

    public boolean existingWindowName(String winName) {
        for (String windowName : this.windowNames) {
            if (!windowName.equalsIgnoreCase(winName)) continue;
            return true;
        }
        SqlValidatorScope walker = this.parent;
        while (!(walker instanceof EmptyScope)) {
            if (walker instanceof SelectScope) {
                SelectScope parentScope = (SelectScope)walker;
                return parentScope.existingWindowName(winName);
            }
            walker = this.parent;
        }
        return false;
    }

    public List<SqlNode> getExpandedSelectList() {
        return this.expandedSelectList;
    }

    public void setExpandedSelectList(List<SqlNode> selectList) {
        this.expandedSelectList = selectList;
    }
}

