/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql2rel;

import java.math.BigDecimal;
import java.util.Calendar;
import net.hydromatic.avatica.ByteString;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlIntervalLiteral;
import org.eigenbase.sql.SqlIntervalQualifier;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlTimeLiteral;
import org.eigenbase.sql.SqlTimestampLiteral;
import org.eigenbase.sql.parser.SqlParserUtil;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql2rel.SqlNodeToRexConverter;
import org.eigenbase.sql2rel.SqlRexContext;
import org.eigenbase.sql2rel.SqlRexConvertlet;
import org.eigenbase.sql2rel.SqlRexConvertletTable;
import org.eigenbase.util.BitString;
import org.eigenbase.util.NlsString;
import org.eigenbase.util.Util;

public class SqlNodeToRexConverterImpl
implements SqlNodeToRexConverter {
    private final SqlRexConvertletTable convertletTable;

    SqlNodeToRexConverterImpl(SqlRexConvertletTable convertletTable) {
        this.convertletTable = convertletTable;
    }

    public RexNode convertCall(SqlRexContext cx, SqlCall call) {
        SqlRexConvertlet convertlet = this.convertletTable.get(call);
        if (convertlet != null) {
            return convertlet.convertCall(cx, call);
        }
        throw Util.needToImplement(call);
    }

    public RexLiteral convertInterval(SqlRexContext cx, SqlIntervalQualifier intervalQualifier) {
        RexBuilder rexBuilder = cx.getRexBuilder();
        return rexBuilder.makeIntervalLiteral(intervalQualifier);
    }

    public RexNode convertLiteral(SqlRexContext cx, SqlLiteral literal) {
        RexBuilder rexBuilder = cx.getRexBuilder();
        RelDataTypeFactory typeFactory = cx.getTypeFactory();
        SqlValidator validator = cx.getValidator();
        Object value = literal.getValue();
        if (value == null) {
            RelDataType type;
            if (literal.getTypeName() == SqlTypeName.BOOLEAN) {
                type = typeFactory.createSqlType(SqlTypeName.BOOLEAN);
                type = typeFactory.createTypeWithNullability(type, true);
            } else {
                type = validator.getValidatedNodeType(literal);
            }
            return rexBuilder.makeCast(type, rexBuilder.constantNull());
        }
        switch (literal.getTypeName()) {
            case DECIMAL: {
                BigDecimal bd = (BigDecimal)value;
                return rexBuilder.makeExactLiteral(bd, literal.createSqlType(typeFactory));
            }
            case DOUBLE: {
                return rexBuilder.makeApproxLiteral((BigDecimal)value);
            }
            case CHAR: {
                return rexBuilder.makeCharLiteral((NlsString)value);
            }
            case BOOLEAN: {
                return rexBuilder.makeLiteral((Boolean)value);
            }
            case BINARY: {
                BitString bitString = (BitString)value;
                Util.permAssert(bitString.getBitCount() % 8 == 0, "incomplete octet");
                ByteString byteString = new ByteString(bitString.getAsByteArray());
                return rexBuilder.makeBinaryLiteral(byteString);
            }
            case SYMBOL: {
                return rexBuilder.makeFlag((Enum)value);
            }
            case TIMESTAMP: {
                return rexBuilder.makeTimestampLiteral((Calendar)value, ((SqlTimestampLiteral)literal).getPrec());
            }
            case TIME: {
                return rexBuilder.makeTimeLiteral((Calendar)value, ((SqlTimeLiteral)literal).getPrec());
            }
            case DATE: {
                return rexBuilder.makeDateLiteral((Calendar)value);
            }
            case INTERVAL_YEAR_MONTH: {
                SqlIntervalLiteral.IntervalValue intervalValue = (SqlIntervalLiteral.IntervalValue)value;
                long l = SqlParserUtil.intervalToMonths(intervalValue);
                return rexBuilder.makeIntervalLiteral(BigDecimal.valueOf(l), intervalValue.getIntervalQualifier());
            }
            case INTERVAL_DAY_TIME: {
                SqlIntervalLiteral.IntervalValue intervalValue = (SqlIntervalLiteral.IntervalValue)value;
                long l = SqlParserUtil.intervalToMillis(intervalValue);
                return rexBuilder.makeIntervalLiteral(BigDecimal.valueOf(l), intervalValue.getIntervalQualifier());
            }
        }
        throw Util.unexpected(literal.getTypeName());
    }
}

