/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util14;

import java.sql.Time;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.eigenbase.util14.DateTimeUtil;
import org.eigenbase.util14.ZonelessDatetime;

public class ZonelessTime
extends ZonelessDatetime {
    private static final long serialVersionUID = 906156904798141861L;
    protected final int precision;
    protected transient Time tempTime;

    public ZonelessTime() {
        this.precision = 0;
    }

    public ZonelessTime(int precision) {
        this.precision = precision;
    }

    public void setZonelessTime(long value) {
        super.setZonelessTime(value);
        this.clearDate();
    }

    public void setZonedTime(long value, TimeZone zone) {
        super.setZonedTime(value, zone);
        this.clearDate();
    }

    public Object toJdbcObject() {
        return new Time(this.getJdbcTime(DateTimeUtil.DEFAULT_ZONE));
    }

    public long getJdbcTimestamp(TimeZone zone) {
        Calendar cal = this.getCalendar(DateTimeUtil.GMT_ZONE);
        cal.setTimeInMillis(this.getTime());
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int millis = cal.get(14);
        cal.setTimeZone(zone);
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        cal.set(14, millis);
        return cal.getTimeInMillis();
    }

    public String toString() {
        Time jdbcTime = this.getTempTime(this.getJdbcTime(DateTimeUtil.DEFAULT_ZONE));
        return jdbcTime.toString();
    }

    public String toString(String format) {
        DateFormat formatter = this.getFormatter(format);
        Time jdbcTime = this.getTempTime(this.getTime());
        return formatter.format(jdbcTime);
    }

    public static ZonelessTime parse(String s) {
        return ZonelessTime.parse(s, "HH:mm:ss");
    }

    public static ZonelessTime parse(String s, String format) {
        DateTimeUtil.PrecisionTime pt = DateTimeUtil.parsePrecisionDateTimeLiteral(s, format, DateTimeUtil.GMT_ZONE);
        if (pt == null) {
            return null;
        }
        ZonelessTime zt = new ZonelessTime(pt.getPrecision());
        zt.setZonelessTime(pt.getCalendar().getTime().getTime());
        return zt;
    }

    protected Time getTempTime(long value) {
        if (this.tempTime == null) {
            this.tempTime = new Time(value);
        } else {
            this.tempTime.setTime(value);
        }
        return this.tempTime;
    }
}

