/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.discovery;

import com.google.step2.discovery.LinkSyntaxException;
import com.google.step2.discovery.RelType;
import com.google.step2.discovery.RelTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkValue {
    private static Pattern WHITESPACE = Pattern.compile("\\s");
    private final String uri;
    private final RelTypes relTypes;
    private final Map<String, String> params;

    public static LinkValue fromString(String link) throws LinkSyntaxException {
        return new Parser(link).link_value();
    }

    private LinkValue(String uri, RelTypes relTypes, Map<String, String> params) {
        this.uri = uri;
        this.relTypes = relTypes;
        this.params = params;
    }

    public RelTypes getRelationships() {
        return this.relTypes;
    }

    protected String getUriString() {
        return this.uri;
    }

    public String getMimeType() {
        return this.params.get("type");
    }

    public String getParameter(String name) {
        return this.params.get(name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.params == null ? 0 : ((Object)this.params).hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinkValue other = (LinkValue)obj;
        if (this.params == null ? other.params != null : !((Object)this.params).equals(other.params)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    private static class Parser {
        private final String input;

        public Parser(String input) {
            this.input = input.trim();
        }

        public LinkValue link_value() throws LinkSyntaxException {
            String s = this.input;
            if (!s.startsWith("<")) {
                throw new LinkSyntaxException("missing '<': " + this.input);
            }
            int greaterThan = s.indexOf(62, 1);
            if (greaterThan < 0) {
                throw new LinkSyntaxException("missing '>':" + this.input);
            }
            String left = s.substring(1, greaterThan).trim();
            String right = s.substring(greaterThan + 1).trim();
            String uri_reference = this.uri_reference(left);
            Builder builder = new Builder(uri_reference);
            this.link_params(right, builder);
            return builder.create();
        }

        private String uri_reference(String s) throws LinkSyntaxException {
            if (s == null || s.length() == 0) {
                throw new LinkSyntaxException("got empty uri-reference: " + this.input);
            }
            return s;
        }

        private void link_params(String s, Builder builder) throws LinkSyntaxException {
            if (s == null || s.length() == 0) {
                return;
            }
            if (!s.startsWith(";")) {
                throw new LinkSyntaxException("link-params must start with ';': " + this.input);
            }
            String remainder = s.substring(1).trim();
            this.link_param(remainder, builder);
        }

        private void link_param(String s, Builder builder) throws LinkSyntaxException {
            int eq = s.indexOf(61);
            if (eq < 0) {
                throw new LinkSyntaxException("missing '=' in link-param:" + this.input);
            }
            String left = s.substring(0, eq).trim();
            String right = s.substring(eq + 1).trim();
            int consumedUntil = left.equalsIgnoreCase("rel") ? this.relation_type(right, builder) : this.param_value(right, builder, left);
            String remainder = right.substring(consumedUntil).trim();
            this.link_params(remainder, builder);
        }

        private int relation_type(String s, Builder builder) throws LinkSyntaxException {
            if (s.startsWith("\"")) {
                return this.quoted_relation_types(s, builder);
            }
            return this.unquoted_relation_type(s, builder);
        }

        private int unquoted_relation_type(String s, Builder builder) throws LinkSyntaxException {
            RelType relType;
            if (s == null || s.length() == 0) {
                throw new LinkSyntaxException("missing value in: " + this.input);
            }
            String[] parts = s.split(";");
            builder.addLinkParameter("rel", parts[0].trim());
            try {
                relType = new RelType(parts[0].trim());
            }
            catch (IllegalArgumentException e) {
                throw new LinkSyntaxException(parts[0].trim() + " is not a valid URI", e);
            }
            builder.addRelType(relType);
            return parts[0].length();
        }

        private int quoted_relation_types(String s, Builder builder) throws LinkSyntaxException {
            String[] relTypes;
            if (!s.startsWith("\"")) {
                throw new LinkSyntaxException("expected \" in relation-type: " + this.input);
            }
            int secondQuote = s.indexOf(34, 1);
            if (secondQuote < 0) {
                throw new LinkSyntaxException("could not find closing quote in: " + this.input);
            }
            int result = secondQuote + 1;
            String sWithoutQuotes = s.substring(1, secondQuote);
            builder.addLinkParameter("rel", sWithoutQuotes);
            for (String relTypeString : relTypes = sWithoutQuotes.split("\\s")) {
                RelType relType;
                try {
                    relType = new RelType(relTypeString.trim());
                }
                catch (IllegalArgumentException e) {
                    throw new LinkSyntaxException(relTypeString.trim() + "is not a valid URI", e);
                }
                builder.addRelType(relType);
            }
            return result;
        }

        private int param_value(String s, Builder builder, String paramName) throws LinkSyntaxException {
            if (s.startsWith("\"")) {
                return this.quoted_param_value(s, builder, paramName);
            }
            return this.unquoted_param_value(s, builder, paramName);
        }

        private int quoted_param_value(String s, Builder builder, String paramName) throws LinkSyntaxException {
            if (!s.startsWith("\"")) {
                throw new LinkSyntaxException("expected \" in: " + this.input);
            }
            int secondQuote = s.indexOf(34, 1);
            if (secondQuote < 0) {
                throw new LinkSyntaxException("could not find closing quote in: " + this.input);
            }
            int result = secondQuote + 1;
            String sWithoutQuotes = s.substring(1, secondQuote);
            builder.addLinkParameter(paramName, sWithoutQuotes);
            return result;
        }

        private int unquoted_param_value(String s, Builder builder, String paramName) throws LinkSyntaxException {
            if (s == null || s.length() == 0) {
                throw new LinkSyntaxException("missing value in: " + this.input);
            }
            String[] parts = s.split(";");
            String paramValue = parts[0].trim();
            if (WHITESPACE.matcher(paramValue).find()) {
                throw new LinkSyntaxException("unexpected whitespace in unqoted param " + paramName + " in link value " + this.input);
            }
            builder.addLinkParameter(paramName, paramValue);
            return parts[0].length();
        }
    }

    private static class Builder {
        private final String uri;
        private final Collection<RelType> relTypes = new ArrayList<RelType>();
        private final Map<String, String> params = new HashMap<String, String>();

        public Builder(String uri) {
            this.uri = uri;
        }

        public Builder addRelType(RelType relType) {
            this.relTypes.add(relType);
            return this;
        }

        public LinkValue create() {
            return new LinkValue(this.uri, RelTypes.setOf(this.relTypes), this.params);
        }

        public Builder addLinkParameter(String name, String value) {
            this.params.put(name, value);
            return this;
        }
    }
}

