/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.discovery;

import java.net.URL;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureDiscoveryInformation
extends DiscoveryInformation {
    private boolean secure = false;

    public SecureDiscoveryInformation(URL opEndpoint, Identifier claimedIdentifier, String delegate, String version) throws DiscoveryException {
        super(opEndpoint, claimedIdentifier, delegate, version);
    }

    public SecureDiscoveryInformation(URL opEndpoint) throws DiscoveryException {
        super(opEndpoint);
    }

    public SecureDiscoveryInformation(DiscoveryInformation info) throws DiscoveryException {
        this(info.getOPEndpoint(), info.getClaimedIdentifier(), info.getDelegateIdentifier(), info.getVersion());
        if (info instanceof SecureDiscoveryInformation) {
            this.setSecure(((SecureDiscoveryInformation)info).isSecure());
        } else {
            this.setSecure(false);
        }
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SecureDiscoveryInformation other = (SecureDiscoveryInformation)((Object)obj);
        if (this.secure != other.secure) {
            return false;
        }
        if (!SecureDiscoveryInformation.areEqual(this.getClaimedIdentifier(), other.getClaimedIdentifier())) {
            return false;
        }
        if (!SecureDiscoveryInformation.areEqual(this.getDelegateIdentifier(), other.getDelegateIdentifier())) {
            return false;
        }
        if (!SecureDiscoveryInformation.areEqual(this.getOPEndpoint(), other.getOPEndpoint())) {
            return false;
        }
        return SecureDiscoveryInformation.areEqual(this.getVersion(), other.getVersion());
    }

    private static <T> boolean areEqual(T o1, T o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }
}

