/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.cache.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.jetspeed.components.util.ConfigurationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class EhCacheConfigResource
extends AbstractResource
implements InitializingBean {
    protected static Logger log = LoggerFactory.getLogger(EhCacheConfigResource.class);
    public static final String EHCACHE_CONFIG_RESOURCE_PROP_NAME = "org.apache.jetspeed.ehcache.config.resource";
    public static final String EHCACHE_CONFIG_RESOURCE_DEFAULT = "ehcache.xml";
    public static final String EHCACHE_CONFIG_RESOURCE_DISTRIBUTED_CACHE = "distributed-ehcache.xml";
    public static final String EHCACHE_GROUP_ADDRESS_PROP_NAME = "org.apache.jetspeed.ehcache.group.address";
    public static final String EHCACHE_GROUP_ADDRESS_DEFAULT = "230.0.0.1";
    public static final String EHCACHE_GROUP_PORT_PROP_NAME = "org.apache.jetspeed.ehcache.group.port";
    public static final String EHCACHE_GROUP_PORT_DEFAULT = "4446";
    public static final String EHCACHE_GROUP_TTL_PROP_NAME = "org.apache.jetspeed.ehcache.group.ttl";
    public static final String EHCACHE_GROUP_TTL_DEFAULT = "1";
    public static final String EHCACHE_GROUP_TTL_TEST_DEFAULT = "0";
    public static final String EHCACHE_HOSTNAME_PROP_NAME = "org.apache.jetspeed.ehcache.hostname";
    public static final String EHCACHE_HOSTNAME_DEFAULT = "";
    public static final String EHCACHE_HOSTNAME_TEST_DEFAULT = "localhost";
    public static final String EHCACHE_PORT_PROP_NAME = "org.apache.jetspeed.ehcache.port";
    public static final String EHCACHE_PORT_DEFAULT = "40001";
    public static final String EHCACHE_PAGE_MANAGER_MAX_ELEMENTS_LEGACY_PROP_NAME = "db.page.manager.cache.size";
    public static final String EHCACHE_PAGE_MANAGER_MAX_ELEMENTS_PROP_NAME = "org.apache.jetspeed.ehcache.pagemanager.maxelements";
    public static final String EHCACHE_PAGE_MANAGER_MAX_ELEMENTS_DEFAULT = "128";
    public static final String EHCACHE_PAGE_MANAGER_ELEMENT_TTL_LEGACY_PROP_NAME = "db.page.manager.cache.expire";
    public static final String EHCACHE_PAGE_MANAGER_ELEMENT_TTL_PROP_NAME = "org.apache.jetspeed.ehcache.pagemanager.element.ttl";
    public static final String EHCACHE_PAGE_MANAGER_ELEMENT_TTL_DEFAULT = "150";
    public static final String EHCACHE_PAGE_MANAGER_MAX_FILES_LEGACY_PROP_NAME = "page.file.cache.size";
    public static final String EHCACHE_PAGE_MANAGER_MAX_FILES_PROP_NAME = "org.apache.jetspeed.ehcache.pagemanager.maxfiles";
    public static final String EHCACHE_PAGE_MANAGER_MAX_FILES_DEFAULT = "1000";
    private static Map overrideSystemProperties;
    private static EhCacheConfigResource instance;
    private ConfigurationProperties configuration;
    private String defaultConfigResource;
    private boolean test;
    private String defaultGroupAddress;
    private String defaultGroupPort;
    private String defaultGroupTTL;
    private String defaultHostname;
    private String defaultPort;
    private String defaultPageManagerMaxElements;
    private String defaultPageManagerElementTTL;
    private String defaultPageManagerMaxFiles;
    private ClassPathResource classPathResource;

    public static synchronized EhCacheConfigResource getInstance(String defaultConfigResource, boolean test) {
        if (test || instance == null) {
            EhCacheConfigResource newInstance = new EhCacheConfigResource();
            newInstance.setDefaultConfigResource(defaultConfigResource);
            newInstance.setTest(test);
            newInstance.afterPropertiesSet();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() {
        Class<EhCacheConfigResource> clazz = EhCacheConfigResource.class;
        synchronized (EhCacheConfigResource.class) {
            String setConfigResource;
            if (this.configuration != null) {
                if (this.configuration.getString(EHCACHE_CONFIG_RESOURCE_PROP_NAME) != null) {
                    this.defaultConfigResource = this.configuration.getString(EHCACHE_CONFIG_RESOURCE_PROP_NAME);
                }
                if (this.configuration.getString(EHCACHE_GROUP_ADDRESS_PROP_NAME) != null) {
                    this.defaultGroupAddress = this.configuration.getString(EHCACHE_GROUP_ADDRESS_PROP_NAME);
                }
                if (this.configuration.getString(EHCACHE_GROUP_PORT_PROP_NAME) != null) {
                    this.defaultGroupPort = this.configuration.getString(EHCACHE_GROUP_PORT_PROP_NAME);
                }
                if (this.configuration.getString(EHCACHE_GROUP_TTL_PROP_NAME) != null) {
                    this.defaultGroupTTL = this.configuration.getString(EHCACHE_GROUP_TTL_PROP_NAME);
                }
                if (this.configuration.getString(EHCACHE_HOSTNAME_PROP_NAME) != null) {
                    this.defaultHostname = this.configuration.getString(EHCACHE_HOSTNAME_PROP_NAME);
                }
                if (this.configuration.getString(EHCACHE_PORT_PROP_NAME) != null) {
                    this.defaultPort = this.configuration.getString(EHCACHE_PORT_PROP_NAME);
                }
                if (this.configuration.getString(EHCACHE_PAGE_MANAGER_MAX_ELEMENTS_PROP_NAME) != null) {
                    this.defaultPageManagerMaxElements = this.configuration.getString(EHCACHE_PAGE_MANAGER_MAX_ELEMENTS_PROP_NAME);
                }
                if (this.configuration.getString(EHCACHE_PAGE_MANAGER_ELEMENT_TTL_PROP_NAME) != null) {
                    this.defaultPageManagerElementTTL = this.configuration.getString(EHCACHE_PAGE_MANAGER_ELEMENT_TTL_PROP_NAME);
                }
                if (this.configuration.getString(EHCACHE_PAGE_MANAGER_MAX_FILES_PROP_NAME) != null) {
                    this.defaultPageManagerMaxFiles = this.configuration.getString(EHCACHE_PAGE_MANAGER_MAX_FILES_PROP_NAME);
                }
            }
            if (overrideSystemProperties == null) {
                String overridePageManagerMaxFiles;
                String overridePageManagerElementTTL;
                String overridePageManagerMaxElements;
                String overridePort;
                String overrideHostname;
                String overrideGroupTTL;
                String overrideGroupPort;
                String overrideGroupAddress;
                overrideSystemProperties = new HashMap();
                String overrideConfigResource = System.getProperty(EHCACHE_CONFIG_RESOURCE_PROP_NAME);
                if (overrideConfigResource != null) {
                    overrideSystemProperties.put(EHCACHE_CONFIG_RESOURCE_PROP_NAME, overrideConfigResource);
                }
                if ((overrideGroupAddress = System.getProperty(EHCACHE_GROUP_ADDRESS_PROP_NAME)) != null) {
                    overrideSystemProperties.put(EHCACHE_GROUP_ADDRESS_PROP_NAME, overrideGroupAddress);
                }
                if ((overrideGroupPort = System.getProperty(EHCACHE_GROUP_PORT_PROP_NAME)) != null) {
                    overrideSystemProperties.put(EHCACHE_GROUP_PORT_PROP_NAME, overrideGroupPort);
                }
                if ((overrideGroupTTL = System.getProperty(EHCACHE_GROUP_TTL_PROP_NAME)) != null) {
                    overrideSystemProperties.put(EHCACHE_GROUP_TTL_PROP_NAME, overrideGroupTTL);
                }
                if ((overrideHostname = System.getProperty(EHCACHE_HOSTNAME_PROP_NAME)) != null) {
                    overrideSystemProperties.put(EHCACHE_HOSTNAME_PROP_NAME, overrideHostname);
                }
                if ((overridePort = System.getProperty(EHCACHE_PORT_PROP_NAME)) != null) {
                    overrideSystemProperties.put(EHCACHE_PORT_PROP_NAME, overridePort);
                }
                if ((overridePageManagerMaxElements = System.getProperty(EHCACHE_PAGE_MANAGER_MAX_ELEMENTS_PROP_NAME)) != null) {
                    overrideSystemProperties.put(EHCACHE_PAGE_MANAGER_MAX_ELEMENTS_PROP_NAME, overridePageManagerMaxElements);
                }
                if ((overridePageManagerElementTTL = System.getProperty(EHCACHE_PAGE_MANAGER_ELEMENT_TTL_PROP_NAME)) != null) {
                    overrideSystemProperties.put(EHCACHE_PAGE_MANAGER_ELEMENT_TTL_PROP_NAME, overridePageManagerElementTTL);
                }
                if ((overridePageManagerMaxFiles = System.getProperty(EHCACHE_PAGE_MANAGER_MAX_FILES_PROP_NAME)) != null) {
                    overrideSystemProperties.put(EHCACHE_PAGE_MANAGER_MAX_FILES_PROP_NAME, overridePageManagerMaxFiles);
                }
            }
            if ((setConfigResource = (String)overrideSystemProperties.get(EHCACHE_CONFIG_RESOURCE_PROP_NAME)) == null) {
                setConfigResource = this.defaultConfigResource != null ? this.defaultConfigResource : EHCACHE_CONFIG_RESOURCE_DEFAULT;
            }
            System.setProperty(EHCACHE_CONFIG_RESOURCE_PROP_NAME, setConfigResource);
            String setGroupAddress = (String)overrideSystemProperties.get(EHCACHE_GROUP_ADDRESS_PROP_NAME);
            if (setGroupAddress == null) {
                setGroupAddress = this.defaultGroupAddress != null ? this.defaultGroupAddress : EHCACHE_GROUP_ADDRESS_DEFAULT;
            }
            System.setProperty(EHCACHE_GROUP_ADDRESS_PROP_NAME, setGroupAddress);
            String setGroupPort = (String)overrideSystemProperties.get(EHCACHE_GROUP_PORT_PROP_NAME);
            if (setGroupPort == null) {
                setGroupPort = this.defaultGroupPort != null ? this.defaultGroupPort : EHCACHE_GROUP_PORT_DEFAULT;
            }
            System.setProperty(EHCACHE_GROUP_PORT_PROP_NAME, setGroupPort);
            String setGroupTTL = (String)overrideSystemProperties.get(EHCACHE_GROUP_TTL_PROP_NAME);
            if (setGroupTTL == null) {
                setGroupTTL = this.defaultGroupTTL != null ? this.defaultGroupTTL : (this.test ? EHCACHE_GROUP_TTL_TEST_DEFAULT : EHCACHE_GROUP_TTL_DEFAULT);
            }
            System.setProperty(EHCACHE_GROUP_TTL_PROP_NAME, setGroupTTL);
            String setHostname = (String)overrideSystemProperties.get(EHCACHE_HOSTNAME_PROP_NAME);
            if (setHostname == null) {
                setHostname = this.defaultHostname != null ? this.defaultHostname : (this.test ? EHCACHE_HOSTNAME_TEST_DEFAULT : EHCACHE_HOSTNAME_DEFAULT);
            }
            System.setProperty(EHCACHE_HOSTNAME_PROP_NAME, setHostname);
            String setPort = (String)overrideSystemProperties.get(EHCACHE_PORT_PROP_NAME);
            if (setPort == null) {
                setPort = this.defaultPort != null ? this.defaultPort : EHCACHE_PORT_DEFAULT;
            }
            System.setProperty(EHCACHE_PORT_PROP_NAME, setPort);
            String setPageManagerMaxElements = (String)overrideSystemProperties.get(EHCACHE_PAGE_MANAGER_MAX_ELEMENTS_PROP_NAME);
            if (setPageManagerMaxElements == null) {
                String string = setPageManagerMaxElements = this.defaultPageManagerMaxElements != null ? this.defaultPageManagerMaxElements : System.getProperty(EHCACHE_PAGE_MANAGER_MAX_ELEMENTS_LEGACY_PROP_NAME, EHCACHE_PAGE_MANAGER_MAX_ELEMENTS_DEFAULT);
                if (setPageManagerMaxElements != null && Integer.parseInt(setPageManagerMaxElements) < 0) {
                    setPageManagerMaxElements = EHCACHE_PAGE_MANAGER_MAX_ELEMENTS_DEFAULT;
                }
            }
            System.setProperty(EHCACHE_PAGE_MANAGER_MAX_ELEMENTS_PROP_NAME, setPageManagerMaxElements);
            String setPageManagerElementTTL = (String)overrideSystemProperties.get(EHCACHE_PAGE_MANAGER_ELEMENT_TTL_PROP_NAME);
            if (setPageManagerElementTTL == null) {
                String string = setPageManagerElementTTL = this.defaultPageManagerElementTTL != null ? this.defaultPageManagerElementTTL : System.getProperty(EHCACHE_PAGE_MANAGER_ELEMENT_TTL_LEGACY_PROP_NAME, EHCACHE_PAGE_MANAGER_ELEMENT_TTL_DEFAULT);
                if (setPageManagerElementTTL != null && Integer.parseInt(setPageManagerElementTTL) < 0) {
                    setPageManagerElementTTL = EHCACHE_PAGE_MANAGER_ELEMENT_TTL_DEFAULT;
                }
            }
            System.setProperty(EHCACHE_PAGE_MANAGER_ELEMENT_TTL_PROP_NAME, setPageManagerElementTTL);
            String setPageManagerMaxFiles = (String)overrideSystemProperties.get(EHCACHE_PAGE_MANAGER_MAX_FILES_PROP_NAME);
            if (setPageManagerMaxFiles == null) {
                setPageManagerMaxFiles = this.defaultPageManagerMaxFiles != null ? this.defaultPageManagerMaxFiles : System.getProperty(EHCACHE_PAGE_MANAGER_MAX_FILES_LEGACY_PROP_NAME, EHCACHE_PAGE_MANAGER_MAX_FILES_DEFAULT);
            }
            System.setProperty(EHCACHE_PAGE_MANAGER_MAX_FILES_PROP_NAME, setPageManagerMaxFiles);
            String configResource = System.getProperty(EHCACHE_CONFIG_RESOURCE_PROP_NAME);
            log.info("Configured with resource: " + configResource);
            this.classPathResource = new ClassPathResource(configResource);
            instance = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public Resource createRelative(String relativePath) throws IOException {
        return this.classPathResource.createRelative(relativePath);
    }

    public File getFile() throws IOException {
        return this.classPathResource.getFile();
    }

    public String getFilename() throws IllegalStateException {
        return this.classPathResource.getFilename();
    }

    public URL getURL() throws IOException {
        return this.classPathResource.getURL();
    }

    public String getDescription() {
        return this.classPathResource.getDescription();
    }

    public InputStream getInputStream() throws IOException {
        return this.classPathResource.getInputStream();
    }

    public void setConfiguration(ConfigurationProperties configuration) {
        this.configuration = configuration;
    }

    public void setDefaultConfigResource(String defaultConfigResource) {
        this.defaultConfigResource = defaultConfigResource;
    }

    public void setTest(boolean test) {
        this.test = test;
    }

    public void setDefaultGroupAddress(String defaultGroupAddress) {
        this.defaultGroupAddress = defaultGroupAddress;
    }

    public void setDefaultGroupPort(String defaultGroupPort) {
        this.defaultGroupPort = defaultGroupPort;
    }

    public void setDefaultGroupTTL(String defaultGroupTTL) {
        this.defaultGroupTTL = defaultGroupTTL;
    }

    public void setDefaultHostname(String defaultHostname) {
        this.defaultHostname = defaultHostname;
    }

    public void setDefaultPort(String defaultPort) {
        this.defaultPort = defaultPort;
    }

    public void setDefaultPageManagerMaxElements(String defaultPageManagerMaxElements) {
        this.defaultPageManagerMaxElements = defaultPageManagerMaxElements;
    }

    public void setDefaultPageManagerElementTTL(String defaultPageManagerElementTTL) {
        this.defaultPageManagerElementTTL = defaultPageManagerElementTTL;
    }

    public void setDefaultPageManagerMaxFiles(String defaultPageManagerMaxFiles) {
        this.defaultPageManagerMaxFiles = defaultPageManagerMaxFiles;
    }
}

