/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components;

import org.apache.jetspeed.components.RefreshableBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class ContextRefreshableBeanInitializer
implements ApplicationListener {
    Logger log = LoggerFactory.getLogger(ContextRefreshableBeanInitializer.class);
    private RefreshableBean bean;

    public ContextRefreshableBeanInitializer(RefreshableBean bean) {
        this.bean = bean;
    }

    public void onApplicationEvent(ApplicationEvent appEvent) {
        if (appEvent instanceof ContextRefreshedEvent && this.bean != null) {
            try {
                this.bean.refresh();
            }
            catch (Exception ex) {
                this.log.error("Failed to refresh bean", (Throwable)ex);
            }
        }
    }
}

