/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components;

import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.jetspeed.components.FilteringListableBeanFactory;
import org.apache.jetspeed.components.JetspeedBeanDefinitionFilter;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class FilteringXmlWebApplicationContext
extends XmlWebApplicationContext {
    private JetspeedBeanDefinitionFilter filter;

    public FilteringXmlWebApplicationContext(JetspeedBeanDefinitionFilter filter, String[] configLocations, Properties initProperties, ServletContext servletContext) {
        this(filter, configLocations, initProperties, servletContext, null);
    }

    public FilteringXmlWebApplicationContext(JetspeedBeanDefinitionFilter filter, String[] configLocations, Properties initProperties, ServletContext servletContext, ApplicationContext parent) {
        if (parent != null) {
            this.setParent(parent);
        }
        if (initProperties != null) {
            PropertyPlaceholderConfigurer ppc = new PropertyPlaceholderConfigurer();
            ppc.setIgnoreUnresolvablePlaceholders(true);
            ppc.setSystemPropertiesMode(1);
            ppc.setProperties(initProperties);
            this.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)ppc);
        }
        this.setConfigLocations(configLocations);
        this.setServletContext(servletContext);
        this.filter = filter;
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        return new FilteringListableBeanFactory(this.filter, this.getInternalParentBeanFactory());
    }
}

