/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlet;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventPortlet;
import javax.portlet.GenericPortlet;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceServingPortlet;
import javax.portlet.UnavailableException;
import javax.portlet.WindowState;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.container.JetspeedPortletConfig;
import org.apache.jetspeed.factory.PortletFactory;
import org.apache.jetspeed.factory.PortletInstance;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.om.portlet.Supports;
import org.apache.jetspeed.portlet.SupportsHeaderPhase;
import org.apache.jetspeed.util.BaseObjectProxy;

public class PortletObjectProxy
extends BaseObjectProxy {
    private static Method renderMethod;
    private static Method processActionMethod;
    private Object portletObject;
    private PortletInstance customConfigModePortletInstance;
    private boolean genericPortletInvocable;
    private Method portletDoEditMethod;
    private boolean autoSwitchEditDefaultsModeToEditMode;
    private boolean autoSwitchConfigMode;
    private String customConfigModePortletUniqueName;
    private List<Supports> supports;

    public static Object createProxy(Object proxiedObject, boolean autoSwitchEditDefaultsModeToEditMode, boolean autoSwitchConfigMode, String customConfigModePortletUniqueName) {
        HashSet interfaces = new HashSet();
        interfaces.add(Portlet.class);
        Class<?> current = proxiedObject.getClass();
        while (current != null) {
            try {
                Class<?>[] currentInterfaces = current.getInterfaces();
                for (int i = 0; i < currentInterfaces.length; ++i) {
                    if (currentInterfaces[i] == Portlet.class) continue;
                    interfaces.add(currentInterfaces[i]);
                }
                current = current.getSuperclass();
            }
            catch (Exception e) {
                current = null;
            }
        }
        Class<?> proxiedClass = proxiedObject.getClass();
        ClassLoader classLoader = proxiedClass.getClassLoader();
        PortletObjectProxy handler = new PortletObjectProxy(proxiedObject, autoSwitchEditDefaultsModeToEditMode, autoSwitchConfigMode, customConfigModePortletUniqueName);
        return Proxy.newProxyInstance(classLoader, interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)handler);
    }

    private PortletObjectProxy(Object portletObject, boolean autoSwitchEditDefaultsModeToEditMode, boolean autoSwitchConfigMode, String customConfigModePortletUniqueName) {
        this.portletObject = portletObject;
        this.autoSwitchEditDefaultsModeToEditMode = autoSwitchEditDefaultsModeToEditMode;
        this.autoSwitchConfigMode = autoSwitchConfigMode;
        this.customConfigModePortletUniqueName = customConfigModePortletUniqueName;
        if (portletObject instanceof GenericPortlet) {
            try {
                this.portletDoEditMethod = this.portletObject.getClass().getMethod("doEdit", RenderRequest.class, RenderResponse.class);
                if (Modifier.isPublic(this.portletDoEditMethod.getModifiers())) {
                    this.genericPortletInvocable = true;
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        Class<?> declaringClass = method.getDeclaringClass();
        try {
            if (declaringClass == Portlet.class || declaringClass == ResourceServingPortlet.class || declaringClass == EventPortlet.class) {
                if (renderMethod.equals(method)) {
                    this.proxyRender((RenderRequest)args[0], (RenderResponse)args[1]);
                    return null;
                }
                if (processActionMethod.equals(method)) {
                    this.proxyProcessAction((ActionRequest)args[0], (ActionResponse)args[1]);
                } else {
                    result = method.invoke(this.portletObject, args);
                }
            } else {
                result = declaringClass == SupportsHeaderPhase.class ? method.invoke(this.portletObject, args) : super.invoke(proxy, method, args);
            }
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
        return result;
    }

    protected void proxyRender(RenderRequest request, RenderResponse response) throws PortletException, IOException, Exception {
        PortletMode mode = request.getPortletMode();
        boolean autoSwitchConfigMode = false;
        boolean autoSwitchToEditMode = false;
        if (this.autoSwitchConfigMode && JetspeedActions.CONFIG_MODE.equals((Object)mode)) {
            autoSwitchConfigMode = true;
        }
        if (this.autoSwitchEditDefaultsModeToEditMode && this.genericPortletInvocable && JetspeedActions.EDIT_DEFAULTS_MODE.equals((Object)mode) && !this.isSupportingEditDefaultsMode((GenericPortlet)this.portletObject)) {
            autoSwitchToEditMode = true;
        }
        if (autoSwitchConfigMode) {
            try {
                if (this.customConfigModePortletInstance == null) {
                    this.refreshCustomConfigModePortletInstance();
                }
                this.customConfigModePortletInstance.render(request, response);
            }
            catch (UnavailableException e) {
                this.refreshCustomConfigModePortletInstance();
                this.customConfigModePortletInstance.render(request, response);
            }
        } else if (autoSwitchToEditMode) {
            GenericPortlet genericPortlet = (GenericPortlet)this.portletObject;
            WindowState state = request.getWindowState();
            if (!WindowState.MINIMIZED.equals((Object)state)) {
                String title = genericPortlet.getPortletConfig().getResourceBundle(request.getLocale()).getString("javax.portlet.title");
                response.setTitle(title);
                this.portletDoEditMethod.invoke((Object)genericPortlet, request, response);
            }
        } else {
            ((Portlet)this.portletObject).render(request, response);
        }
    }

    protected void proxyProcessAction(ActionRequest request, ActionResponse response) throws PortletException, IOException, Exception {
        PortletMode mode = request.getPortletMode();
        boolean autoSwitchConfigMode = false;
        if (this.autoSwitchConfigMode && JetspeedActions.CONFIG_MODE.equals((Object)mode)) {
            autoSwitchConfigMode = true;
        }
        if (autoSwitchConfigMode) {
            try {
                if (this.customConfigModePortletInstance == null) {
                    this.refreshCustomConfigModePortletInstance();
                }
                this.customConfigModePortletInstance.processAction(request, response);
            }
            catch (UnavailableException e) {
                this.refreshCustomConfigModePortletInstance();
                this.customConfigModePortletInstance.processAction(request, response);
            }
        } else {
            ((Portlet)this.portletObject).processAction(request, response);
        }
    }

    private boolean isSupportingEditDefaultsMode(GenericPortlet portlet) {
        if (this.supports == null) {
            try {
                JetspeedPortletConfig config = (JetspeedPortletConfig)portlet.getPortletConfig();
                PortletDefinition portletDef = config.getPortletDefinition();
                this.supports = portletDef.getSupports();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.supports != null) {
            String pm = JetspeedActions.EDIT_DEFAULTS_MODE.toString();
            for (Supports s : this.supports) {
                if (!s.getPortletModes().contains(pm)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private void refreshCustomConfigModePortletInstance() throws PortletException {
        PortletRegistry registry = (PortletRegistry)Jetspeed.getComponentManager().getComponent((Object)"portletRegistry");
        PortletFactory portletFactory = (PortletFactory)Jetspeed.getComponentManager().getComponent((Object)"portletFactory");
        ServletContext portalAppContext = ((ServletConfig)Jetspeed.getComponentManager().getComponent((Object)"ServletConfig")).getServletContext();
        PortletDefinition portletDef = registry.getPortletDefinitionByUniqueName(this.customConfigModePortletUniqueName, true);
        PortletApplication portletApp = portletDef.getApplication();
        ServletContext portletAppContext = portalAppContext.getContext(portletApp.getContextPath());
        this.customConfigModePortletInstance = portletFactory.getPortletInstance(portletAppContext, portletDef, false);
    }

    static {
        try {
            renderMethod = Portlet.class.getMethod("render", RenderRequest.class, RenderResponse.class);
            processActionMethod = Portlet.class.getMethod("processAction", ActionRequest.class, ActionResponse.class);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }
}

