/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.jetspeed.util.AbstractFileSystemHelper;
import org.apache.jetspeed.util.DirectoryHelper;
import org.apache.jetspeed.util.FileSystemHelper;

public class JarHelper
extends AbstractFileSystemHelper
implements FileSystemHelper {
    protected JarFile jarFile;
    protected DirectoryHelper dirHelper;
    protected File file;
    private boolean deleteOnClose;
    protected File jarRoot;

    public JarHelper(File file, boolean deleteOnClose) throws IOException {
        this.jarFile = new JarFile(file);
        this.deleteOnClose = deleteOnClose;
        this.file = file;
        String tmpDirPath = System.getProperty("java.io.tmpdir");
        File tmpDir = new File(tmpDirPath);
        this.jarRoot = null;
        this.jarRoot = new File(tmpDir, "jetspeed-jar-tmp/" + file.getName());
        if (!this.jarRoot.exists()) {
            this.jarRoot.mkdirs();
        }
        this.jarRoot.deleteOnExit();
        Enumeration<JarEntry> entries = this.jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            String name = jarEntry.getName();
            if (jarEntry.isDirectory()) {
                File newDir = new File(this.jarRoot, name);
                newDir.mkdir();
                newDir.deleteOnExit();
                continue;
            }
            this.copyEntryToFile(this.jarFile, this.jarRoot, jarEntry);
        }
        this.dirHelper = new DirectoryHelper(this.jarRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyEntryToFile(JarFile jarFile, File jarRoot, JarEntry jarEntry) throws IOException, FileNotFoundException {
        String name = jarEntry.getName();
        File file = new File(jarRoot, name);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
            file.getParentFile().deleteOnExit();
        }
        file.createNewFile();
        file.deleteOnExit();
        InputStream is = null;
        OutputStream os = null;
        try {
            int len;
            is = jarFile.getInputStream(jarEntry);
            os = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) > 0) {
                os.write(buf, 0, len);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public void copyFrom(File directory, FileFilter fileFilter) throws IOException {
        this.dirHelper.copyFrom(directory, fileFilter);
    }

    public void copyFrom(File directory) throws IOException {
        this.dirHelper.copyFrom(directory);
    }

    @Override
    public File getRootDirectory() {
        return this.dirHelper.getRootDirectory();
    }

    public boolean remove() {
        return this.dirHelper.remove();
    }

    public void close() throws IOException {
        this.jarFile.close();
        if (this.deleteOnClose) {
            this.dirHelper.remove();
        }
        this.dirHelper.close();
    }

    public String getSourcePath() {
        return this.file.getAbsolutePath();
    }
}

