/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class BaseObjectProxy
implements InvocationHandler {
    protected static Method hashCodeMethod;
    protected static Method equalsMethod;
    protected static Method toStringMethod;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Integer result = null;
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass != Object.class) throw new InternalError("unexpected Object method dispatched: " + method);
        if (hashCodeMethod.equals(method)) {
            return this.proxyHashCode(proxy);
        }
        if (equalsMethod.equals(method)) {
            return this.proxyEquals(proxy, args[0]);
        }
        if (!toStringMethod.equals(method)) throw new InternalError("unexpected Object method dispatched: " + method);
        return this.proxyToString(proxy);
    }

    protected Integer proxyHashCode(Object proxy) {
        return new Integer(System.identityHashCode(proxy));
    }

    protected Boolean proxyEquals(Object proxy, Object other) {
        return proxy == other ? Boolean.TRUE : Boolean.FALSE;
    }

    protected String proxyToString(Object proxy) {
        return proxy.getClass().getName() + '@' + Integer.toHexString(proxy.hashCode());
    }

    static {
        try {
            hashCodeMethod = Object.class.getMethod("hashCode", null);
            equalsMethod = Object.class.getMethod("equals", Object.class);
            toStringMethod = Object.class.getMethod("toString", null);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }
}

