/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.idgenerator;

import org.apache.jetspeed.idgenerator.IdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JetspeedIdGenerator
implements IdGenerator {
    private static final Logger log = LoggerFactory.getLogger(JetspeedIdGenerator.class);
    private static final long DEFAULT_CONFIG_COUNTER_START = 65536L;
    private static final String DEFAULT_CONFIG_PEID_PREFIX = "P-";
    private static final String DEFAULT_CONFIG_PEID_SUFFIX = "";
    private String peidPrefix = null;
    private String peidSuffix = null;
    protected long idCounter;

    public JetspeedIdGenerator() {
        this.idCounter = 65536L;
        this.peidPrefix = DEFAULT_CONFIG_PEID_PREFIX;
        this.peidSuffix = DEFAULT_CONFIG_PEID_SUFFIX;
    }

    public JetspeedIdGenerator(long counterStart) {
        this.idCounter = counterStart;
        this.peidPrefix = DEFAULT_CONFIG_PEID_PREFIX;
        this.peidSuffix = DEFAULT_CONFIG_PEID_SUFFIX;
    }

    public JetspeedIdGenerator(long counterStart, String prefix, String suffix) {
        this.idCounter = counterStart;
        this.peidPrefix = prefix;
        this.peidSuffix = suffix;
    }

    public void start() {
        log.info("Start JetspeedIdGenerator");
    }

    public void stop() {
        log.info("Shutdown for JetspeedIdGenerator called. idCounter = " + this.idCounter + " (" + Long.toHexString(this.idCounter) + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextPeid() {
        Class<JetspeedIdGenerator> clazz = JetspeedIdGenerator.class;
        synchronized (JetspeedIdGenerator.class) {
            long newid = this.idCounter++;
            // ** MonitorExit[var3_1] (shouldn't be in output)
            return this.peidPrefix + Long.toHexString(System.currentTimeMillis()) + "-" + Long.toHexString(newid) + this.peidSuffix;
        }
    }
}

