/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.apache.jetspeed.om.page.BaseFragmentElement;
import org.apache.jetspeed.om.page.FragmentProperty;
import org.apache.jetspeed.om.page.impl.BaseFragmentElementImpl;
import org.apache.jetspeed.om.page.impl.FragmentPropertyImpl;
import org.apache.jetspeed.page.FragmentPropertyList;

public class FragmentPropertyListImpl
extends AbstractList
implements FragmentPropertyList {
    private BaseFragmentElementImpl fragment;
    private List properties = new ArrayList();
    private List removedProperties;

    public FragmentPropertyListImpl(BaseFragmentElementImpl fragment) {
        this.fragment = fragment;
    }

    public synchronized void add(int index, Object element) {
        FragmentPropertyImpl add = (FragmentPropertyImpl)element;
        if (add.getName() == null || add.getValue() == null) {
            throw new IllegalArgumentException("Property name and value must be set.");
        }
        FragmentProperty addMatch = this.getMatchingProperty(add);
        if (addMatch != null) {
            addMatch.setValue(add.getValue());
        } else {
            add = this.recycleProperty(add);
            this.properties.add(index, add);
        }
    }

    public synchronized Object get(int index) {
        return this.properties.get(index);
    }

    public synchronized Object remove(int index) {
        FragmentPropertyImpl removed = (FragmentPropertyImpl)this.properties.remove(index);
        return this.removedProperty(removed);
    }

    public synchronized Object set(int index, Object element) {
        FragmentPropertyImpl set = (FragmentPropertyImpl)element;
        if (set.getName() == null || set.getValue() == null) {
            throw new IllegalArgumentException("Property name and value must be set.");
        }
        FragmentProperty setMatch = this.getMatchingProperty(set);
        if (setMatch != null) {
            setMatch.setValue(set.getValue());
            if (this.properties.get(index) != setMatch) {
                return this.remove(index);
            }
            return null;
        }
        set = this.recycleProperty(set);
        FragmentPropertyImpl replaced = this.properties.set(index, set);
        return this.removedProperty(replaced);
    }

    public synchronized int size() {
        return this.properties.size();
    }

    public BaseFragmentElement getFragmentElement() {
        return this.fragment;
    }

    public List getProperties() {
        return this.properties;
    }

    public List getRemovedProperties() {
        return this.removedProperties;
    }

    public synchronized FragmentProperty getMatchingProperty(FragmentProperty match) {
        for (FragmentPropertyImpl test : this.properties) {
            if (!test.match(match)) continue;
            return test;
        }
        return null;
    }

    public synchronized void clearProperties() {
        this.properties.clear();
        if (this.removedProperties != null) {
            this.removedProperties.clear();
        }
    }

    protected FragmentPropertyImpl recycleProperty(FragmentPropertyImpl original) {
        if (this.removedProperties != null && !this.removedProperties.isEmpty()) {
            FragmentPropertyImpl recycle = (FragmentPropertyImpl)this.removedProperties.remove(this.removedProperties.size() - 1);
            recycle.setName(original.getName());
            recycle.setScope(original.getScope());
            recycle.setScopeValue(original.getScopeValue());
            recycle.setValue(original.getValue());
            return recycle;
        }
        return original;
    }

    protected FragmentPropertyImpl removedProperty(FragmentPropertyImpl removed) {
        if (removed != null && removed.getIdentity() != 0) {
            if (this.removedProperties == null) {
                this.removedProperties = new ArrayList();
            }
            this.removedProperties.add(removed);
        }
        return removed;
    }
}

