/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page.impl;

import java.lang.ref.WeakReference;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.cache.JetspeedCache;
import org.apache.jetspeed.components.dao.InitablePersistenceBrokerDaoSupport;
import org.apache.jetspeed.idgenerator.IdGenerator;
import org.apache.jetspeed.om.common.SecurityConstraint;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.folder.InvalidFolderException;
import org.apache.jetspeed.om.folder.MenuDefinition;
import org.apache.jetspeed.om.folder.MenuExcludeDefinition;
import org.apache.jetspeed.om.folder.MenuIncludeDefinition;
import org.apache.jetspeed.om.folder.MenuOptionsDefinition;
import org.apache.jetspeed.om.folder.MenuSeparatorDefinition;
import org.apache.jetspeed.om.folder.impl.FolderImpl;
import org.apache.jetspeed.om.folder.impl.FolderMenuDefinitionImpl;
import org.apache.jetspeed.om.folder.impl.FolderMenuExcludeDefinitionImpl;
import org.apache.jetspeed.om.folder.impl.FolderMenuIncludeDefinitionImpl;
import org.apache.jetspeed.om.folder.impl.FolderMenuOptionsDefinitionImpl;
import org.apache.jetspeed.om.folder.impl.FolderMenuSeparatorDefinitionImpl;
import org.apache.jetspeed.om.folder.impl.FolderSecurityConstraintImpl;
import org.apache.jetspeed.om.page.BaseFragmentElement;
import org.apache.jetspeed.om.page.BaseFragmentsElement;
import org.apache.jetspeed.om.page.DynamicPage;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.page.FragmentDefinition;
import org.apache.jetspeed.om.page.FragmentProperty;
import org.apache.jetspeed.om.page.FragmentReference;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.PageFragment;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.PageTemplate;
import org.apache.jetspeed.om.page.SecurityConstraintsDef;
import org.apache.jetspeed.om.page.impl.BaseFragmentElementImpl;
import org.apache.jetspeed.om.page.impl.BaseFragmentsElementImpl;
import org.apache.jetspeed.om.page.impl.DynamicPageImpl;
import org.apache.jetspeed.om.page.impl.FragmentDefinitionImpl;
import org.apache.jetspeed.om.page.impl.FragmentImpl;
import org.apache.jetspeed.om.page.impl.FragmentPreferenceImpl;
import org.apache.jetspeed.om.page.impl.FragmentPropertyImpl;
import org.apache.jetspeed.om.page.impl.FragmentPropertyListImpl;
import org.apache.jetspeed.om.page.impl.FragmentReferenceImpl;
import org.apache.jetspeed.om.page.impl.FragmentSecurityConstraintImpl;
import org.apache.jetspeed.om.page.impl.LinkImpl;
import org.apache.jetspeed.om.page.impl.LinkSecurityConstraintImpl;
import org.apache.jetspeed.om.page.impl.PageFragmentImpl;
import org.apache.jetspeed.om.page.impl.PageImpl;
import org.apache.jetspeed.om.page.impl.PageMenuDefinitionImpl;
import org.apache.jetspeed.om.page.impl.PageMenuExcludeDefinitionImpl;
import org.apache.jetspeed.om.page.impl.PageMenuIncludeDefinitionImpl;
import org.apache.jetspeed.om.page.impl.PageMenuOptionsDefinitionImpl;
import org.apache.jetspeed.om.page.impl.PageMenuSeparatorDefinitionImpl;
import org.apache.jetspeed.om.page.impl.PageSecurityConstraintImpl;
import org.apache.jetspeed.om.page.impl.PageSecurityImpl;
import org.apache.jetspeed.om.page.impl.PageSecuritySecurityConstraintImpl;
import org.apache.jetspeed.om.page.impl.PageTemplateImpl;
import org.apache.jetspeed.om.page.impl.SecurityConstraintsDefImpl;
import org.apache.jetspeed.om.page.impl.SecurityConstraintsImpl;
import org.apache.jetspeed.om.preference.FragmentPreference;
import org.apache.jetspeed.page.DelegatingPageManager;
import org.apache.jetspeed.page.FolderNotRemovedException;
import org.apache.jetspeed.page.FolderNotUpdatedException;
import org.apache.jetspeed.page.FragmentPropertyList;
import org.apache.jetspeed.page.FragmentPropertyManagement;
import org.apache.jetspeed.page.LinkNotRemovedException;
import org.apache.jetspeed.page.LinkNotUpdatedException;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.PageManagerEventListener;
import org.apache.jetspeed.page.PageManagerSecurityUtils;
import org.apache.jetspeed.page.PageManagerUtils;
import org.apache.jetspeed.page.PageNotFoundException;
import org.apache.jetspeed.page.PageNotRemovedException;
import org.apache.jetspeed.page.PageNotUpdatedException;
import org.apache.jetspeed.page.document.DocumentException;
import org.apache.jetspeed.page.document.DocumentNotFoundException;
import org.apache.jetspeed.page.document.FailedToDeleteDocumentException;
import org.apache.jetspeed.page.document.FailedToUpdateDocumentException;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.document.NodeSet;
import org.apache.jetspeed.page.document.impl.NodeImpl;
import org.apache.jetspeed.page.impl.DatabasePageManagerCache;
import org.apache.jetspeed.page.impl.DatabasePageManagerCachedFragmentPropertyList;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;
import org.apache.jetspeed.page.impl.TransactionedOperation;
import org.apache.jetspeed.security.JSSubject;
import org.apache.jetspeed.security.SubjectHelper;
import org.apache.jetspeed.security.User;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabasePageManager
extends InitablePersistenceBrokerDaoSupport
implements PageManager,
FragmentPropertyManagement {
    private static Logger log = LoggerFactory.getLogger(DatabasePageManager.class);
    private static final int MIN_THREAD_CACHE_SIZE = 16;
    private static ThreadLocal fragmentPropertyListsCache = new ThreadLocal();
    private static Map modelClasses = new HashMap();
    private DelegatingPageManager delegator;
    private int maxThreadCacheSize;
    private PageManager pageManagerProxy;

    public DatabasePageManager(String repositoryPath, IdGenerator generator, boolean isPermissionsSecurity, boolean isConstraintsSecurity, JetspeedCache oidCache, JetspeedCache pathCache, JetspeedCache propertiesCache, JetspeedCache propertiesPathCache, JetspeedCache principalPropertiesCache, JetspeedCache principalPropertiesPathCache) {
        super(repositoryPath);
        this.delegator = new DelegatingPageManager(generator, isPermissionsSecurity, isConstraintsSecurity, modelClasses);
        this.maxThreadCacheSize = Math.max(Math.max(Math.max(oidCache.getMaxSize() / 10, propertiesCache.getMaxSize() / 10), principalPropertiesCache.getMaxSize() / 10), 16);
        DatabasePageManagerCache.cacheInit(oidCache, pathCache, propertiesCache, propertiesPathCache, principalPropertiesCache, principalPropertiesPathCache, this);
    }

    public void init() throws Exception {
        super.init();
        this.delegator.init();
    }

    public void destroy() {
        this.delegator.destroy();
    }

    public PageManager getPageManagerProxy() {
        return this.pageManagerProxy;
    }

    public void setPageManagerProxy(PageManager proxy) {
        if (this.pageManagerProxy != proxy) {
            this.pageManagerProxy = proxy;
            DatabasePageManagerCache.setPageManagerProxy(proxy);
        }
    }

    public boolean getConstraintsEnabled() {
        return this.delegator.getConstraintsEnabled();
    }

    public boolean getPermissionsEnabled() {
        return this.delegator.getPermissionsEnabled();
    }

    public long getNodeReapingInterval() {
        return this.delegator.getNodeReapingInterval();
    }

    public Page newPage(String path) {
        return this.delegator.newPage(path);
    }

    public PageTemplate newPageTemplate(String path) {
        return this.delegator.newPageTemplate(path);
    }

    public DynamicPage newDynamicPage(String path) {
        return this.delegator.newDynamicPage(path);
    }

    public FragmentDefinition newFragmentDefinition(String path) {
        return this.delegator.newFragmentDefinition(path);
    }

    public Folder newFolder(String path) {
        return this.delegator.newFolder(path);
    }

    public Link newLink(String path) {
        return this.delegator.newLink(path);
    }

    public PageSecurity newPageSecurity() {
        return this.delegator.newPageSecurity();
    }

    public Fragment newFragment() {
        return this.delegator.newFragment();
    }

    public Fragment newPortletFragment() {
        return this.delegator.newPortletFragment();
    }

    public FragmentReference newFragmentReference() {
        return this.delegator.newFragmentReference();
    }

    public PageFragment newPageFragment() {
        return this.delegator.newPageFragment();
    }

    public MenuDefinition newFolderMenuDefinition() {
        return this.delegator.newFolderMenuDefinition();
    }

    public MenuExcludeDefinition newFolderMenuExcludeDefinition() {
        return this.delegator.newFolderMenuExcludeDefinition();
    }

    public MenuIncludeDefinition newFolderMenuIncludeDefinition() {
        return this.delegator.newFolderMenuIncludeDefinition();
    }

    public MenuOptionsDefinition newFolderMenuOptionsDefinition() {
        return this.delegator.newFolderMenuOptionsDefinition();
    }

    public MenuSeparatorDefinition newFolderMenuSeparatorDefinition() {
        return this.delegator.newFolderMenuSeparatorDefinition();
    }

    public MenuDefinition newPageMenuDefinition() {
        return this.delegator.newPageMenuDefinition();
    }

    public MenuExcludeDefinition newPageMenuExcludeDefinition() {
        return this.delegator.newPageMenuExcludeDefinition();
    }

    public MenuIncludeDefinition newPageMenuIncludeDefinition() {
        return this.delegator.newPageMenuIncludeDefinition();
    }

    public MenuOptionsDefinition newPageMenuOptionsDefinition() {
        return this.delegator.newPageMenuOptionsDefinition();
    }

    public MenuSeparatorDefinition newPageMenuSeparatorDefinition() {
        return this.delegator.newPageMenuSeparatorDefinition();
    }

    public SecurityConstraints newSecurityConstraints() {
        return this.delegator.newSecurityConstraints();
    }

    public SecurityConstraint newFolderSecurityConstraint() {
        return this.delegator.newFolderSecurityConstraint();
    }

    public SecurityConstraint newPageSecurityConstraint() {
        return this.delegator.newPageSecurityConstraint();
    }

    public SecurityConstraint newFragmentSecurityConstraint() {
        return this.delegator.newFragmentSecurityConstraint();
    }

    public SecurityConstraint newLinkSecurityConstraint() {
        return this.delegator.newLinkSecurityConstraint();
    }

    public SecurityConstraint newPageSecuritySecurityConstraint() {
        return this.delegator.newPageSecuritySecurityConstraint();
    }

    public SecurityConstraintsDef newSecurityConstraintsDef() {
        return this.delegator.newSecurityConstraintsDef();
    }

    public FragmentPreference newFragmentPreference() {
        return this.delegator.newFragmentPreference();
    }

    public FragmentProperty newFragmentProperty() {
        return this.delegator.newFragmentProperty();
    }

    public void addListener(PageManagerEventListener listener) {
        this.delegator.addListener(listener);
    }

    public void removeListener(PageManagerEventListener listener) {
        this.delegator.removeListener(listener);
    }

    public void reset() {
        this.delegator.reset();
        DatabasePageManagerCache.cacheClear();
    }

    public void shutdown() {
        this.delegator.shutdown();
    }

    public Page getPage(String path) throws PageNotFoundException, NodeException {
        return (Page)this.getFragmentsElement(Page.class, PageImpl.class, path);
    }

    public PageTemplate getPageTemplate(String path) throws PageNotFoundException, NodeException {
        return (PageTemplate)this.getFragmentsElement(PageTemplate.class, PageTemplateImpl.class, path);
    }

    public DynamicPage getDynamicPage(String path) throws PageNotFoundException, NodeException {
        return (DynamicPage)this.getFragmentsElement(DynamicPage.class, DynamicPageImpl.class, path);
    }

    public FragmentDefinition getFragmentDefinition(String path) throws PageNotFoundException, NodeException {
        return (FragmentDefinition)this.getFragmentsElement(FragmentDefinition.class, FragmentDefinitionImpl.class, path);
    }

    protected BaseFragmentsElement getFragmentsElement(Class fragmentsElementType, Class fragmentsElementImplType, String path) throws PageNotFoundException, NodeException {
        NodeImpl cachedNode = DatabasePageManagerCache.cacheLookup(path = NodeImpl.getCanonicalNodePath(path));
        if (fragmentsElementType.isInstance(cachedNode)) {
            cachedNode.checkAccess(JetspeedActions.VIEW);
            return (BaseFragmentsElement)cachedNode;
        }
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("path", (Object)path);
            QueryByCriteria query = QueryFactory.newQuery((Class)fragmentsElementImplType, (Criteria)filter);
            BaseFragmentsElement fragmentsElement = (BaseFragmentsElement)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
            if (fragmentsElement == null) {
                throw new PageNotFoundException("Fragments/page element " + path + " not found.");
            }
            fragmentsElement.checkAccess(JetspeedActions.VIEW);
            return fragmentsElement;
        }
        catch (PageNotFoundException pnfe) {
            throw pnfe;
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new PageNotFoundException("Fragments/page element " + path + " not found.", (Throwable)e);
        }
    }

    public Link getLink(String path) throws DocumentNotFoundException, NodeException {
        NodeImpl cachedNode = DatabasePageManagerCache.cacheLookup(path = NodeImpl.getCanonicalNodePath(path));
        if (cachedNode instanceof Link) {
            cachedNode.checkAccess(JetspeedActions.VIEW);
            return (Link)cachedNode;
        }
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("path", (Object)path);
            QueryByCriteria query = QueryFactory.newQuery(LinkImpl.class, (Criteria)filter);
            Link link = (Link)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
            if (link == null) {
                throw new DocumentNotFoundException("Link " + path + " not found.");
            }
            link.checkAccess(JetspeedActions.VIEW);
            return link;
        }
        catch (DocumentNotFoundException dnfe) {
            throw dnfe;
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new DocumentNotFoundException("Link " + path + " not found.", (Throwable)e);
        }
    }

    public boolean checkConstraint(String securityConstraintName, String actions) {
        try {
            PageSecurity security = this.getPageSecurity();
            SecurityConstraintsDef def = security.getSecurityConstraintsDef(securityConstraintName);
            if (def != null) {
                return PageManagerSecurityUtils.checkConstraint(def, actions);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public PageSecurity getPageSecurity() throws DocumentNotFoundException, NodeException {
        String path = "/page.security";
        NodeImpl cachedNode = DatabasePageManagerCache.cacheLookup(path);
        if (cachedNode instanceof PageSecurity) {
            cachedNode.checkAccess(JetspeedActions.VIEW);
            return (PageSecurity)cachedNode;
        }
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("path", (Object)path);
            QueryByCriteria query = QueryFactory.newQuery(PageSecurityImpl.class, (Criteria)filter);
            PageSecurity document = (PageSecurity)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
            if (document == null) {
                throw new DocumentNotFoundException("Document " + path + " not found.");
            }
            document.checkAccess(JetspeedActions.VIEW);
            return document;
        }
        catch (DocumentNotFoundException dnfe) {
            throw dnfe;
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new DocumentNotFoundException("Document " + path + " not found.", (Throwable)e);
        }
    }

    public Folder getFolder(String folderPath) throws FolderNotFoundException, InvalidFolderException, NodeException {
        NodeImpl cachedNode = DatabasePageManagerCache.cacheLookup(folderPath = NodeImpl.getCanonicalNodePath(folderPath));
        if (cachedNode instanceof Folder) {
            cachedNode.checkAccess(JetspeedActions.VIEW);
            return (Folder)cachedNode;
        }
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("path", (Object)folderPath);
            QueryByCriteria query = QueryFactory.newQuery(FolderImpl.class, (Criteria)filter);
            Folder folder = (Folder)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
            if (folder == null) {
                throw new FolderNotFoundException("Folder " + folderPath + " not found.");
            }
            folder.checkAccess(JetspeedActions.VIEW);
            return folder;
        }
        catch (FolderNotFoundException fnfe) {
            throw fnfe;
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new FolderNotFoundException("Folder " + folderPath + " not found.", (Throwable)e);
        }
    }

    public NodeSet getFolders(Folder folder) throws DocumentException {
        FolderImpl folderImpl = (FolderImpl)folder;
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            QueryByCriteria query = QueryFactory.newQuery(FolderImpl.class, (Criteria)filter);
            Collection folders = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            folderImpl.accessFolders().clear();
            if (folders != null) {
                folderImpl.accessFolders().addAll(folders);
            }
            folderImpl.resetFolders(true);
        }
        catch (Exception e) {
            folderImpl.resetFolders(false);
            throw new DocumentException("Unable to access folders for folder " + folder.getPath() + ".");
        }
        return folder.getFolders();
    }

    public Folder getFolder(Folder folder, String name) throws FolderNotFoundException, DocumentException {
        String folderPath = folder.getPath() + "/" + name;
        try {
            return this.getFolder(folderPath);
        }
        catch (FolderNotFoundException fnfe) {
            throw fnfe;
        }
        catch (Exception e) {
            throw new FolderNotFoundException("Folder " + folderPath + " not found.", (Throwable)e);
        }
    }

    public NodeSet getPages(Folder folder) throws NodeException {
        FolderImpl folderImpl = (FolderImpl)folder;
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            QueryByCriteria query = QueryFactory.newQuery(PageImpl.class, (Criteria)filter);
            Collection pages = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            folderImpl.accessPages().clear();
            if (pages != null) {
                folderImpl.accessPages().addAll(pages);
            }
            folderImpl.resetPages(true);
        }
        catch (Exception e) {
            folderImpl.resetPages(false);
            throw new NodeException("Unable to access pages for folder " + folder.getPath() + ".");
        }
        return folder.getPages();
    }

    public Page getPage(Folder folder, String name) throws PageNotFoundException, NodeException {
        String pagePath = folder.getPath() + "/" + name;
        try {
            return this.getPage(pagePath);
        }
        catch (PageNotFoundException pnfe) {
            throw pnfe;
        }
        catch (Exception e) {
            throw new PageNotFoundException("Page " + pagePath + " not found.", (Throwable)e);
        }
    }

    public NodeSet getPageTemplates(Folder folder) throws NodeException {
        FolderImpl folderImpl = (FolderImpl)folder;
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            QueryByCriteria query = QueryFactory.newQuery(PageTemplateImpl.class, (Criteria)filter);
            Collection pageTemplates = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            folderImpl.accessPageTemplates().clear();
            if (pageTemplates != null) {
                folderImpl.accessPageTemplates().addAll(pageTemplates);
            }
            folderImpl.resetPageTemplates(true);
        }
        catch (Exception e) {
            folderImpl.resetPageTemplates(false);
            throw new NodeException("Unable to access page templates for folder " + folder.getPath() + ".");
        }
        return folder.getPageTemplates();
    }

    public PageTemplate getPageTemplate(Folder folder, String name) throws PageNotFoundException, NodeException {
        String pageTemplatePath = folder.getPath() + "/" + name;
        try {
            return this.getPageTemplate(pageTemplatePath);
        }
        catch (PageNotFoundException pnfe) {
            throw pnfe;
        }
        catch (Exception e) {
            throw new PageNotFoundException("Page template " + pageTemplatePath + " not found.", (Throwable)e);
        }
    }

    public NodeSet getDynamicPages(Folder folder) throws NodeException {
        FolderImpl folderImpl = (FolderImpl)folder;
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            QueryByCriteria query = QueryFactory.newQuery(DynamicPageImpl.class, (Criteria)filter);
            Collection dynamicPages = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            folderImpl.accessDynamicPages().clear();
            if (dynamicPages != null) {
                folderImpl.accessDynamicPages().addAll(dynamicPages);
            }
            folderImpl.resetDynamicPages(true);
        }
        catch (Exception e) {
            folderImpl.resetDynamicPages(false);
            throw new NodeException("Unable to access dynamic pages for folder " + folder.getPath() + ".");
        }
        return folder.getDynamicPages();
    }

    public DynamicPage getDynamicPage(Folder folder, String name) throws PageNotFoundException, NodeException {
        String dynamicPagePath = folder.getPath() + "/" + name;
        try {
            return this.getDynamicPage(dynamicPagePath);
        }
        catch (PageNotFoundException pnfe) {
            throw pnfe;
        }
        catch (Exception e) {
            throw new PageNotFoundException("Dynamic page " + dynamicPagePath + " not found.", (Throwable)e);
        }
    }

    public NodeSet getFragmentDefinitions(Folder folder) throws NodeException {
        FolderImpl folderImpl = (FolderImpl)folder;
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            QueryByCriteria query = QueryFactory.newQuery(FragmentDefinitionImpl.class, (Criteria)filter);
            Collection fragmentDefinitions = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            folderImpl.accessFragmentDefinitions().clear();
            if (fragmentDefinitions != null) {
                folderImpl.accessFragmentDefinitions().addAll(fragmentDefinitions);
            }
            folderImpl.resetFragmentDefinitions(true);
        }
        catch (Exception e) {
            folderImpl.resetFragmentDefinitions(false);
            throw new NodeException("Unable to access fragment definition for folder " + folder.getPath() + ".");
        }
        return folder.getFragmentDefinitions();
    }

    public FragmentDefinition getFragmentDefinition(Folder folder, String name) throws PageNotFoundException, NodeException {
        String fragmentDefinitionPath = folder.getPath() + "/" + name;
        try {
            return this.getFragmentDefinition(fragmentDefinitionPath);
        }
        catch (PageNotFoundException pnfe) {
            throw pnfe;
        }
        catch (Exception e) {
            throw new PageNotFoundException("Fragment definition " + fragmentDefinitionPath + " not found.", (Throwable)e);
        }
    }

    public NodeSet getLinks(Folder folder) throws NodeException {
        FolderImpl folderImpl = (FolderImpl)folder;
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            QueryByCriteria query = QueryFactory.newQuery(LinkImpl.class, (Criteria)filter);
            Collection links = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            folderImpl.accessLinks().clear();
            if (links != null) {
                folderImpl.accessLinks().addAll(links);
            }
            folderImpl.resetLinks(true);
        }
        catch (Exception e) {
            folderImpl.resetLinks(false);
            throw new NodeException("Unable to access links for folder " + folder.getPath() + ".");
        }
        return folder.getLinks();
    }

    public Link getLink(Folder folder, String name) throws DocumentNotFoundException, NodeException {
        String linkPath = folder.getPath() + "/" + name;
        try {
            return this.getLink(linkPath);
        }
        catch (DocumentNotFoundException dnfe) {
            throw dnfe;
        }
        catch (Exception e) {
            throw new DocumentNotFoundException("Link " + linkPath + " not found.", (Throwable)e);
        }
    }

    public PageSecurity getPageSecurity(Folder folder) throws DocumentNotFoundException, NodeException {
        FolderImpl folderImpl = (FolderImpl)folder;
        if (folder.getPath().equals("/")) {
            try {
                Criteria filter = new Criteria();
                filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
                QueryByCriteria query = QueryFactory.newQuery(PageSecurityImpl.class, (Criteria)filter);
                PageSecurity document = (PageSecurity)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
                folderImpl.resetPageSecurity((PageSecurityImpl)document, true);
            }
            catch (Exception e) {
                folderImpl.resetPageSecurity(null, true);
                throw new NodeException("Unable to access page security for folder " + folder.getPath() + ".");
            }
        } else {
            folderImpl.resetPageSecurity(null, true);
        }
        return folder.getPageSecurity();
    }

    public NodeSet getAll(Folder folder) throws DocumentException {
        FolderImpl folderImpl = (FolderImpl)folder;
        try {
            List all = DatabasePageManagerUtils.createList();
            Criteria filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            QueryByCriteria query = QueryFactory.newQuery(FolderImpl.class, (Criteria)filter);
            Collection folders = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            if (folders != null) {
                all.addAll(folders);
            }
            filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            query = QueryFactory.newQuery(BaseFragmentsElementImpl.class, (Criteria)filter);
            Collection baseFragments = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            if (baseFragments != null) {
                all.addAll(baseFragments);
            }
            filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            query = QueryFactory.newQuery(LinkImpl.class, (Criteria)filter);
            Collection links = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            if (links != null) {
                all.addAll(links);
            }
            filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            query = QueryFactory.newQuery(PageSecurityImpl.class, (Criteria)filter);
            PageSecurity document = (PageSecurity)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
            if (document != null) {
                all.add(document);
            }
            folderImpl.accessAll().clear();
            folderImpl.accessAll().addAll(all);
            folderImpl.resetAll(true);
        }
        catch (Exception e) {
            folderImpl.resetAll(false);
            throw new DocumentException("Unable to access all nodes for folder " + folder.getPath() + ".");
        }
        return folder.getAll();
    }

    public void updatePage(Page page) throws NodeException, PageNotUpdatedException {
        page = (Page)ProxyHelper.getRealObject((Object)page);
        boolean[] newPage = new boolean[]{false};
        FolderImpl parentFolder = this.updateFragmentsElement((BaseFragmentsElement)page, newPage);
        if (parentFolder != null) {
            parentFolder.resetPages(false);
        }
        if (newPage[0]) {
            this.delegator.notifyNewNode((Node)page);
        } else {
            this.delegator.notifyUpdatedNode((Node)page);
        }
    }

    public void updatePageTemplate(PageTemplate pageTemplate) throws NodeException, PageNotUpdatedException {
        pageTemplate = (PageTemplate)ProxyHelper.getRealObject((Object)pageTemplate);
        boolean[] newPageTemplate = new boolean[]{false};
        FolderImpl parentFolder = this.updateFragmentsElement((BaseFragmentsElement)pageTemplate, newPageTemplate);
        if (parentFolder != null) {
            parentFolder.resetPageTemplates(false);
        }
        if (newPageTemplate[0]) {
            this.delegator.notifyNewNode((Node)pageTemplate);
        } else {
            this.delegator.notifyUpdatedNode((Node)pageTemplate);
        }
    }

    public void updateDynamicPage(DynamicPage dynamicPage) throws NodeException, PageNotUpdatedException {
        dynamicPage = (DynamicPage)ProxyHelper.getRealObject((Object)dynamicPage);
        boolean[] newDynamicPage = new boolean[]{false};
        FolderImpl parentFolder = this.updateFragmentsElement((BaseFragmentsElement)dynamicPage, newDynamicPage);
        if (parentFolder != null) {
            parentFolder.resetDynamicPages(false);
        }
        if (newDynamicPage[0]) {
            this.delegator.notifyNewNode((Node)dynamicPage);
        } else {
            this.delegator.notifyUpdatedNode((Node)dynamicPage);
        }
    }

    public void updateFragmentDefinition(FragmentDefinition fragmentsDefinition) throws NodeException, PageNotUpdatedException {
        fragmentsDefinition = (FragmentDefinition)ProxyHelper.getRealObject((Object)fragmentsDefinition);
        boolean[] newFragmentDefinition = new boolean[]{false};
        FolderImpl parentFolder = this.updateFragmentsElement((BaseFragmentsElement)fragmentsDefinition, newFragmentDefinition);
        if (parentFolder != null) {
            parentFolder.resetFragmentDefinitions(false);
        }
        if (newFragmentDefinition[0]) {
            this.delegator.notifyNewNode((Node)fragmentsDefinition);
        } else {
            this.delegator.notifyUpdatedNode((Node)fragmentsDefinition);
        }
    }

    protected FolderImpl updateFragmentsElement(BaseFragmentsElement fragmentsElement, boolean[] newFragmentsElement) throws NodeException, PageNotUpdatedException {
        try {
            BaseFragmentsElementImpl fragmentsElementImpl = (BaseFragmentsElementImpl)fragmentsElement;
            if (!fragmentsElementImpl.validateFragments()) {
                throw new PageNotUpdatedException("Fragments hierarchy invalid for fragments/page: " + fragmentsElement.getPath() + ", not updated.");
            }
            FolderImpl parent = (FolderImpl)fragmentsElement.getParent();
            if (parent == null) {
                String pageElementPath = fragmentsElement.getPath();
                String parentPath = pageElementPath.substring(0, pageElementPath.lastIndexOf("/"));
                if (parentPath.length() == 0) {
                    parentPath = "/";
                }
                try {
                    parent = (FolderImpl)this.getFolder(parentPath);
                }
                catch (FolderNotFoundException fnfe) {
                    throw new PageNotUpdatedException("Missing parent folder: " + parentPath);
                }
                parent.checkAccess(JetspeedActions.EDIT);
                fragmentsElement.setParent((Node)parent);
                this.storeEntity(fragmentsElement, pageElementPath, true);
                newFragmentsElement[0] = true;
            } else {
                fragmentsElement.checkAccess(JetspeedActions.EDIT);
                this.storeEntity(fragmentsElement, fragmentsElement.getPath(), false);
                newFragmentsElement[0] = false;
            }
            return parent;
        }
        catch (PageNotUpdatedException pnue) {
            throw pnue;
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new PageNotUpdatedException("Fragments/page element " + fragmentsElement.getPath() + " not updated.", (Throwable)e);
        }
    }

    public void removePage(Page page) throws NodeException, PageNotRemovedException {
        page = (Page)ProxyHelper.getRealObject((Object)page);
        FolderImpl parentFolder = this.removeFragmentsElement((BaseFragmentsElement)page);
        parentFolder.resetPages(false);
        this.delegator.notifyRemovedNode((Node)page);
    }

    public void removePageTemplate(PageTemplate pageTemplate) throws NodeException, PageNotRemovedException {
        pageTemplate = (PageTemplate)ProxyHelper.getRealObject((Object)pageTemplate);
        FolderImpl parentFolder = this.removeFragmentsElement((BaseFragmentsElement)pageTemplate);
        parentFolder.resetPages(false);
        this.delegator.notifyRemovedNode((Node)pageTemplate);
    }

    public void removeDynamicPage(DynamicPage dynamicPage) throws NodeException, PageNotRemovedException {
        dynamicPage = (DynamicPage)ProxyHelper.getRealObject((Object)dynamicPage);
        FolderImpl parentFolder = this.removeFragmentsElement((BaseFragmentsElement)dynamicPage);
        parentFolder.resetPages(false);
        this.delegator.notifyRemovedNode((Node)dynamicPage);
    }

    public void removeFragmentDefinition(FragmentDefinition fragmentDefinition) throws NodeException, PageNotRemovedException {
        fragmentDefinition = (FragmentDefinition)ProxyHelper.getRealObject((Object)fragmentDefinition);
        FolderImpl parentFolder = this.removeFragmentsElement((BaseFragmentsElement)fragmentDefinition);
        parentFolder.resetPages(false);
        this.delegator.notifyRemovedNode((Node)fragmentDefinition);
    }

    protected FolderImpl removeFragmentsElement(BaseFragmentsElement fragmentsElement) throws NodeException, PageNotRemovedException {
        try {
            fragmentsElement.checkAccess(JetspeedActions.EDIT);
            FolderImpl parent = (FolderImpl)ProxyHelper.getRealObject((Object)fragmentsElement.getParent());
            this.getPersistenceBrokerTemplate().delete((Object)fragmentsElement);
            return parent;
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new PageNotRemovedException("Fragments/page element " + fragmentsElement.getPath() + " not removed.", (Throwable)e);
        }
    }

    public void updateFolder(Folder folder) throws NodeException, FolderNotUpdatedException {
        this.updateFolder(folder, false);
    }

    public void updateFolder(Folder folder, boolean deep) throws NodeException, FolderNotUpdatedException {
        try {
            folder = (Folder)ProxyHelper.getRealObject((Object)folder);
            FolderImpl folderImpl = (FolderImpl)folder;
            FolderImpl parent = (FolderImpl)folder.getParent();
            if (parent == null && !folder.getPath().equals("/")) {
                String folderPath = folder.getPath();
                String parentPath = folderPath.substring(0, folderPath.lastIndexOf("/"));
                if (parentPath.length() == 0) {
                    parentPath = "/";
                }
                try {
                    parent = (FolderImpl)this.getFolder(parentPath);
                }
                catch (FolderNotFoundException fnfe) {
                    throw new FolderNotUpdatedException("Missing parent folder: " + parentPath);
                }
                parent.checkAccess(JetspeedActions.EDIT);
                folder.setParent((Node)parent);
                this.storeEntity(folder, folderPath, true);
                parent.resetFolders(false);
                this.delegator.notifyNewNode((Node)folder);
            } else {
                boolean newFolder = folderImpl.getIdentity() == 0;
                String folderPath = folder.getPath();
                if (!newFolder || !folderPath.equals("/")) {
                    folder.checkAccess(JetspeedActions.EDIT);
                }
                this.storeEntity(folder, folderPath, newFolder && folderImpl.getIdentity() != 0);
                if (parent != null) {
                    parent.resetFolders(false);
                }
                if (newFolder && folderImpl.getIdentity() != 0) {
                    this.delegator.notifyNewNode((Node)folder);
                } else {
                    this.delegator.notifyUpdatedNode((Node)folder);
                }
            }
            if (deep) {
                this.updateFolderNodes(folderImpl);
            }
        }
        catch (FolderNotUpdatedException fnue) {
            throw fnue;
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new FolderNotUpdatedException("Folder " + folder.getPath() + " not updated.", (Throwable)e);
        }
    }

    private void updateFolderNodes(FolderImpl folderImpl) throws FolderNotUpdatedException {
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            QueryByCriteria query = QueryFactory.newQuery(PageImpl.class, (Criteria)filter);
            Collection pages = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            if (pages != null) {
                Iterator pagesIter = pages.iterator();
                while (pagesIter.hasNext()) {
                    this.updatePage((Page)pagesIter.next());
                }
            }
            filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            query = QueryFactory.newQuery(PageTemplateImpl.class, (Criteria)filter);
            Collection pageTemplates = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            if (pageTemplates != null) {
                Iterator pageTemplatesIter = pageTemplates.iterator();
                while (pageTemplatesIter.hasNext()) {
                    this.updatePageTemplate((PageTemplate)pageTemplatesIter.next());
                }
            }
            filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            query = QueryFactory.newQuery(DynamicPageImpl.class, (Criteria)filter);
            Collection dynamicPages = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            if (dynamicPages != null) {
                Iterator dynamicPagesIter = dynamicPages.iterator();
                while (dynamicPagesIter.hasNext()) {
                    this.updateDynamicPage((DynamicPage)dynamicPagesIter.next());
                }
            }
            filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            query = QueryFactory.newQuery(FragmentDefinitionImpl.class, (Criteria)filter);
            Collection fragmentDefinitions = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            if (fragmentDefinitions != null) {
                Iterator fragmentDefinitionsIter = fragmentDefinitions.iterator();
                while (fragmentDefinitionsIter.hasNext()) {
                    this.updateFragmentDefinition((FragmentDefinition)fragmentDefinitionsIter.next());
                }
            }
            filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            query = QueryFactory.newQuery(LinkImpl.class, (Criteria)filter);
            Collection links = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            if (links != null) {
                Iterator linksIter = links.iterator();
                while (linksIter.hasNext()) {
                    this.updateLink((Link)linksIter.next());
                }
            }
            filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            query = QueryFactory.newQuery(PageSecurityImpl.class, (Criteria)filter);
            PageSecurity document = (PageSecurity)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
            if (document != null) {
                this.updatePageSecurity(document);
            }
            filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            query = QueryFactory.newQuery(FolderImpl.class, (Criteria)filter);
            Collection folders = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            if (folders != null) {
                Iterator foldersIter = folders.iterator();
                while (foldersIter.hasNext()) {
                    this.updateFolder((Folder)foldersIter.next(), true);
                }
            }
        }
        catch (FolderNotUpdatedException fnue) {
            throw fnue;
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new FolderNotUpdatedException("Folder " + folderImpl.getPath() + " not updated.", (Throwable)e);
        }
    }

    public void removeFolder(Folder folder) throws NodeException, FolderNotRemovedException {
        try {
            folder = (Folder)ProxyHelper.getRealObject((Object)folder);
            folder.checkAccess(JetspeedActions.EDIT);
            ((FolderImpl)folder).resetAll(false);
            this.removeFolderNodes((FolderImpl)folder);
            if (folder.getParent() != null) {
                FolderImpl parent = (FolderImpl)ProxyHelper.getRealObject((Object)folder.getParent());
                this.getPersistenceBrokerTemplate().delete((Object)folder);
                parent.resetFolders(false);
            } else {
                this.getPersistenceBrokerTemplate().delete((Object)folder);
            }
            this.delegator.notifyRemovedNode((FolderImpl)folder);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new FolderNotRemovedException("Folder " + folder.getPath() + " not removed.", (Throwable)e);
        }
    }

    private void removeFolderNodes(FolderImpl folderImpl) throws FolderNotRemovedException {
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            QueryByCriteria query = QueryFactory.newQuery(FolderImpl.class, (Criteria)filter);
            Collection folders = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            if (folders != null) {
                Iterator foldersIter = folders.iterator();
                while (foldersIter.hasNext()) {
                    this.removeFolder((Folder)foldersIter.next());
                }
            }
            filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            query = QueryFactory.newQuery(PageImpl.class, (Criteria)filter);
            Collection pages = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            if (pages != null) {
                Iterator pagesIter = pages.iterator();
                while (pagesIter.hasNext()) {
                    this.removePage((Page)pagesIter.next());
                }
            }
            filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            query = QueryFactory.newQuery(PageTemplateImpl.class, (Criteria)filter);
            Collection pageTemplates = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            if (pageTemplates != null) {
                Iterator pageTemplatesIter = pageTemplates.iterator();
                while (pageTemplatesIter.hasNext()) {
                    this.removePageTemplate((PageTemplate)pageTemplatesIter.next());
                }
            }
            filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            query = QueryFactory.newQuery(DynamicPageImpl.class, (Criteria)filter);
            Collection dynamicPages = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            if (dynamicPages != null) {
                Iterator dynamicPagesIter = dynamicPages.iterator();
                while (dynamicPagesIter.hasNext()) {
                    this.removeDynamicPage((DynamicPage)dynamicPagesIter.next());
                }
            }
            filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            query = QueryFactory.newQuery(FragmentDefinitionImpl.class, (Criteria)filter);
            Collection fragmentDefinitions = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            if (fragmentDefinitions != null) {
                Iterator fragmentDefinitionsIter = fragmentDefinitions.iterator();
                while (fragmentDefinitionsIter.hasNext()) {
                    this.removeFragmentDefinition((FragmentDefinition)fragmentDefinitionsIter.next());
                }
            }
            filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            query = QueryFactory.newQuery(LinkImpl.class, (Criteria)filter);
            Collection links = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            if (links != null) {
                Iterator linksIter = links.iterator();
                while (linksIter.hasNext()) {
                    this.removeLink((Link)linksIter.next());
                }
            }
            filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            query = QueryFactory.newQuery(PageSecurityImpl.class, (Criteria)filter);
            PageSecurity document = (PageSecurity)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
            if (document != null) {
                this.removePageSecurity(document);
            }
        }
        catch (FolderNotRemovedException fnre) {
            throw fnre;
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new FolderNotRemovedException("Folder " + folderImpl.getPath() + " not removed.", (Throwable)e);
        }
    }

    public void updateLink(Link link) throws NodeException, LinkNotUpdatedException {
        try {
            link = (Link)ProxyHelper.getRealObject((Object)link);
            boolean newLink = false;
            FolderImpl parent = (FolderImpl)link.getParent();
            if (parent == null) {
                String linkPath = link.getPath();
                String parentPath = linkPath.substring(0, linkPath.lastIndexOf("/"));
                if (parentPath.length() == 0) {
                    parentPath = "/";
                }
                try {
                    parent = (FolderImpl)this.getFolder(parentPath);
                }
                catch (FolderNotFoundException fnfe) {
                    throw new FailedToUpdateDocumentException("Missing parent folder: " + parentPath);
                }
                parent.checkAccess(JetspeedActions.EDIT);
                link.setParent((Node)parent);
                this.storeEntity(link, linkPath, true);
                newLink = true;
            } else {
                link.checkAccess(JetspeedActions.EDIT);
                this.storeEntity(link, link.getPath(), false);
                newLink = false;
            }
            parent.resetLinks(false);
            if (newLink) {
                this.delegator.notifyNewNode((Node)link);
            } else {
                this.delegator.notifyUpdatedNode((Node)link);
            }
        }
        catch (FailedToUpdateDocumentException fude) {
            throw fude;
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new FailedToUpdateDocumentException("Link " + link.getPath() + " not updated.", (Throwable)e);
        }
    }

    public void removeLink(Link link) throws NodeException, LinkNotRemovedException {
        try {
            link = (Link)ProxyHelper.getRealObject((Object)link);
            link.checkAccess(JetspeedActions.EDIT);
            if (link.getParent() != null) {
                FolderImpl parent = (FolderImpl)ProxyHelper.getRealObject((Object)link.getParent());
                this.getPersistenceBrokerTemplate().delete((Object)link);
                parent.resetLinks(false);
            } else {
                this.getPersistenceBrokerTemplate().delete((Object)link);
            }
            this.delegator.notifyRemovedNode((Node)link);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new FailedToDeleteDocumentException("Link " + link.getPath() + " not removed.", (Throwable)e);
        }
    }

    public void updatePageSecurity(PageSecurity pageSecurity) throws NodeException, FailedToUpdateDocumentException {
        try {
            pageSecurity = (PageSecurity)ProxyHelper.getRealObject((Object)pageSecurity);
            boolean newPageSecurity = false;
            FolderImpl parent = (FolderImpl)pageSecurity.getParent();
            if (parent == null) {
                String pageSecurityPath = pageSecurity.getPath();
                String parentPath = pageSecurityPath.substring(0, pageSecurityPath.lastIndexOf("/"));
                if (parentPath.length() == 0) {
                    parentPath = "/";
                }
                try {
                    parent = (FolderImpl)this.getFolder(parentPath);
                }
                catch (FolderNotFoundException fnfe) {
                    throw new FailedToUpdateDocumentException("Missing parent folder: " + parentPath);
                }
                try {
                    parent.getPageSecurity();
                    throw new FailedToUpdateDocumentException("Parent folder page security exists: " + parentPath);
                }
                catch (DocumentNotFoundException dnfe) {
                    parent.checkAccess(JetspeedActions.EDIT);
                    pageSecurity.setParent((Node)parent);
                    this.storeEntity(pageSecurity, pageSecurityPath, true);
                    newPageSecurity = true;
                }
                catch (Exception e) {
                    throw new FailedToUpdateDocumentException("Parent folder page security exists: " + parentPath);
                }
            }
            pageSecurity.checkAccess(JetspeedActions.EDIT);
            this.storeEntity(pageSecurity, pageSecurity.getPath(), false);
            newPageSecurity = false;
            parent.resetPageSecurity((PageSecurityImpl)pageSecurity, true);
            DatabasePageManagerCache.resetCachedSecurityConstraints();
            if (newPageSecurity) {
                this.delegator.notifyNewNode((Node)pageSecurity);
            } else {
                this.delegator.notifyUpdatedNode((Node)pageSecurity);
            }
        }
        catch (FailedToUpdateDocumentException fude) {
            throw fude;
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new FailedToUpdateDocumentException("Document " + pageSecurity.getPath() + " not updated.", (Throwable)e);
        }
    }

    public void removePageSecurity(PageSecurity pageSecurity) throws NodeException, FailedToDeleteDocumentException {
        try {
            pageSecurity = (PageSecurity)ProxyHelper.getRealObject((Object)pageSecurity);
            pageSecurity.checkAccess(JetspeedActions.EDIT);
            if (pageSecurity.getParent() != null) {
                FolderImpl parent = (FolderImpl)ProxyHelper.getRealObject((Object)pageSecurity.getParent());
                this.getPersistenceBrokerTemplate().delete((Object)pageSecurity);
                parent.resetPageSecurity(null, true);
            } else {
                this.getPersistenceBrokerTemplate().delete((Object)pageSecurity);
            }
            DatabasePageManagerCache.resetCachedSecurityConstraints();
            this.delegator.notifyRemovedNode((Node)pageSecurity);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new FailedToDeleteDocumentException("Document " + pageSecurity.getPath() + " not removed.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeEntity(Object node, String path) {
        DatabasePageManagerCache.addUpdatePath(path);
        try {
            this.getPersistenceBrokerTemplate().store(node);
        }
        finally {
            DatabasePageManagerCache.removeUpdatePath(path);
        }
    }

    private void storeEntity(Object node, String path, boolean add) {
        this.storeEntity(node, path);
        DatabasePageManagerCache.addTransaction(new TransactionedOperation(path, add ? 0 : 1));
    }

    public Page copyPage(Page source, String path) throws NodeException, PageNotUpdatedException {
        return this.delegator.copyPage(source, path);
    }

    public Page copyPage(Page source, String path, boolean copyIds) throws NodeException, PageNotUpdatedException {
        return this.delegator.copyPage(source, path, copyIds);
    }

    public PageTemplate copyPageTemplate(PageTemplate source, String path) throws NodeException, PageNotUpdatedException {
        return this.delegator.copyPageTemplate(source, path);
    }

    public PageTemplate copyPageTemplate(PageTemplate source, String path, boolean copyIds) throws NodeException, PageNotUpdatedException {
        return this.delegator.copyPageTemplate(source, path, copyIds);
    }

    public DynamicPage copyDynamicPage(DynamicPage source, String path) throws NodeException, PageNotUpdatedException {
        return this.delegator.copyDynamicPage(source, path);
    }

    public DynamicPage copyDynamicPage(DynamicPage source, String path, boolean copyIds) throws NodeException, PageNotUpdatedException {
        return this.delegator.copyDynamicPage(source, path, copyIds);
    }

    public FragmentDefinition copyFragmentDefinition(FragmentDefinition source, String path) throws NodeException, PageNotUpdatedException {
        return this.delegator.copyFragmentDefinition(source, path);
    }

    public FragmentDefinition copyFragmentDefinition(FragmentDefinition source, String path, boolean copyIds) throws NodeException, PageNotUpdatedException {
        return this.delegator.copyFragmentDefinition(source, path, copyIds);
    }

    public Link copyLink(Link source, String path) throws NodeException, LinkNotUpdatedException {
        return this.delegator.copyLink(source, path);
    }

    public Folder copyFolder(Folder source, String path) throws NodeException, PageNotUpdatedException {
        return this.delegator.copyFolder(source, path);
    }

    public BaseFragmentElement copyFragment(BaseFragmentElement source, String name) throws NodeException, PageNotUpdatedException {
        return this.delegator.copyFragment(source, name);
    }

    public BaseFragmentElement copyFragment(BaseFragmentElement source, String name, boolean copyIds) throws NodeException, PageNotUpdatedException {
        return this.delegator.copyFragment(source, name, copyIds);
    }

    public PageSecurity copyPageSecurity(PageSecurity source) throws NodeException {
        return this.delegator.copyPageSecurity(source);
    }

    public Page getUserPage(String userName, String pageName) throws PageNotFoundException, NodeException {
        return this.getPage("/_user/" + userName + "/" + pageName);
    }

    public Folder getUserFolder(String userName) throws FolderNotFoundException, InvalidFolderException, NodeException {
        return this.getFolder("/_user/" + userName);
    }

    public boolean folderExists(String folderName) {
        try {
            this.getFolder(folderName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean pageExists(String pageName) {
        try {
            this.getPage(pageName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean pageTemplateExists(String pageName) {
        try {
            this.getPageTemplate(pageName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean dynamicPageExists(String pageName) {
        try {
            this.getDynamicPage(pageName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean fragmentDefinitionExists(String name) {
        try {
            this.getFragmentDefinition(name);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean linkExists(String linkName) {
        try {
            this.getLink(linkName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean userFolderExists(String userName) {
        try {
            this.getFolder("/_user/" + userName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean userPageExists(String userName, String pageName) {
        try {
            this.getPage("/_user/" + userName + "/" + pageName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void createUserHomePagesFromRoles(Subject subject) throws NodeException {
        PageManagerUtils.createUserHomePagesFromRoles(this, subject);
    }

    public void deepCopyFolder(Folder srcFolder, String destinationPath, String owner) throws NodeException, PageNotUpdatedException {
        this.deepCopyFolder(srcFolder, destinationPath, owner, false);
    }

    public void deepCopyFolder(Folder srcFolder, String destinationPath, String owner, boolean copyIds) throws NodeException, PageNotUpdatedException {
        PageManagerUtils.deepCopyFolder(this, srcFolder, destinationPath, owner, copyIds);
    }

    public void deepMergeFolder(Folder srcFolder, String destinationPath, String owner) throws NodeException, PageNotUpdatedException {
        this.deepMergeFolder(srcFolder, destinationPath, owner, false);
    }

    public void deepMergeFolder(Folder srcFolder, String destinationPath, String owner, boolean copyIds) throws NodeException, PageNotUpdatedException {
        PageManagerUtils.deepMergeFolder((PageManager)this, srcFolder, destinationPath, owner, copyIds);
    }

    public int addPages(Page[] pages) throws NodeException {
        if (pages.length > 0 && pages[0].getPath().equals("/tx__test1.psml")) {
            log.debug("Adding first page");
            this.updatePage(pages[0]);
            log.debug("Adding second page");
            this.updatePage(pages[1]);
            log.debug("About to throw ex");
            throw new NodeException("Its gonna blow captain!");
        }
        for (int ix = 0; ix < pages.length; ++ix) {
            this.updatePage(pages[ix]);
        }
        return pages.length;
    }

    public boolean isDistributed() {
        return DatabasePageManagerCache.isDistributed();
    }

    public void notifyUpdatedNode(Node node) {
        this.delegator.notifyUpdatedNode(node);
    }

    public void cleanupRequestCache() {
        fragmentPropertyListsCache.remove();
    }

    public void updateFragmentProperties(BaseFragmentElement fragment, String scope) throws NodeException, PageNotUpdatedException {
        block7: {
            try {
                BaseFragmentsElementImpl baseFragmentsElementImpl;
                BaseFragmentElementImpl baseFragmentElementImpl = (BaseFragmentElementImpl)fragment;
                if (baseFragmentElementImpl.getIdentity() == 0) {
                    throw new PageNotUpdatedException("Properties for transient fragment cannot be updated");
                }
                if (scope != null && !scope.equals("all")) {
                    boolean checkEditAccess = !scope.equals("user");
                    baseFragmentElementImpl.checkAccess(checkEditAccess ? JetspeedActions.EDIT : JetspeedActions.VIEW);
                    this.updateFragmentPropertyList(baseFragmentElementImpl, scope, (FragmentPropertyList)null);
                    break block7;
                }
                BaseFragmentsElementImpl baseFragmentsElementImpl2 = baseFragmentsElementImpl = baseFragmentElementImpl != null ? baseFragmentElementImpl.getBaseFragmentsElement() : null;
                if (baseFragmentsElementImpl != null) {
                    this.updateFragmentsElement(baseFragmentsElementImpl, new boolean[]{false});
                    break block7;
                }
                throw new PageNotUpdatedException("Unable to update fragment properties: no owning page");
            }
            catch (PageNotUpdatedException pnue) {
                throw pnue;
            }
            catch (SecurityException se) {
                throw se;
            }
            catch (Exception e) {
                throw new PageNotUpdatedException("Fragment properties for fragment " + fragment.getId() + " not updated.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FragmentPropertyList getFragmentPropertyList(BaseFragmentElementImpl baseFragmentElementImpl, FragmentPropertyList transientList) {
        FragmentPropertyList list;
        String fragmentKey = DatabasePageManager.getFragmentPropertyListFragmentKey(baseFragmentElementImpl);
        Subject subject = JSSubject.getSubject((AccessControlContext)AccessController.getContext());
        Principal userPrincipal = subject != null ? SubjectHelper.getBestPrincipal((Subject)subject, User.class) : null;
        String fragmentListKey = DatabasePageManager.getFragmentPropertyListKey(fragmentKey, userPrincipal);
        Map threadLocalCache = (Map)fragmentPropertyListsCache.get();
        WeakReference listReference = threadLocalCache != null ? (WeakReference)threadLocalCache.get(fragmentListKey) : null;
        FragmentPropertyList fragmentPropertyList = list = listReference != null ? (FragmentPropertyList)listReference.get() : null;
        if (list == null) {
            List userFragmentProperties;
            String principalKey;
            DatabasePageManagerCachedFragmentPropertyList globalFragmentPropertyList = DatabasePageManagerCache.fragmentPropertyListCacheLookup(fragmentKey);
            if (globalFragmentPropertyList == null) {
                globalFragmentPropertyList = new DatabasePageManagerCachedFragmentPropertyList(baseFragmentElementImpl.getBaseFragmentsElement().getPath());
                Criteria filter = new Criteria();
                filter.addEqualTo("fragment", (Object)new Integer(baseFragmentElementImpl.getIdentity()));
                filter.addIsNull("scope");
                QueryByCriteria query = QueryFactory.newQuery(FragmentPropertyImpl.class, (Criteria)filter);
                Collection fragmentProperties = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
                globalFragmentPropertyList.addAll(fragmentProperties);
                DatabasePageManagerCache.fragmentPropertyListCacheAdd(fragmentKey, globalFragmentPropertyList, false);
            }
            Object principalFragmentPropertyLists = null;
            DatabasePageManagerCachedFragmentPropertyList userFragmentPropertyList = null;
            if (subject != null && userPrincipal != null && (userFragmentPropertyList = DatabasePageManagerCache.principalFragmentPropertyListCacheLookup(principalKey = DatabasePageManager.getFragmentPropertyListPrincipalKey("user", userPrincipal.getName()))) == null) {
                userFragmentPropertyList = new DatabasePageManagerCachedFragmentPropertyList("user", principalKey);
                Criteria filter = new Criteria();
                filter.addEqualTo("scope", (Object)"user");
                filter.addEqualTo("scopeValue", (Object)userPrincipal.getName());
                QueryByCriteria query = QueryFactory.newQuery(FragmentPropertyImpl.class, (Criteria)filter);
                Collection fragmentProperties = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
                userFragmentPropertyList.addAll(fragmentProperties);
                DatabasePageManagerCache.principalFragmentPropertyListCacheAdd(principalKey, userFragmentPropertyList, false);
            }
            list = new FragmentPropertyListImpl(baseFragmentElementImpl);
            list.getProperties().addAll(globalFragmentPropertyList);
            if (subject != null && userFragmentPropertyList != null && (userFragmentProperties = DatabasePageManager.filterPrincipalFragmentPropertyList(userFragmentPropertyList, baseFragmentElementImpl)) != null) {
                list.getProperties().addAll(userFragmentProperties);
            }
            if (list != null && transientList != null) {
                FragmentPropertyList fragmentPropertyList2 = transientList;
                synchronized (fragmentPropertyList2) {
                    for (FragmentProperty sourceProperty : transientList) {
                        FragmentProperty targetProperty = list.getMatchingProperty(sourceProperty);
                        if (targetProperty != null) {
                            targetProperty.setValue(sourceProperty.getValue());
                            continue;
                        }
                        list.add((Object)sourceProperty);
                    }
                    transientList.clearProperties();
                }
            }
            if (threadLocalCache == null) {
                threadLocalCache = new LinkedHashMap(16, 0.75f, true){

                    protected boolean removeEldestEntry(Map.Entry eldest) {
                        return this.size() > DatabasePageManager.this.maxThreadCacheSize;
                    }
                };
                fragmentPropertyListsCache.set(threadLocalCache);
            }
            threadLocalCache.put(fragmentListKey, new WeakReference<FragmentPropertyList>(list));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFragmentPropertyList(BaseFragmentElementImpl baseFragmentElementImpl, String scope, FragmentPropertyList transientList) {
        FragmentPropertyList list = this.getFragmentPropertyList(baseFragmentElementImpl, transientList);
        if (list != null) {
            Subject subject = JSSubject.getSubject((AccessControlContext)AccessController.getContext());
            Principal userPrincipal = subject != null ? SubjectHelper.getBestPrincipal((Subject)subject, User.class) : null;
            String userPrincipalKey = userPrincipal != null ? DatabasePageManager.getFragmentPropertyListPrincipalKey("user", userPrincipal.getName()) : null;
            boolean updateAllScopes = scope != null && scope.equals("all");
            FragmentPropertyList fragmentPropertyList = list;
            synchronized (fragmentPropertyList) {
                boolean updateTransaction = false;
                DatabasePageManagerCachedFragmentPropertyList globalFragmentPropertyList = null;
                HashMap<String, DatabasePageManagerCachedFragmentPropertyList> principalPartialFragmentPropertyLists = null;
                String fragmentKey = DatabasePageManager.getFragmentPropertyListFragmentKey(baseFragmentElementImpl);
                List properties = list.getProperties();
                List removedProperties = list.getRemovedProperties();
                ArrayList allProperties = new ArrayList(properties);
                if (removedProperties != null) {
                    allProperties.addAll(removedProperties);
                }
                for (FragmentPropertyImpl property : allProperties) {
                    DatabasePageManagerCachedFragmentPropertyList principalPartialFragmentPropertyList;
                    property.setFragment(baseFragmentElementImpl);
                    String propertyScope = property.getScope();
                    String propertyScopeValue = property.getScopeValue();
                    if (!updateAllScopes && (scope != null || propertyScope != null) && (scope == null || !scope.equals(propertyScope))) continue;
                    if (propertyScope == null) {
                        if (globalFragmentPropertyList != null) continue;
                        globalFragmentPropertyList = new DatabasePageManagerCachedFragmentPropertyList(baseFragmentElementImpl.getBaseFragmentsElement().getPath());
                        continue;
                    }
                    if (subject != null) {
                        // empty if block
                    }
                    if (subject == null || !propertyScope.equals("user") || userPrincipal == null || !userPrincipal.getName().equals(propertyScopeValue)) continue;
                    if (principalPartialFragmentPropertyLists == null) {
                        principalPartialFragmentPropertyLists = new HashMap<String, DatabasePageManagerCachedFragmentPropertyList>();
                    }
                    if ((principalPartialFragmentPropertyList = (DatabasePageManagerCachedFragmentPropertyList)principalPartialFragmentPropertyLists.get(userPrincipalKey)) != null) continue;
                    principalPartialFragmentPropertyList = new DatabasePageManagerCachedFragmentPropertyList("user", userPrincipalKey);
                    principalPartialFragmentPropertyLists.put(userPrincipalKey, principalPartialFragmentPropertyList);
                }
                for (FragmentPropertyImpl storeProperty : properties) {
                    String principalKey;
                    DatabasePageManagerCachedFragmentPropertyList principalPartialFragmentPropertyList;
                    String storePropertyScope = storeProperty.getScope();
                    String storePropertyScopeValue = storeProperty.getScopeValue();
                    if (!updateAllScopes && (scope != null || storePropertyScope != null) && (scope == null || !scope.equals(storePropertyScope))) continue;
                    updateTransaction = updateTransaction || storeProperty.getIdentity() != 0;
                    boolean store = false;
                    if (storePropertyScope == null) {
                        if (globalFragmentPropertyList != null) {
                            globalFragmentPropertyList.add(storeProperty);
                            store = true;
                        }
                    } else if (subject != null && principalPartialFragmentPropertyLists != null && (principalPartialFragmentPropertyList = (DatabasePageManagerCachedFragmentPropertyList)principalPartialFragmentPropertyLists.get(principalKey = DatabasePageManager.getFragmentPropertyListPrincipalKey(storePropertyScope, storePropertyScopeValue))) != null) {
                        principalPartialFragmentPropertyList.add(storeProperty);
                        store = true;
                    }
                    if (!store) continue;
                    this.getPersistenceBrokerTemplate().store((Object)storeProperty);
                }
                if (removedProperties != null) {
                    for (FragmentPropertyImpl deleteProperty : removedProperties) {
                        deleteProperty.setFragment(baseFragmentElementImpl);
                        String deletePropertyScope = deleteProperty.getScope();
                        String deletePropertyScopeValue = deleteProperty.getScopeValue();
                        if (!updateAllScopes && (scope != null || deletePropertyScope != null) && (scope == null || !scope.equals(deletePropertyScope))) continue;
                        updateTransaction = true;
                        boolean delete = false;
                        if (deletePropertyScope == null) {
                            delete = globalFragmentPropertyList != null;
                        } else if (subject != null && principalPartialFragmentPropertyLists != null) {
                            String principalKey = DatabasePageManager.getFragmentPropertyListPrincipalKey(deletePropertyScope, deletePropertyScopeValue);
                            delete = principalPartialFragmentPropertyLists.containsKey(principalKey);
                        }
                        if (!delete) continue;
                        this.getPersistenceBrokerTemplate().delete((Object)deleteProperty);
                    }
                }
                if (globalFragmentPropertyList != null) {
                    DatabasePageManagerCache.fragmentPropertyListCacheAdd(fragmentKey, globalFragmentPropertyList, true);
                    DatabasePageManagerCache.addTransaction(new TransactionedOperation(fragmentKey, updateTransaction ? 3 : 2));
                }
                if (principalPartialFragmentPropertyLists != null) {
                    for (Map.Entry entry : principalPartialFragmentPropertyLists.entrySet()) {
                        String principalKey = (String)entry.getKey();
                        DatabasePageManagerCachedFragmentPropertyList principalPartialFragmentPropertyList = (DatabasePageManagerCachedFragmentPropertyList)entry.getValue();
                        DatabasePageManagerCachedFragmentPropertyList cachedPrincipalFragmentPropertyList = DatabasePageManagerCache.principalFragmentPropertyListCacheLookup(principalKey);
                        if (cachedPrincipalFragmentPropertyList != null) {
                            DatabasePageManagerCachedFragmentPropertyList databasePageManagerCachedFragmentPropertyList = cachedPrincipalFragmentPropertyList;
                            synchronized (databasePageManagerCachedFragmentPropertyList) {
                                DatabasePageManager.removeAllPrincipalFragmentPropertyList(cachedPrincipalFragmentPropertyList, baseFragmentElementImpl);
                                cachedPrincipalFragmentPropertyList.addAll(principalPartialFragmentPropertyList);
                            }
                            DatabasePageManagerCache.principalFragmentPropertyListCacheAdd(principalKey, cachedPrincipalFragmentPropertyList, true);
                        }
                        DatabasePageManagerCache.addTransaction(new TransactionedOperation(principalKey, updateTransaction ? 5 : 4));
                    }
                }
            }
        }
    }

    public void removeFragmentPropertyList(BaseFragmentElementImpl baseFragmentElementImpl, FragmentPropertyList transientList) {
        FragmentPropertyList list;
        String fragmentKey = DatabasePageManager.getFragmentPropertyListFragmentKey(baseFragmentElementImpl);
        Subject subject = JSSubject.getSubject((AccessControlContext)AccessController.getContext());
        Principal userPrincipal = subject != null ? SubjectHelper.getBestPrincipal((Subject)subject, User.class) : null;
        String fragmentListKey = DatabasePageManager.getFragmentPropertyListKey(fragmentKey, userPrincipal);
        Map threadLocalCache = (Map)fragmentPropertyListsCache.get();
        WeakReference listReference = threadLocalCache != null ? (WeakReference)threadLocalCache.get(fragmentListKey) : null;
        FragmentPropertyList fragmentPropertyList = list = listReference != null ? (FragmentPropertyList)listReference.get() : null;
        if (list != null) {
            threadLocalCache.remove(fragmentKey);
            list.clearProperties();
        }
        if (transientList != null) {
            transientList.clearProperties();
        }
        Integer fragmentId = new Integer(baseFragmentElementImpl.getIdentity());
        Criteria filter = new Criteria();
        filter.addEqualTo("fragment", (Object)fragmentId);
        QueryByCriteria query = QueryFactory.newQuery(FragmentPropertyImpl.class, (Criteria)filter);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)query);
        DatabasePageManagerCache.fragmentPropertyListCacheRemove(fragmentKey);
        DatabasePageManagerCache.addTransaction(new TransactionedOperation(fragmentKey, 3));
    }

    private static String getFragmentPropertyListKey(String fragmentKey, Principal userPrincipal) {
        if (userPrincipal != null) {
            return fragmentKey + "/" + userPrincipal.getName();
        }
        return fragmentKey;
    }

    private static String getFragmentPropertyListFragmentKey(BaseFragmentElementImpl baseFragmentElementImpl) {
        return baseFragmentElementImpl.getBaseFragmentsElement().getPath() + "/" + baseFragmentElementImpl.getId() + ":" + baseFragmentElementImpl.getIdentity();
    }

    private static String getFragmentPropertyListPrincipalKey(String principalType, String principalName) {
        return principalType + ":" + principalName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List filterPrincipalFragmentPropertyList(DatabasePageManagerCachedFragmentPropertyList principalFragmentPropertyList, BaseFragmentElementImpl baseFragmentElementImpl) {
        ArrayList<FragmentPropertyImpl> filteredList = null;
        DatabasePageManagerCachedFragmentPropertyList databasePageManagerCachedFragmentPropertyList = principalFragmentPropertyList;
        synchronized (databasePageManagerCachedFragmentPropertyList) {
            for (FragmentPropertyImpl fragmentProperty : principalFragmentPropertyList) {
                if (((BaseFragmentElementImpl)fragmentProperty.getFragment()).getIdentity() != baseFragmentElementImpl.getIdentity()) continue;
                if (filteredList == null) {
                    filteredList = new ArrayList<FragmentPropertyImpl>();
                }
                filteredList.add(fragmentProperty);
            }
        }
        return filteredList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeAllPrincipalFragmentPropertyList(DatabasePageManagerCachedFragmentPropertyList principalFragmentPropertyList, BaseFragmentElementImpl baseFragmentElementImpl) {
        DatabasePageManagerCachedFragmentPropertyList databasePageManagerCachedFragmentPropertyList = principalFragmentPropertyList;
        synchronized (databasePageManagerCachedFragmentPropertyList) {
            Iterator iter = principalFragmentPropertyList.iterator();
            while (iter.hasNext()) {
                FragmentPropertyImpl fragmentProperty = (FragmentPropertyImpl)iter.next();
                if (((BaseFragmentElementImpl)fragmentProperty.getFragment()).getIdentity() != baseFragmentElementImpl.getIdentity()) continue;
                iter.remove();
            }
        }
    }

    public static void rollbackTransactions() {
        fragmentPropertyListsCache.remove();
    }

    public static void clearTransactions() {
    }

    public FragmentPropertyManagement getFragmentPropertyManager() {
        return this;
    }

    public FragmentPropertyList getFragmentPropertyList(BaseFragmentElement baseFragmentElement, FragmentPropertyList transientList) {
        return this.getFragmentPropertyList((BaseFragmentElementImpl)baseFragmentElement, transientList);
    }

    public void removeFragmentPropertyList(BaseFragmentElement baseFragmentElement, FragmentPropertyList transientList) {
        this.removeFragmentPropertyList((BaseFragmentElementImpl)baseFragmentElement, transientList);
    }

    public void updateFragmentPropertyList(BaseFragmentElement baseFragmentElement, String scope, FragmentPropertyList transientList) {
        this.updateFragmentPropertyList((BaseFragmentElementImpl)baseFragmentElement, scope, transientList);
    }

    static {
        modelClasses.put("FragmentImpl", FragmentImpl.class);
        modelClasses.put("PageImpl", PageImpl.class);
        modelClasses.put("FolderImpl", FolderImpl.class);
        modelClasses.put("LinkImpl", LinkImpl.class);
        modelClasses.put("PageSecurityImpl", PageSecurityImpl.class);
        modelClasses.put("FolderMenuDefinitionImpl", FolderMenuDefinitionImpl.class);
        modelClasses.put("FolderMenuExcludeDefinitionImpl", FolderMenuExcludeDefinitionImpl.class);
        modelClasses.put("FolderMenuIncludeDefinitionImpl", FolderMenuIncludeDefinitionImpl.class);
        modelClasses.put("FolderMenuOptionsDefinitionImpl", FolderMenuOptionsDefinitionImpl.class);
        modelClasses.put("FolderMenuSeparatorDefinitionImpl", FolderMenuSeparatorDefinitionImpl.class);
        modelClasses.put("PageMenuDefinitionImpl", PageMenuDefinitionImpl.class);
        modelClasses.put("PageMenuExcludeDefinitionImpl", PageMenuExcludeDefinitionImpl.class);
        modelClasses.put("PageMenuIncludeDefinitionImpl", PageMenuIncludeDefinitionImpl.class);
        modelClasses.put("PageMenuOptionsDefinitionImpl", PageMenuOptionsDefinitionImpl.class);
        modelClasses.put("PageMenuSeparatorDefinitionImpl", PageMenuSeparatorDefinitionImpl.class);
        modelClasses.put("SecurityConstraintsImpl", SecurityConstraintsImpl.class);
        modelClasses.put("FolderSecurityConstraintImpl", FolderSecurityConstraintImpl.class);
        modelClasses.put("PageSecurityConstraintImpl", PageSecurityConstraintImpl.class);
        modelClasses.put("FragmentSecurityConstraintImpl", FragmentSecurityConstraintImpl.class);
        modelClasses.put("LinkSecurityConstraintImpl", LinkSecurityConstraintImpl.class);
        modelClasses.put("PageSecuritySecurityConstraintImpl", PageSecuritySecurityConstraintImpl.class);
        modelClasses.put("SecurityConstraintsDefImpl", SecurityConstraintsDefImpl.class);
        modelClasses.put("FragmentPreferenceImpl", FragmentPreferenceImpl.class);
        modelClasses.put("FragmentReferenceImpl", FragmentReferenceImpl.class);
        modelClasses.put("PageFragmentImpl", PageFragmentImpl.class);
        modelClasses.put("PageTemplateImpl", PageTemplateImpl.class);
        modelClasses.put("DynamicPageImpl", DynamicPageImpl.class);
        modelClasses.put("FragmentDefinitionImpl", FragmentDefinitionImpl.class);
        modelClasses.put("FragmentPropertyImpl", FragmentPropertyImpl.class);
    }
}

