/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.administration;

import java.io.FileReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.Configuration;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.administration.AdminUtil;
import org.apache.jetspeed.administration.AdministrationEmailException;
import org.apache.jetspeed.administration.PasswordGenerator;
import org.apache.jetspeed.administration.PortalAdministration;
import org.apache.jetspeed.administration.RegistrationException;
import org.apache.jetspeed.administration.SimplePasswordGeneratorImpl;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.mockobjects.MockHttpServletRequest;
import org.apache.jetspeed.mockobjects.request.MockRequestContext;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.folder.InvalidFolderException;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.portalsite.PortalSite;
import org.apache.jetspeed.portalsite.PortalSiteRequestContext;
import org.apache.jetspeed.portalsite.PortalSiteSessionContext;
import org.apache.jetspeed.profiler.Profiler;
import org.apache.jetspeed.profiler.rules.ProfilingRule;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.GroupManager;
import org.apache.jetspeed.security.JSSubject;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.RoleManager;
import org.apache.jetspeed.security.SecurityAttributes;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;

public class PortalAdministrationImpl
implements PortalAdministration {
    private static final Logger log = LoggerFactory.getLogger(PortalAdministrationImpl.class);
    protected Configuration config;
    protected UserManager userManager;
    protected RoleManager roleManager;
    protected GroupManager groupManager;
    protected PageManager pageManager;
    protected Profiler profiler;
    protected PortalSite portalSite;
    protected JavaMailSender mailSender;
    protected VelocityEngine velocityEngine;
    protected PasswordGenerator passwordGenerator;
    protected List defaultRoles;
    protected List defaultGroups;
    protected Map defaultRules;
    protected String folderTemplate;
    protected String adminUser;
    protected String adminRole;
    private static final String USER_NOT_FOUND_FROM_EMAIL = "User not found for Email address: ";
    Map forgottenPasswordData = new HashMap();

    public PortalAdministrationImpl(UserManager userManager, RoleManager roleManager, GroupManager groupManager, PageManager pageManager, Profiler profiler, PortalSite portalSite, JavaMailSender mailSender, VelocityEngine velocityEngine) {
        this.userManager = userManager;
        this.roleManager = roleManager;
        this.groupManager = groupManager;
        this.pageManager = pageManager;
        this.profiler = profiler;
        this.portalSite = portalSite;
        this.mailSender = mailSender;
        this.velocityEngine = velocityEngine;
        this.passwordGenerator = new SimplePasswordGeneratorImpl();
    }

    public void setPasswordGenerator(PasswordGenerator passwordGenerator) {
        if (passwordGenerator != null) {
            this.passwordGenerator = passwordGenerator;
        }
    }

    public void start() {
        this.config = (Configuration)Jetspeed.getComponentManager().getComponent((Object)"portal_configuration");
        this.defaultRoles = this.config.getList("registration.roles.default");
        this.defaultGroups = this.config.getList("registration.groups.default");
        Object[] profileRuleNames = this.config.getList("profiler.rule.names.default").toArray();
        Object[] profileRuleValues = this.config.getList("profiler.rule.values.default").toArray();
        this.defaultRules = new HashMap();
        if (profileRuleNames != null && profileRuleValues != null) {
            for (int ix = 0; ix < (profileRuleNames.length < profileRuleValues.length ? profileRuleNames.length : profileRuleValues.length); ++ix) {
                this.defaultRules.put(profileRuleNames[ix], profileRuleValues[ix]);
            }
        }
        this.folderTemplate = this.config.getString("psml.template.folder");
        this.adminUser = this.config.getString("default.admin.user");
        this.adminRole = this.config.getString("default.admin.role");
    }

    public void registerUser(String userName, String password) throws RegistrationException {
        this.registerUser(userName, password, null, null, null, null, null);
    }

    public void registerUser(String userName, String password, List roles, List groups, Map userInfo, Map rules, String folderTemplate) throws RegistrationException {
        this.registerUser(userName, password, roles, groups, userInfo, rules, folderTemplate, null);
    }

    public void registerUser(String userName, String password, List roles, List groups, Map userInfo, Map rules, String folderTemplate, String subsite) throws RegistrationException {
        this.registerUser(userName, password, roles, groups, userInfo, rules, folderTemplate, subsite, null, null);
    }

    public void registerUser(String userName, String password, List roles, List groups, Map userInfo, Map rules, String folderTemplate, String subsite, Locale locale, String serverName) throws RegistrationException {
        block17: {
            try {
                User user = this.userManager.addUser(userName);
                PasswordCredential pwc = this.userManager.getPasswordCredential(user);
                pwc.setPassword(null, password);
                this.userManager.storePasswordCredential(pwc);
                if (roles == null || roles.isEmpty()) {
                    roles = this.defaultRoles;
                }
                if (roles != null) {
                    for (String role : roles) {
                        if (role.trim().length() <= 0) continue;
                        this.roleManager.addRoleToUser(userName, role);
                    }
                }
                if (groups == null || groups.isEmpty()) {
                    groups = this.defaultGroups;
                }
                if (groups != null) {
                    for (String group : groups) {
                        if (group.trim().length() <= 0) continue;
                        this.groupManager.addUserToGroup(userName, group);
                    }
                }
                if (userInfo != null) {
                    SecurityAttributes userAttrs = user.getSecurityAttributes();
                    for (Map.Entry entry : userInfo.entrySet()) {
                        userAttrs.getAttribute((String)entry.getKey(), true).setStringValue((String)entry.getValue());
                    }
                }
                if (rules == null || rules.isEmpty()) {
                    rules = this.defaultRules;
                }
                if (rules != null) {
                    for (Map.Entry entry : rules.entrySet()) {
                        ProfilingRule rule = this.profiler.getRule((String)entry.getValue());
                        if (rule == null) continue;
                        this.profiler.setRuleForPrincipal((Principal)user, rule, (String)entry.getKey());
                    }
                }
                if (folderTemplate == null) {
                    folderTemplate = this.folderTemplate;
                }
                String userFolderPath = null;
                userFolderPath = subsite == null && serverName != null ? this.invokeGetUserFolderPath(user, locale, serverName) : (subsite != null ? subsite + "/_user/" + userName : "/_user/" + userName);
                final String innerFolderTemplate = folderTemplate;
                final String innerUserFolderPath = userFolderPath;
                final PageManager innerPageManager = this.pageManager;
                final String innerUserName = userName;
                final User innerUser = user;
                User powerUser = this.userManager.getUser(this.adminUser);
                JetspeedException pe = (JetspeedException)((Object)JSSubject.doAsPrivileged((Subject)this.userManager.getSubject(powerUser), (PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        try {
                            if (innerUserFolderPath != null) {
                                innerUser.getSecurityAttributes().getAttribute("org.apache.jetspeed.user.subsite", true).setStringValue(innerUserFolderPath);
                                PortalAdministrationImpl.this.userManager.updateUser(innerUser);
                            }
                            Folder source = innerPageManager.getFolder(innerFolderTemplate);
                            innerPageManager.deepCopyFolder(source, innerUserFolderPath, innerUserName);
                            Folder newFolder = PortalAdministrationImpl.this.pageManager.getFolder(innerUserFolderPath);
                            newFolder.setTitle("My Home Space");
                            newFolder.setShortTitle("My Space");
                            return null;
                        }
                        catch (SecurityException s1) {
                            return s1;
                        }
                        catch (FolderNotFoundException e1) {
                            return e1;
                        }
                        catch (InvalidFolderException e1) {
                            return e1;
                        }
                        catch (NodeException e1) {
                            return e1;
                        }
                    }
                }, null));
                if (pe == null) break block17;
                try {
                    if (this.userManager.getUser(userName) != null) {
                        this.userManager.removeUser(userName);
                    }
                }
                catch (Exception e) {
                    log.error("Registration Error: Failed to rollback user " + userName);
                }
                log.error("Registration Error: Failed to create user folders for " + userName + ", " + pe.toString());
                throw pe;
            }
            catch (Exception e) {
                log.error("Registration Error: Failed to create registered user " + userName + ", " + e.toString());
                throw new RegistrationException((Throwable)e);
            }
        }
    }

    public String generatePassword() {
        return this.passwordGenerator.generatePassword();
    }

    public void sendEmail(PortletConfig portletConfig, String emailAddress, String localizedSubject, String localizedTemplatePath, Map userAttributes) throws AdministrationEmailException {
        String from = this.config.getString("email.sender");
        String subject = localizedSubject;
        String to = emailAddress;
        String text = this.mergeEmailTemplate(portletConfig, userAttributes, "map", localizedTemplatePath);
        this.sendEmail(from, subject, to, text);
    }

    public void sendEmail(String from, String subject, String to, String text) throws AdministrationEmailException {
        SimpleMailMessage msg = new SimpleMailMessage();
        if (from == null) {
            from = "jetspeed-admin@apache.org";
        }
        msg.setFrom(from);
        if (subject == null) {
            subject = "message from jetspeed";
        }
        msg.setSubject(subject);
        msg.setTo(to);
        msg.setText(text);
        try {
            this.mailSender.send(msg);
        }
        catch (MailException ex) {
            throw new AdministrationEmailException("Failed to send forgotten password email to user with email address because " + ex.getMessage(), (Throwable)ex);
        }
    }

    public String mergeEmailTemplate(PortletConfig portletConfig, Map attributes, String attributesName, String template) throws AdministrationEmailException {
        VelocityContext context = new VelocityContext();
        context.put(attributesName, (Object)attributes);
        StringWriter writer = new StringWriter();
        try {
            String realTemplatePath = portletConfig.getPortletContext().getRealPath(template);
            FileReader templateReader = new FileReader(realTemplatePath);
            this.velocityEngine.evaluate((Context)context, (Writer)writer, "UserEmailProcessor", (Reader)templateReader);
        }
        catch (Exception e) {
            throw new AdministrationEmailException("Failed to generate email text for email template " + template, (Throwable)e);
        }
        String buffer = writer.getBuffer().toString();
        return buffer;
    }

    public User lookupUserFromEmail(String email) throws AdministrationEmailException {
        List users;
        try {
            users = this.userManager.lookupUsers("user.business-info.online.email", email);
        }
        catch (SecurityException e) {
            throw new AdministrationEmailException((Throwable)e);
        }
        if (users.isEmpty()) {
            throw new AdministrationEmailException(USER_NOT_FOUND_FROM_EMAIL + email);
        }
        return (User)users.iterator().next();
    }

    public String getPortalURL(PortletRequest request, PortletResponse response, String path) {
        RequestContext context = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        String baseUrl = context.getPortalURL().getBaseURL();
        String basePath = context.getPortalURL().getBasePath();
        if (basePath != null && basePath.endsWith("/action")) {
            basePath = basePath.replace("/action", "/desktop");
        }
        String jetspeedPath = AdminUtil.concatenatePaths(baseUrl, basePath);
        if (path == null) {
            return jetspeedPath;
        }
        return AdminUtil.concatenatePaths(jetspeedPath, response.encodeURL(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getNewLoginInfo(String guid) {
        Map map = this.forgottenPasswordData;
        synchronized (map) {
            return (Map)this.forgottenPasswordData.get(guid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putNewLoginInfo(String guid, Map info) {
        Map map = this.forgottenPasswordData;
        synchronized (map) {
            this.forgottenPasswordData.put(guid, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNewLoginInfo(String guid) {
        Map map = this.forgottenPasswordData;
        synchronized (map) {
            this.forgottenPasswordData.remove(guid);
        }
    }

    public boolean isAdminUser(PortletRequest request) {
        if (this.adminUser == null) {
            throw new IllegalStateException("PortalAdministration component is not started or misconfigured for the default admin user.");
        }
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            return this.adminUser.equals(principal.getName());
        }
        return false;
    }

    public boolean isUserInAdminRole(PortletRequest request) {
        if (this.adminRole == null) {
            throw new IllegalStateException("PortalAdministration component is not started or misconfigured for the default admin role.");
        }
        return request.isUserInRole(this.adminRole);
    }

    public String getUserFolderPath(String userName, Locale locale, String serverName) {
        try {
            User user = this.userManager.getUser(userName);
            return this.invokeGetUserFolderPath(user, locale, serverName);
        }
        catch (Exception e) {
            log.error("Unexpected exception getting user folder path for " + userName + ": " + e, (Throwable)e);
            return null;
        }
    }

    public String getBaseFolderPath(String userName, Locale locale, String serverName) {
        try {
            User user = this.userManager.getUser(userName);
            return this.invokeGetBaseFolderPath(user, locale, serverName);
        }
        catch (Exception e) {
            log.error("Unexpected exception getting base folder path for " + userName + ": " + e, (Throwable)e);
            return null;
        }
    }

    private String invokeGetUserFolderPath(final User user, final Locale locale, final String serverName) throws Exception {
        if (this.config.getString("jetui.customization.method").equals("ajax")) {
            return "/_user/" + user.getName();
        }
        Object doneAs = JSSubject.doAsPrivileged((Subject)this.userManager.getSubject(user), (PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    PortalSiteRequestContext requestContext = PortalAdministrationImpl.this.getMockPortalSiteRequestContext(user, locale, serverName);
                    return requestContext.getUserFolderPath();
                }
                catch (Exception e) {
                    return e;
                }
            }
        }, null);
        if (doneAs instanceof Exception) {
            throw (Exception)doneAs;
        }
        return (String)doneAs;
    }

    private String invokeGetBaseFolderPath(final User user, final Locale locale, final String serverName) throws Exception {
        Object doneAs = JSSubject.doAsPrivileged((Subject)this.userManager.getSubject(user), (PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    PortalSiteRequestContext requestContext = PortalAdministrationImpl.this.getMockPortalSiteRequestContext(user, locale, serverName);
                    return requestContext.getBaseFolderPath();
                }
                catch (Exception e) {
                    return e;
                }
            }
        }, null);
        if (doneAs instanceof Exception) {
            throw (Exception)doneAs;
        }
        return (String)doneAs;
    }

    private PortalSiteRequestContext getMockPortalSiteRequestContext(User user, Locale locale, String serverName) throws Exception {
        MockRequestContext request = new MockRequestContext("/");
        request.setSubject(this.userManager.getSubject(user));
        request.setLocale(locale != null ? locale : Locale.getDefault());
        MockHttpServletRequest servletRequest = new MockHttpServletRequest();
        if (serverName != null) {
            servletRequest.setServerName(serverName);
        }
        request.setRequest((HttpServletRequest)servletRequest);
        Map locators = this.profiler.getProfileLocators((RequestContext)request, (Principal)user);
        if (locators.size() == 0) {
            locators = this.profiler.getDefaultProfileLocators((RequestContext)request);
        }
        if (locators.size() == 0) {
            locators.put("page", this.profiler.getProfile((RequestContext)request, "page"));
        }
        PortalSiteSessionContext sessionContext = this.portalSite.newSessionContext();
        return sessionContext.newRequestContext(locators, user.getName());
    }
}

