/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.aggregator.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jetspeed.aggregator.PageAggregator;
import org.apache.jetspeed.aggregator.PortletAccessDeniedException;
import org.apache.jetspeed.aggregator.PortletRenderer;
import org.apache.jetspeed.aggregator.RenderingJob;
import org.apache.jetspeed.aggregator.impl.BaseAggregatorImpl;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.container.state.NavigationalState;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncPageAggregatorImpl
extends BaseAggregatorImpl
implements PageAggregator {
    protected static final Logger log = LoggerFactory.getLogger(AsyncPageAggregatorImpl.class);

    public AsyncPageAggregatorImpl(PortletRenderer renderer) {
        super(renderer);
    }

    public void build(RequestContext context) throws JetspeedException, IOException {
        ContentPage page = context.getPage();
        if (null == page) {
            throw new JetspeedException("Failed to find PSML Pin ContentPageAggregator.build");
        }
        ContentFragment root = page.getRootFragment();
        if (root == null) {
            throw new JetspeedException("No root ContentFragment found in ContentPage");
        }
        NavigationalState nav = context.getPortalURL().getNavigationalState();
        PortletWindow window = nav.getMaximizedWindow();
        if (null != window) {
            this.renderMaximizedWindow(context, page, root, window);
        } else {
            this.aggregateAndRender(root, context, page, true, null, null, null);
        }
        this.renderContent(context, root);
        if (null != window) {
            window.removeAttribute("org.apache.jetspeed.maximized.Fragment");
            window.removeAttribute("org.apache.jetspeed.maximized.Layout");
        }
        this.releaseBuffers(root, context);
    }

    protected void aggregateAndRender(ContentFragment f, RequestContext context, ContentPage page, boolean isRoot, List<RenderingJob> sequentialJobs, List<RenderingJob> parallelJobs, List<ContentFragment> layoutFragments) {
        if (sequentialJobs == null) {
            sequentialJobs = new ArrayList<RenderingJob>();
        }
        if (parallelJobs == null) {
            parallelJobs = new ArrayList<RenderingJob>();
        }
        if (layoutFragments == null) {
            layoutFragments = new ArrayList<ContentFragment>();
        }
        if (f.getFragments() != null) {
            for (ContentFragment child : f.getFragments()) {
                if ("hidden".equals(f.getState())) continue;
                if (child.getType().equals("portlet")) {
                    try {
                        RenderingJob job = this.renderer.createRenderingJob(child, context);
                        if (job == null) continue;
                        if (job.getTimeout() > 0L) {
                            parallelJobs.add(job);
                            continue;
                        }
                        sequentialJobs.add(job);
                    }
                    catch (PortletAccessDeniedException e) {
                        child.overrideRenderedContent(e.getLocalizedMessage());
                    }
                    continue;
                }
                this.aggregateAndRender(child, context, page, false, sequentialJobs, parallelJobs, layoutFragments);
                layoutFragments.add(child);
            }
        }
        if (!isRoot) {
            return;
        }
        int parallelJobCount = parallelJobs.size();
        int sequentialJobCount = sequentialJobs.size();
        if (log.isInfoEnabled()) {
            log.info("Aggregating " + page.getPath() + ". Parallel: " + parallelJobCount + ", Sequential: " + sequentialJobCount);
        }
        for (RenderingJob job : parallelJobs) {
            this.renderer.processRenderingJob(job);
        }
        for (RenderingJob job : sequentialJobs) {
            this.renderer.processRenderingJob(job);
        }
        this.renderer.waitForRenderingJobs(parallelJobs);
        for (ContentFragment child : layoutFragments) {
            this.renderer.renderNow(child, context);
        }
        if (log.isDebugEnabled()) {
            log.debug("Rendering portlet fragment: [[name, " + f.getName() + "], [id, " + f.getId() + "]]");
        }
        this.renderer.renderNow(f, context);
    }
}

