/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.aggregator.impl;

import java.io.IOException;
import org.apache.jetspeed.aggregator.PortletContent;
import org.apache.jetspeed.aggregator.PortletRenderer;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAggregatorImpl {
    private static final Logger log = LoggerFactory.getLogger(BaseAggregatorImpl.class);
    protected PortletRenderer renderer;

    public BaseAggregatorImpl(PortletRenderer renderer) {
        this.renderer = renderer;
    }

    protected void releaseBuffers(ContentFragment f, RequestContext context) {
        PortletContent content;
        if (f.getFragments() != null) {
            for (ContentFragment child : f.getFragments()) {
                if ("hidden".equals(child.getState())) continue;
                this.releaseBuffers(child, context);
            }
        }
        if ((content = f.getPortletContent()) != null && content.getExpiration() == 0) {
            content.release();
        }
    }

    protected void renderMaximizedWindow(RequestContext context, ContentPage page, ContentFragment layoutContentFragment, PortletWindow window) {
        PortletWindow layoutWindow;
        boolean maxedLayout = false;
        if (window.getFragment().getId().equals(layoutContentFragment.getId())) {
            layoutWindow = window;
            maxedLayout = true;
        } else {
            layoutWindow = context.getPortletWindow(layoutContentFragment);
        }
        layoutWindow.setAttribute("org.apache.jetspeed.maximized.Fragment", (Object)window.getFragment());
        layoutWindow.setAttribute("org.apache.jetspeed.maximized.Layout", (Object)page.getRootFragment());
        try {
            this.renderer.renderNow(window.getFragment(), context);
            if (!maxedLayout) {
                this.renderer.renderNow(layoutContentFragment, context);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            window.getFragment().overrideRenderedContent("Sorry, but we were unable access the requested portlet. Send the following message to your portal admin:  " + e.getMessage());
        }
    }

    public void renderContent(RequestContext context, ContentFragment root) throws JetspeedException, IOException {
        context.getResponse().getWriter().write(root.getRenderedContent());
    }
}

