/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.aggregator.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.aggregator.PortletAggregator;
import org.apache.jetspeed.aggregator.PortletContent;
import org.apache.jetspeed.aggregator.PortletRenderer;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.container.state.MutableNavigationalState;
import org.apache.jetspeed.container.state.NavigationalState;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.portlet.HeadElement;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.util.HeadElementUtils;
import org.apache.jetspeed.util.KeyValue;

public class PortletAggregatorImpl
implements PortletAggregator {
    private PortletRenderer renderer;
    private boolean titleInHeader;
    private Map<String, PortletMode> availablePortletModesMap;
    private Map<String, WindowState> availableWindowStatesMap;

    public PortletAggregatorImpl(PortletRenderer renderer) {
        this(renderer, false);
    }

    public PortletAggregatorImpl(PortletRenderer renderer, boolean titleInHeader) {
        this.renderer = renderer;
        this.titleInHeader = titleInHeader;
    }

    public void build(RequestContext context) throws JetspeedException, IOException {
        String entity = context.getRequestParameter("entity");
        if (entity == null) {
            entity = (String)context.getAttribute("entity");
        }
        if (entity == null) {
            return;
        }
        PortletWindow window = context.resolvePortletWindow(entity);
        if (window == null) {
            String name = context.getRequestParameter("portlet");
            if (name == null) {
                name = (String)context.getAttribute("portlet");
            }
            if (name == null) {
                return;
            }
            window = context.getInstantlyCreatedPortletWindow(entity, name);
        }
        PortletMode requetedPortletMode = this.getRequestedPortletMode(context);
        WindowState requetedWindowState = this.getRequestedWindowState(context);
        NavigationalState navState = context.getPortalURL().getNavigationalState();
        if (navState instanceof MutableNavigationalState) {
            MutableNavigationalState mutableNavState = (MutableNavigationalState)navState;
            if (!requetedPortletMode.equals((Object)navState.getMode(window))) {
                mutableNavState.setMode(window, requetedPortletMode);
            }
            if (!requetedWindowState.equals((Object)navState.getState(window))) {
                mutableNavState.setState(window, requetedWindowState);
            }
        }
        ContentFragment contentFragment = window.getFragment();
        this.renderer.renderNow(contentFragment, context);
        if (this.titleInHeader && contentFragment.getPortletContent() != null) {
            context.getResponse().setHeader("JS_PORTLET_TITLE", StringEscapeUtils.escapeHtml((String)contentFragment.getPortletContent().getTitle()));
        }
        this.writeHeadElements(context, window);
        context.getResponse().getWriter().write(contentFragment.getRenderedContent());
        PortletContent content = contentFragment.getPortletContent();
        if (content != null && content.getExpiration() == 0) {
            contentFragment.getPortletContent().release();
        }
    }

    protected void writeHeadElements(RequestContext context, PortletWindow window) throws IOException {
        List headElements = window.getHeadElements();
        if (!headElements.isEmpty()) {
            PrintWriter out = context.getResponse().getWriter();
            out.println("<JS_PORTLET_HEAD_ELEMENTS>");
            for (KeyValue kvPair : headElements) {
                HeadElement headElement = (HeadElement)kvPair.getValue();
                out.println(HeadElementUtils.toHtmlString(headElement));
            }
            out.print("</JS_PORTLET_HEAD_ELEMENTS>");
        }
    }

    private PortletMode getRequestedPortletMode(RequestContext context) {
        PortletMode portletMode;
        String portletModeName = context.getRequestParameter("mode");
        if (StringUtils.isBlank((String)portletModeName)) {
            return PortletMode.VIEW;
        }
        if (this.availablePortletModesMap == null) {
            HashMap<String, PortletMode> portletModesMap = new HashMap<String, PortletMode>();
            for (PortletMode portletMode2 : JetspeedActions.getStandardPortletModes()) {
                portletModesMap.put(portletMode2.toString(), portletMode2);
            }
            for (PortletMode portletMode2 : JetspeedActions.getExtendedPortletModes()) {
                portletModesMap.put(portletMode2.toString(), portletMode2);
            }
            this.availablePortletModesMap = portletModesMap;
        }
        return (portletMode = this.availablePortletModesMap.get(portletModeName)) != null ? portletMode : PortletMode.VIEW;
    }

    private WindowState getRequestedWindowState(RequestContext context) {
        WindowState windowState;
        String windowStateName = context.getRequestParameter("state");
        if (StringUtils.isBlank((String)windowStateName)) {
            return WindowState.NORMAL;
        }
        if (this.availableWindowStatesMap == null) {
            HashMap<String, WindowState> windowStatesMap = new HashMap<String, WindowState>();
            for (WindowState windowState2 : JetspeedActions.getStandardWindowStates()) {
                windowStatesMap.put(windowState2.toString(), windowState2);
            }
            for (WindowState windowState2 : JetspeedActions.getExtendedWindowStates()) {
                windowStatesMap.put(windowState2.toString(), windowState2);
            }
            this.availableWindowStatesMap = windowStatesMap;
        }
        return (windowState = this.availableWindowStatesMap.get(windowStateName)) != null ? windowState : WindowState.NORMAL;
    }
}

