/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.aggregator.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.aggregator.PortletAccessDeniedException;
import org.apache.jetspeed.aggregator.PortletContent;
import org.apache.jetspeed.aggregator.PortletRenderer;
import org.apache.jetspeed.aggregator.PortletTrackingManager;
import org.apache.jetspeed.aggregator.RenderingJob;
import org.apache.jetspeed.aggregator.WorkerMonitor;
import org.apache.jetspeed.aggregator.impl.PortletContentImpl;
import org.apache.jetspeed.aggregator.impl.RenderingJobImpl;
import org.apache.jetspeed.cache.CacheElement;
import org.apache.jetspeed.cache.ContentCacheKey;
import org.apache.jetspeed.cache.JetspeedCache;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.portlet.LocalizedField;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SecurityAccessController;
import org.apache.jetspeed.statistics.PortalStatistics;
import org.apache.pluto.container.PortletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletRendererImpl
implements PortletRenderer {
    protected static final Logger log = LoggerFactory.getLogger(PortletRendererImpl.class);
    protected WorkerMonitor workMonitor;
    protected PortletContainer container;
    protected PortalStatistics statistics;
    protected PortletTrackingManager portletTracking;
    protected boolean checkSecurityConstraints;
    protected SecurityAccessController accessController;
    protected JetspeedCache portletContentCache;
    public static final String DEFAULT_OUT_OF_SERVICE_MESSAGE = "Portlet is not responding and has been taken out of service.";
    protected String outOfServiceMessage = "Portlet is not responding and has been taken out of service.";

    public PortletRendererImpl(PortletContainer container, WorkerMonitor workMonitor, PortalStatistics statistics, PortletTrackingManager portletTracking, boolean checkSecurityConstraints, SecurityAccessController accessController, JetspeedCache portletContentCache) {
        this.container = container;
        this.workMonitor = workMonitor;
        this.statistics = statistics;
        this.portletTracking = portletTracking;
        this.checkSecurityConstraints = checkSecurityConstraints;
        this.accessController = accessController;
        this.portletContentCache = portletContentCache;
    }

    public PortletRendererImpl(PortletContainer container, WorkerMonitor workMonitor, PortalStatistics statistics) {
        this(container, workMonitor, statistics, null, false, null, null);
    }

    public PortletRendererImpl(PortletContainer container, WorkerMonitor workMonitor) {
        this(container, workMonitor, null);
    }

    public void start() {
    }

    public void stop() {
    }

    public void setOutOfServiceMessage(String outOfServiceMessage) {
        this.outOfServiceMessage = outOfServiceMessage;
    }

    public void renderNow(ContentFragment fragment, RequestContext requestContext) {
        this.renderNow(fragment, requestContext, false);
    }

    public void renderNow(ContentFragment fragment, RequestContext requestContext, boolean spawned) {
        try {
            RenderingJob rJob = this.createRenderingJob(fragment, requestContext);
            if (rJob != null) {
                if (spawned) {
                    ArrayList<RenderingJob> jobs = new ArrayList<RenderingJob>();
                    jobs.add(rJob);
                    this.processRenderingJob(rJob, true);
                    this.waitForRenderingJobs(jobs);
                } else {
                    rJob.execute();
                }
            }
        }
        catch (PortletAccessDeniedException e) {
            fragment.overrideRenderedContent(e.getLocalizedMessage());
        }
        catch (Exception e) {
            fragment.overrideRenderedContent(e.getLocalizedMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void renderNow(ContentFragment fragment, HttpServletRequest request, HttpServletResponse response) {
        RequestContext requestContext = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        this.renderNow(fragment, requestContext);
    }

    protected int getExpirationCache(PortletDefinition portletDefinition) {
        return portletDefinition == null ? 0 : portletDefinition.getExpirationCache();
    }

    public RenderingJob createRenderingJob(ContentFragment fragment, RequestContext requestContext) throws PortletAccessDeniedException {
        RenderingJob job = null;
        try {
            PortletWindow portletWindow = requestContext.getPortletWindow(fragment);
            if (!portletWindow.isValid()) {
                return null;
            }
            PortletDefinition portletDefinition = portletWindow.getPortletDefinition();
            long timeoutMetadata = this.getTimeoutOnJob(portletDefinition);
            this.portletTracking.setExpiration(portletWindow, timeoutMetadata);
            if (this.checkSecurityConstraints && !this.checkSecurityConstraint(portletDefinition, fragment)) {
                throw new PortletAccessDeniedException("Access Denied.");
            }
            if (this.portletTracking.isOutOfService(portletWindow)) {
                log.info("Taking portlet out of service: " + portletDefinition.getUniqueName() + " for window " + portletWindow.getId());
                fragment.overrideRenderedContent(this.outOfServiceMessage);
                return null;
            }
            int expirationCache = this.getExpirationCache(portletDefinition);
            if (expirationCache != 0) {
                this.portletTracking.setExpiration(portletWindow, (long)expirationCache);
                if (this.retrieveCachedContent(requestContext, portletWindow, expirationCache, portletDefinition)) {
                    return null;
                }
            }
            job = this.buildRenderingJob(portletWindow, requestContext, true, portletDefinition, timeoutMetadata);
        }
        catch (PortletAccessDeniedException pade) {
            throw pade;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create rendering job", e);
        }
        return job;
    }

    public void processRenderingJob(RenderingJob job) {
        this.processRenderingJob(job, false);
    }

    protected void processRenderingJob(RenderingJob job, boolean parallelOnly) {
        try {
            if (parallelOnly || job.getTimeout() > 0L) {
                this.workMonitor.process(job);
            } else {
                job.execute();
            }
        }
        catch (Exception e1) {
            log.error("render() failed: " + e1.toString(), (Throwable)e1);
            job.getFragment().overrideRenderedContent(e1.getLocalizedMessage());
        }
    }

    public void waitForRenderingJobs(List<RenderingJob> renderingJobs) {
        this.workMonitor.waitForRenderingJobs(renderingJobs);
    }

    protected boolean retrieveCachedContent(RequestContext requestContext, PortletWindow portletWindow, int expiration, PortletDefinition portletDefinition) throws Exception {
        ContentFragment fragment = portletWindow.getFragment();
        ContentCacheKey cacheKey = this.portletContentCache.createCacheKey(requestContext, fragment.getId());
        CacheElement cachedElement = this.portletContentCache.get((Object)cacheKey);
        if (cachedElement != null) {
            PortletContent portletContent = (PortletContent)cachedElement.getContent();
            PortletMode portletMode = portletContent.getPortletMode();
            WindowState windowState = portletContent.getWindowState();
            if (portletWindow.getPortletMode().equals((Object)portletMode) && portletWindow.getWindowState().equals((Object)windowState)) {
                fragment.setPortletContent(portletContent);
                return true;
            }
        }
        return false;
    }

    protected PortletContent createPortletContent(RequestContext request, PortletWindow portletWindow, int expirationCache) {
        ContentCacheKey cacheKey = this.portletContentCache.createCacheKey(request, portletWindow.getFragment().getId());
        String title = portletWindow.getFragment().getTitle();
        if (title == null) {
            title = request.getPreferedLanguage(portletWindow.getPortletDefinition()).getTitle();
        }
        if (title == null) {
            title = portletWindow.getPortletDefinition().getPortletName();
        }
        return new PortletContentImpl(cacheKey, expirationCache, title, portletWindow.getPortletMode(), portletWindow.getWindowState());
    }

    protected RenderingJob buildRenderingJob(PortletWindow portletWindow, RequestContext requestContext, boolean isParallel, PortletDefinition portletDefinition, long timeoutMetadata) {
        int expirationCache = this.getExpirationCache(portletDefinition);
        PortletContent portletContent = this.createPortletContent(requestContext, portletWindow, expirationCache);
        RenderingJobImpl rJob = null;
        portletWindow.getFragment().setPortletContent(portletContent);
        rJob = new RenderingJobImpl(this.container, this, portletDefinition, requestContext.getRequest(), requestContext.getResponse(), requestContext, portletWindow, this.statistics, expirationCache);
        if (isParallel) {
            this.setTimeoutOnJob(timeoutMetadata, rJob);
        }
        return rJob;
    }

    protected long getTimeoutOnJob(PortletDefinition portletDefinition) {
        long timeoutMetadata = 0L;
        Collection timeoutFields = null;
        if (portletDefinition != null) {
            timeoutFields = portletDefinition.getMetadata().getFields("timeout");
        }
        if (timeoutFields != null && !timeoutFields.isEmpty()) {
            try {
                timeoutMetadata = Long.parseLong(((LocalizedField)timeoutFields.iterator().next()).getValue());
            }
            catch (NumberFormatException nfe) {
                log.warn("Invalid timeout metadata: " + nfe.getMessage());
            }
        }
        return timeoutMetadata;
    }

    protected void setTimeoutOnJob(long timeoutMetadata, RenderingJob rJob) {
        if (timeoutMetadata > 0L) {
            rJob.setTimeout(timeoutMetadata);
        } else if (this.portletTracking.getDefaultPortletTimeout() > 0L) {
            rJob.setTimeout(this.portletTracking.getDefaultPortletTimeout());
        }
    }

    protected boolean checkSecurityConstraint(PortletDefinition portlet, ContentFragment fragment) {
        if (fragment.getType().equals("portlet") && this.accessController != null) {
            return this.accessController.checkPortletAccess(portlet, 8);
        }
        return true;
    }

    protected void addToCache(RequestContext context, PortletContent content) {
        CacheElement cachedElement = this.portletContentCache.createElement((Object)content.getCacheKey(), (Object)content);
        if (content.getExpiration() == -1) {
            cachedElement.setTimeToIdleSeconds(this.portletContentCache.getTimeToIdleSeconds());
            cachedElement.setTimeToLiveSeconds(this.portletContentCache.getTimeToLiveSeconds());
        } else {
            cachedElement.setTimeToIdleSeconds(content.getExpiration());
            cachedElement.setTimeToLiveSeconds(content.getExpiration());
        }
        this.portletContentCache.put(cachedElement);
        context.getPortalURL().getNavigationalState().registerPortletContentCachedForPublicRenderParameters(context, content);
    }

    public void notifyContentComplete(RequestContext context, PortletWindow window) {
        PortletContent content = window.getFragment().getPortletContent();
        if (content.getExpiration() != 0) {
            this.addToCache(context, content);
        }
    }

    public PortletTrackingManager getPortletTrackingManager() {
        return this.portletTracking;
    }
}

