/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.ajax;

import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.ajax.AJAXException;
import org.apache.jetspeed.ajax.AJAXRequest;
import org.apache.jetspeed.ajax.AJAXRequestImpl;
import org.apache.jetspeed.ajax.AJAXService;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.AbstractValve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;

public class AJAXValve
extends AbstractValve {
    private AJAXService ajaxService;
    private PortletActionSecurityBehavior securityBehavior;

    public AJAXValve(AJAXService service, PortletActionSecurityBehavior securityBehavior) {
        this.ajaxService = service;
        this.securityBehavior = securityBehavior;
    }

    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        HttpServletResponse response = request.getResponse();
        try {
            response.setContentType("text/xml");
            if (!this.securityBehavior.checkAccess(request, "edit")) {
                throw new AJAXException("Access Denied.");
            }
            AJAXRequestImpl ajaxRequest = new AJAXRequestImpl(request.getRequest(), response, request.getConfig().getServletContext());
            this.ajaxService.processRequest((AJAXRequest)ajaxRequest);
        }
        catch (AJAXException e) {
            try {
                response.sendError(500, e.getMessage());
            }
            catch (Exception e2) {
                throw new PipelineException(e2.getMessage(), (Throwable)e2);
            }
        }
        catch (Exception e) {
            throw new PipelineException(e.getMessage(), (Throwable)e);
        }
        context.invokeNext(request);
    }

    public String toString() {
        return "AJAXValve";
    }
}

