/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.ajax;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.ajax.AJAXException;
import org.apache.jetspeed.ajax.AjaxAction;
import org.apache.jetspeed.ajax.AjaxBuilder;
import org.apache.jetspeed.ajax.AjaxRequestService;
import org.apache.jetspeed.request.RequestContext;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.generic.EscapeTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AjaxRequestServiceImpl
implements AjaxRequestService {
    protected static final String CONTENT_TYPE = "text/xml";
    protected static final String AJAX_PROCESSOR = "AJAX processor";
    protected static final String DEFAULT_ERROR = "<js><status>failure</status><action>unknown</action></js>";
    protected static final String URL_PARAMETER_NAME = "action";
    protected Logger log = LoggerFactory.getLogger(AjaxRequestServiceImpl.class);
    protected Map objects;
    protected VelocityEngine velocityEngine = null;
    protected String urlParameterName = "action";
    protected String defaultAction = "getpage";
    protected EscapeTool velocityEscTool = null;

    public AjaxRequestServiceImpl(Map objects, VelocityEngine velocityEngine) {
        this.objects = objects;
        this.velocityEngine = velocityEngine;
        this.velocityEscTool = new EscapeTool();
    }

    public AjaxRequestServiceImpl(Map objects, VelocityEngine velocityEngine, String urlParameterName) {
        this.objects = objects;
        this.velocityEngine = velocityEngine;
        this.urlParameterName = urlParameterName;
        this.velocityEscTool = new EscapeTool();
    }

    public void process(RequestContext requestContext) throws AJAXException {
        Object object;
        String objectKey = requestContext.getRequestParameter(this.urlParameterName);
        if (objectKey == null) {
            objectKey = this.defaultAction;
        }
        if ((object = this.objects.get(objectKey)) != null) {
            HashMap resultMap = new HashMap();
            boolean success = true;
            try {
                if (object instanceof AjaxAction) {
                    success = this.processAction((AjaxAction)object, requestContext, resultMap);
                }
            }
            catch (Exception e) {
                success = false;
            }
            try {
                if (object instanceof AjaxBuilder) {
                    this.processBuilder((AjaxBuilder)object, resultMap, requestContext, success);
                }
            }
            catch (Exception e) {
                this.buildError(requestContext);
            }
        } else {
            this.log.debug("could not find the object named:" + objectKey);
            this.buildError(requestContext);
        }
    }

    protected boolean processAction(AjaxAction action, RequestContext requestContext, Map resultMap) throws Exception {
        return action.run(requestContext, resultMap);
    }

    protected void processBuilder(AjaxBuilder builder, Map inputMap, RequestContext requestContext, boolean actionSuccessFlag) {
        String format = requestContext.getRequestParameter("format");
        if (format == null) {
            requestContext.getResponse().setContentType(CONTENT_TYPE);
        } else if (format.equals("json")) {
            requestContext.getResponse().setContentType("text/json");
        }
        try {
            boolean result = true;
            result = actionSuccessFlag ? builder.buildContext(requestContext, inputMap) : builder.buildErrorContext(requestContext, inputMap);
            VelocityContext context = new VelocityContext(inputMap);
            context.put("esc", (Object)this.velocityEscTool);
            if (result) {
                String templateName = null;
                templateName = actionSuccessFlag ? builder.getTemplate() : builder.getErrorTemplate();
                InputStream templateStream = this.getClass().getClassLoader().getResourceAsStream(templateName);
                InputStreamReader template = new InputStreamReader(templateStream);
                StringWriter stringWriter = new StringWriter();
                this.velocityEngine.evaluate((Context)context, (Writer)stringWriter, AJAX_PROCESSOR, (Reader)template);
                String buffer = stringWriter.getBuffer().toString();
                HttpServletResponse response = requestContext.getResponse();
                ServletOutputStream sos = response.getOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)sos, "UTF-8");
                writer.write(buffer);
                ((Writer)writer).flush();
            } else {
                this.log.error("could not create builder context");
                this.buildError(requestContext);
            }
        }
        catch (Exception e) {
            this.log.error("builder failed", (Throwable)e);
            inputMap.put("reason", e.toString());
            this.buildError(requestContext);
        }
    }

    protected void buildError(RequestContext requestContext) {
        try {
            requestContext.getResponse().getOutputStream().print(DEFAULT_ERROR);
        }
        catch (IOException e) {
            this.log.error("exception while trying to build an error message", (Throwable)e);
        }
    }

    public Map getActionMap() {
        return this.objects;
    }
}

