/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.capabilities.impl;

import java.util.Map;
import org.apache.jetspeed.capabilities.Capabilities;
import org.apache.jetspeed.capabilities.CapabilityMap;
import org.apache.jetspeed.capabilities.Client;
import org.apache.jetspeed.capabilities.MediaType;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.AbstractValve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapabilityCustomizerValveImpl
extends AbstractValve {
    private static final Logger log = LoggerFactory.getLogger(CapabilityCustomizerValveImpl.class);
    private Capabilities capabilities;
    private Map clientToMediaTypeMap;

    public CapabilityCustomizerValveImpl(Capabilities capabilities, Map clientToMediaTypeMap) {
        this.capabilities = capabilities;
        this.clientToMediaTypeMap = clientToMediaTypeMap;
    }

    public void initialize() throws PipelineException {
    }

    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        Client client;
        String mediaTypeName;
        CapabilityMap cm = request.getCapabilityMap();
        if (cm != null && this.clientToMediaTypeMap != null && (mediaTypeName = (String)this.clientToMediaTypeMap.get((client = cm.getClient()).getName())) != null) {
            MediaType mediaType = this.capabilities.getMediaType(mediaTypeName);
            cm.setPreferredMediaType(mediaType);
            request.setMediaType(mediaTypeName);
        }
        context.invokeNext(request);
    }

    public String toString() {
        return "CapabilityCustomizerValveImpl";
    }
}

