/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.capabilities.impl;

import org.apache.jetspeed.capabilities.Capabilities;
import org.apache.jetspeed.capabilities.CapabilityMap;
import org.apache.jetspeed.capabilities.MediaType;
import org.apache.jetspeed.capabilities.MimeType;
import org.apache.jetspeed.capabilities.UnableToBuildCapabilityMapException;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.CapabilityValve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapabilityValveImpl
implements CapabilityValve {
    private static final Logger log = LoggerFactory.getLogger(CapabilityValveImpl.class);
    String resourceDefault;
    private Capabilities capabilities;
    static String[][] MIME_MAP = new String[][]{{".pdf", "application/pdf"}};

    public CapabilityValveImpl(Capabilities capabilities) {
        this.capabilities = capabilities;
    }

    public void initialize() throws PipelineException {
    }

    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        boolean containerEncoding;
        CapabilityMap cm;
        String agent = request.getRequest().getHeader("User-Agent");
        try {
            cm = this.capabilities.getCapabilityMap(agent);
        }
        catch (UnableToBuildCapabilityMapException e) {
            throw new PipelineException("Falied to create capabilitied:  " + e.getMessage(), (Throwable)e);
        }
        MediaType mediaType = cm.getPreferredMediaType();
        MimeType mimeType = cm.getPreferredType();
        if (mediaType == null) {
            log.error("CapabilityMap returned a null media type");
            throw new PipelineException("CapabilityMap returned a null media type");
        }
        if (mimeType == null) {
            log.error("CapabilityMap returned a null mime type");
            throw new PipelineException("CapabilityMap returned a null mime type");
        }
        String encoding = request.getRequest().getCharacterEncoding();
        boolean bl = containerEncoding = encoding != null;
        if (encoding == null && mediaType != null && mediaType.getCharacterSet() != null) {
            encoding = mediaType.getCharacterSet();
        }
        if (log.isDebugEnabled()) {
            log.debug("MediaType: " + mediaType.getName());
            log.debug("Encoding: " + encoding);
            log.debug("Mimetype: " + mimeType.getName());
        }
        if (!containerEncoding && encoding != null) {
            request.setCharacterEncoding(encoding);
        }
        request.setCapabilityMap(cm);
        request.setMediaType(mediaType.getName());
        request.setMimeType(mimeType.getName());
        StringBuffer contentType = new StringBuffer(mimeType.getName());
        if (encoding != null) {
            contentType.append("; charset=" + encoding);
        }
        String type = contentType.toString();
        request.getResponse().setContentType(type);
        context.invokeNext(request);
    }

    protected String mapContentType(RequestContext request, String contentType) {
        String path = request.getPath();
        if (path != null) {
            for (int ix = 0; ix < MIME_MAP.length; ++ix) {
                if (!path.endsWith(MIME_MAP[ix][0])) continue;
                return MIME_MAP[ix][1];
            }
        }
        return contentType;
    }

    public String toString() {
        return "CapabilityValveImpl";
    }
}

