/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.cluster;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import org.apache.jetspeed.cluster.NodeInformation;
import org.apache.jetspeed.cluster.NodeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class NodeManagerImpl
implements NodeManager,
BeanFactoryAware {
    protected static final Logger log = LoggerFactory.getLogger(NodeManagerImpl.class);
    private BeanFactory beanFactory;
    private HashMap<String, NodeInformation> nodes = null;
    private File rootIndexDir = null;
    private String nodeInformationBean = "NodeInformation";

    public NodeManagerImpl(String indexRoot, String nodeInformationBean) throws Exception {
        this.rootIndexDir = new File(indexRoot);
        this.nodeInformationBean = nodeInformationBean;
        if (!this.rootIndexDir.exists()) {
            this.rootIndexDir.mkdirs();
        }
        this.load();
    }

    protected void save() {
        try {
            FileOutputStream fout = new FileOutputStream(this.rootIndexDir.getAbsolutePath() + "/nodeInfo.ser");
            ObjectOutputStream oos = new ObjectOutputStream(fout);
            oos.writeObject(this.nodes);
            oos.close();
        }
        catch (Exception e) {
            log.error("Failed to write nodes data file to  " + this.rootIndexDir.getAbsolutePath() + "/nodeInfo.ser" + " - error : " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    protected void load() {
        File data = new File(this.rootIndexDir.getAbsolutePath() + "/nodeInfo.ser");
        if (data.exists()) {
            try {
                FileInputStream fin = new FileInputStream(data.getAbsolutePath());
                ObjectInputStream ois = new ObjectInputStream(fin);
                this.nodes = (HashMap)ois.readObject();
                ois.close();
            }
            catch (Exception e) {
                log.error("Failed to read nodes data file from " + data.getAbsolutePath() + " - error : " + e.getLocalizedMessage());
                this.nodes = new HashMap();
            }
        } else {
            try {
                data.createNewFile();
            }
            catch (Exception e) {
                log.error("Failed to create new nodes data file error : " + e.getLocalizedMessage());
                e.printStackTrace();
            }
            this.nodes = new HashMap();
        }
    }

    public synchronized int checkNode(Long revision, String contextName) {
        if (contextName == null || revision == null) {
            return -1;
        }
        NodeInformation info = this.nodes.get(contextName);
        if (info == null) {
            return 2;
        }
        if (info.getRevision() < revision) {
            return 1;
        }
        return 0;
    }

    public synchronized void addNode(Long revision, String contextName) throws Exception {
        if (contextName == null || revision == null) {
            return;
        }
        NodeInformation info = this.nodes.get(contextName);
        if (info == null) {
            info = this.createNodeInformation();
            info.setContextName(contextName);
        }
        info.setRevision(revision);
        this.nodes.put(contextName, info);
        this.save();
    }

    public synchronized void removeNode(String contextName) throws Exception {
        if (contextName == null) {
            return;
        }
        NodeInformation info = this.nodes.get(contextName);
        if (info == null) {
            return;
        }
        this.nodes.remove(contextName);
        this.save();
    }

    protected NodeInformation createNodeInformation() throws ClassNotFoundException {
        try {
            NodeInformation nodeInformation = (NodeInformation)this.beanFactory.getBean(this.nodeInformationBean, NodeInformation.class);
            return nodeInformation;
        }
        catch (Exception e) {
            log.error("Failed to create nodeInformation for " + this.nodeInformationBean + " error : " + e.getLocalizedMessage());
            throw new ClassNotFoundException("Spring failed to create the  nodeInformation bean.", e);
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public synchronized int getNumberOfNodes() {
        return this.nodes.size();
    }
}

