/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.pluto.container.ContainerServices;
import org.apache.pluto.container.impl.PortletContainerImpl;

public class DesktopPortletContainerImpl
extends PortletContainerImpl {
    private String desktopPipelinePath = null;
    private String desktopActionPipelinePath = null;
    private String desktopRenderPipelinePath = null;

    public DesktopPortletContainerImpl(String containerName, ContainerServices containerServices, String desktopPipelinePath, String desktopActionPipelinePath, String desktopRenderPipelinePath) {
        super(containerName, containerServices);
        if (desktopPipelinePath == null || desktopPipelinePath.length() == 0) {
            desktopPipelinePath = "/desktop";
        }
        if (desktopPipelinePath.charAt(0) != '/') {
            desktopPipelinePath = "/" + desktopPipelinePath;
        }
        if (desktopPipelinePath.charAt(desktopPipelinePath.length() - 1) != '/') {
            desktopPipelinePath = desktopPipelinePath + "/";
        }
        if (desktopActionPipelinePath == null || desktopActionPipelinePath.length() == 0) {
            desktopActionPipelinePath = "/action";
        }
        if (desktopActionPipelinePath.charAt(0) != '/') {
            desktopActionPipelinePath = "/" + desktopActionPipelinePath;
        }
        if (desktopActionPipelinePath.charAt(desktopActionPipelinePath.length() - 1) != '/') {
            desktopActionPipelinePath = desktopActionPipelinePath + "/";
        }
        if (desktopRenderPipelinePath == null || desktopRenderPipelinePath.length() == 0) {
            desktopRenderPipelinePath = "/render";
        }
        if (desktopRenderPipelinePath.charAt(0) != '/') {
            desktopRenderPipelinePath = "/" + desktopRenderPipelinePath;
        }
        if (desktopRenderPipelinePath.charAt(desktopRenderPipelinePath.length() - 1) != '/') {
            desktopRenderPipelinePath = desktopRenderPipelinePath + "/";
        }
        this.desktopPipelinePath = desktopPipelinePath;
        this.desktopActionPipelinePath = desktopActionPipelinePath;
        this.desktopRenderPipelinePath = desktopRenderPipelinePath;
    }

    protected void redirect(HttpServletRequest servletRequest, HttpServletResponse servletResponse, String location) throws IOException {
        String encoding = servletRequest.getParameter("encoder");
        boolean requestIsDesktopAjax = false;
        if (encoding != null && encoding.equals("desktop")) {
            requestIsDesktopAjax = true;
            String ajaxOverride = servletRequest.getParameter("jsdajax");
            if (ajaxOverride != null && ajaxOverride.equals("false")) {
                requestIsDesktopAjax = false;
            }
        }
        HttpServletResponse redirectResponse = servletResponse;
        while (redirectResponse instanceof HttpServletResponseWrapper) {
            redirectResponse = (HttpServletResponse)((HttpServletResponseWrapper)redirectResponse).getResponse();
        }
        if (requestIsDesktopAjax) {
            location = location.replaceAll(this.desktopActionPipelinePath, this.desktopRenderPipelinePath);
            redirectResponse.getWriter().print(location);
        } else {
            location = location.replaceAll(this.desktopActionPipelinePath, this.desktopPipelinePath);
            location = location.replaceAll(this.desktopRenderPipelinePath, this.desktopPipelinePath);
            redirectResponse.sendRedirect(location);
        }
    }
}

