/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container;

import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.AbstractValve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageHistoryValve
extends AbstractValve {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String REQUEST_CLEAR_PORTLETS_MODE_AND_WINDOWSTATE_KEY = "clearPortletsModeAndWindowState";
    private final String SESSION_PREVIOUS_PAGEID_KEY = "PreviousPageId";
    private boolean valveDisabled = false;

    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        if (this.valveDisabled) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.toString() + " is DISABLED");
            }
        } else {
            try {
                request.getRequest().getSession(true);
                ContentPage page = request.getPage();
                String curPageId = page.getId();
                String prevPageId = (String)request.getSessionAttribute("PreviousPageId");
                if (prevPageId == null) {
                    request.setSessionAttribute("PreviousPageId", (Object)curPageId);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("No previous page Id found in session, setting it for the first time");
                    }
                } else if (prevPageId.equalsIgnoreCase(curPageId)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Previous page id is same as current page id, not clearing page state");
                    }
                } else {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Page Change encountered Current Page:" + curPageId + " Prev Page:" + prevPageId);
                    }
                    request.setSessionAttribute("PreviousPageId", (Object)curPageId);
                    request.setAttribute(REQUEST_CLEAR_PORTLETS_MODE_AND_WINDOWSTATE_KEY, (Object)Boolean.TRUE);
                }
            }
            catch (Exception e) {
                throw new PipelineException((Throwable)e);
            }
        }
        context.invokeNext(request);
    }

    public String toString() {
        return "PageHistoryValve";
    }

    public void setValveDisabled(boolean valveDisabled) {
        this.valveDisabled = valveDisabled;
    }

    public boolean isValveDisabled() {
        return this.valveDisabled;
    }
}

