/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.jetspeed.portlet.HeadElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadElementImpl
implements HeadElement {
    private static final long serialVersionUID = 1L;
    private String tagName;
    private Map<String, String> attributes;
    private String textContent;
    private Collection<HeadElement> childHeadElements;

    public HeadElementImpl() {
    }

    public HeadElementImpl(Element element) {
        this.tagName = element.getTagName();
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        } else {
            this.attributes.clear();
        }
        NamedNodeMap attrs = element.getAttributes();
        int length = attrs.getLength();
        for (int i = 0; i < length; ++i) {
            Attr attr = (Attr)attrs.item(i);
            this.attributes.put(attr.getName(), attr.getValue());
        }
        this.textContent = element.getTextContent();
        NodeList nodeList = element.getChildNodes();
        length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            if (this.childHeadElements == null) {
                this.childHeadElements = new ArrayList<HeadElement>();
            }
            this.childHeadElements.add(new HeadElementImpl((Element)node));
        }
    }

    public String getTagName() {
        return this.tagName;
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Map<String, String> getAttributeMap() {
        return this.attributes;
    }

    public String getTextContent() {
        return this.textContent;
    }

    public void setTextContent(String textContent) {
        this.textContent = textContent;
    }

    public boolean hasChildHeadElements() {
        return this.childHeadElements != null && !this.childHeadElements.isEmpty();
    }

    public Collection<HeadElement> getChildHeadElements() {
        if (this.childHeadElements != null) {
            return this.childHeadElements;
        }
        return Collections.emptyList();
    }
}

