/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.portlet.PortletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.container.state.NavigationalState;
import org.apache.jetspeed.om.portlet.GenericMetadata;
import org.apache.jetspeed.om.portlet.LocalizedField;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.request.JetspeedRequestContext;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletRequestContextImpl
implements PortletRequestContext {
    private static Boolean mergePortalParametersWithPortletParameters;
    private static Boolean mergePortalParametersBeforePortletParameters;
    private PortletContainer container;
    private HttpServletRequest containerRequest;
    private HttpServletResponse containerResponse;
    private HttpServletRequest servletRequest;
    private HttpServletResponse servletResponse;
    private PortletWindow window;
    private PortletConfig portletConfig;
    private ServletContext servletContext;
    private Cookie[] cookies;
    private JetspeedRequestContext requestContext;
    private Map<String, String[]> privateParameters;
    private Map<String, String[]> publicRenderParameters;

    public PortletRequestContextImpl(PortletContainer container, HttpServletRequest containerRequest, HttpServletResponse containerResponse, PortletWindow window) {
        this.container = container;
        this.containerRequest = containerRequest;
        this.containerResponse = containerResponse;
        this.window = window;
        this.requestContext = (JetspeedRequestContext)window.getRequestContext();
    }

    protected JetspeedRequestContext getRequestContext() {
        return this.requestContext;
    }

    private static boolean getMetaDataBooleanValue(GenericMetadata metaData, String fieldName, boolean defaultValue) {
        Collection fields;
        String value = null;
        if (metaData != null && (fields = metaData.getFields(fieldName)) != null && !fields.isEmpty()) {
            value = ((LocalizedField)fields.iterator().next()).getValue();
        }
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return defaultValue;
    }

    protected Map<String, String[]> getPrivateRenderParameterMap() {
        return Collections.emptyMap();
    }

    protected boolean isPublicRenderParameter(String name) {
        List publicRenderParameterNames = this.window.getPortletDefinition().getSupportedPublicRenderParameters();
        return publicRenderParameterNames.isEmpty() ? false : publicRenderParameterNames.contains(name);
    }

    public Map<String, String[]> getPrivateParameterMap() {
        if (this.privateParameters == null) {
            Map<String, String[]> privateParamMap;
            if (mergePortalParametersWithPortletParameters == null) {
                mergePortalParametersWithPortletParameters = new Boolean(Jetspeed.getContext().getConfiguration().getBoolean("merge.portal.parameters.with.portlet.parameters", false));
                mergePortalParametersBeforePortletParameters = new Boolean(Jetspeed.getContext().getConfiguration().getBoolean("merge.portal.parameters.before.portlet.parameters", false));
            }
            boolean mergeRequestParameters = false;
            boolean mergeRequestParametersBefore = false;
            this.privateParameters = new HashMap<String, String[]>();
            NavigationalState ns = this.requestContext.getPortalURL().getNavigationalState();
            mergeRequestParameters = ns.getPortletWindowOfAction() != null || ns.getPortletWindowOfResource() != null;
            Map paramMap = ns.getParameterMap(this.window);
            if (paramMap != null && !paramMap.isEmpty()) {
                this.privateParameters.putAll(paramMap);
            }
            if ((privateParamMap = this.getPrivateRenderParameterMap()) != null && !privateParamMap.isEmpty()) {
                if (this.privateParameters.isEmpty()) {
                    this.privateParameters.putAll(privateParamMap);
                } else {
                    for (Map.Entry<String, String[]> entry : privateParamMap.entrySet()) {
                        String[] values = this.privateParameters.get(entry.getKey());
                        if (values == null) {
                            this.privateParameters.put(entry.getKey(), entry.getValue());
                            continue;
                        }
                        String[] combined = new String[values.length + entry.getValue().length];
                        System.arraycopy(values, 0, combined, 0, values.length);
                        System.arraycopy(entry.getValue(), 0, combined, values.length, entry.getValue().length);
                        this.privateParameters.put(entry.getKey(), combined);
                    }
                }
            }
            PortletDefinition portletDef = this.window.getPortletDefinition();
            GenericMetadata metaData = portletDef.getMetadata();
            if (!mergeRequestParameters) {
                mergeRequestParameters = PortletRequestContextImpl.getMetaDataBooleanValue(metaData, "merge.portal.parameters.with.portlet.parameters", mergePortalParametersWithPortletParameters);
            }
            mergeRequestParametersBefore = PortletRequestContextImpl.getMetaDataBooleanValue(metaData, "merge.portal.parameters.before.portlet.parameters", mergePortalParametersBeforePortletParameters);
            if (mergeRequestParameters) {
                for (Map.Entry entry : ns.getRequestParameterMap().entrySet()) {
                    String[] navValues = this.privateParameters.get(entry.getKey());
                    if (navValues == null) {
                        this.privateParameters.put((String)entry.getKey(), (String[])entry.getValue());
                        continue;
                    }
                    String[] paramValues = (String[])entry.getValue();
                    String[] combined = new String[navValues.length + paramValues.length];
                    if (mergeRequestParametersBefore) {
                        System.arraycopy(paramValues, 0, combined, 0, paramValues.length);
                        System.arraycopy(navValues, 0, combined, paramValues.length, navValues.length);
                    } else {
                        System.arraycopy(navValues, 0, combined, 0, navValues.length);
                        System.arraycopy(paramValues, 0, combined, navValues.length, paramValues.length);
                    }
                    this.privateParameters.put((String)entry.getKey(), combined);
                }
            }
        }
        return this.privateParameters;
    }

    public PortletContainer getContainer() {
        return this.container;
    }

    public Cookie[] getCookies() {
        if (this.cookies == null) {
            this.cookies = this.servletRequest.getCookies();
            if (this.cookies == null) {
                this.cookies = new Cookie[0];
            }
        }
        return this.cookies.length > 0 ? (Cookie[])this.cookies.clone() : null;
    }

    public PortletConfig getPortletConfig() {
        return this.portletConfig;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public PortletWindow getPortletWindow() {
        return this.window;
    }

    public HttpServletRequest getContainerRequest() {
        return this.containerRequest;
    }

    public HttpServletResponse getContainerResponse() {
        return this.containerResponse;
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public HttpServletResponse getServletResponse() {
        return this.servletResponse;
    }

    public Locale getPreferredLocale() {
        Locale preferedLocale = this.requestContext.getLocale();
        return preferedLocale != null ? preferedLocale : this.containerRequest.getLocale();
    }

    public void init(PortletConfig portletConfig, ServletContext servletContext, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.portletConfig = portletConfig;
        this.servletContext = servletContext;
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
    }

    public Object getAttribute(String name) {
        Object value = this.servletRequest.getAttribute(name);
        return value != null ? value : this.window.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        HashSet names = new HashSet();
        Enumeration e = this.servletRequest.getAttributeNames();
        while (e.hasMoreElements()) {
            try {
                names.add(e.nextElement());
            }
            catch (NoSuchElementException nse) {}
        }
        for (String name : this.window.getAttributes().keySet()) {
            names.add(name);
        }
        return Collections.enumeration(names);
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.window.removeAttribute(name);
        } else {
            this.window.setAttribute(name, value);
        }
    }

    public Map<String, String[]> getProperties() {
        HashMap<String, String[]> properties = new HashMap<String, String[]>();
        Enumeration names = this.servletRequest.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            ArrayList values = new ArrayList();
            Enumeration headers = this.servletRequest.getHeaders(name);
            while (headers.hasMoreElements()) {
                values.add(headers.nextElement());
            }
            int size = values.size();
            if (size <= 0) continue;
            properties.put(name, values.toArray(new String[size]));
        }
        return properties;
    }

    public Map<String, String[]> getPublicParameterMap() {
        if (this.publicRenderParameters == null) {
            this.publicRenderParameters = this.requestContext.getPortalURL().getNavigationalState().getPublicRenderParameterMap(this.window);
        }
        if (this.publicRenderParameters == null) {
            this.publicRenderParameters = Collections.emptyMap();
        }
        return this.publicRenderParameters;
    }
}

