/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.impl;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.container.providers.ResourceURLProviderImpl;
import org.apache.jetspeed.request.JetspeedRequestContext;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletResponseContext;
import org.apache.pluto.container.ResourceURLProvider;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class PortletResponseContextImpl
implements PortletResponseContext {
    private PortletContainer container;
    private HttpServletRequest containerRequest;
    private HttpServletResponse containerResponse;
    private HttpServletRequest servletRequest;
    private HttpServletResponse servletResponse;
    private PortletWindow window;
    private boolean closed;
    private boolean released;
    private JetspeedRequestContext requestContext;

    public PortletResponseContextImpl(PortletContainer container, HttpServletRequest containerRequest, HttpServletResponse containerResponse, PortletWindow window) {
        this.container = container;
        this.containerRequest = containerRequest;
        this.containerResponse = containerResponse;
        this.window = window;
        this.requestContext = (JetspeedRequestContext)window.getRequestContext();
    }

    protected JetspeedRequestContext getRequestContext() {
        return this.requestContext;
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected boolean isReleased() {
        return this.released;
    }

    public void init(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
    }

    public void addProperty(Cookie cookie) {
        if (!this.isClosed()) {
            this.containerResponse.addCookie(cookie);
        }
    }

    public void addProperty(String key, Element element) {
    }

    public void addProperty(String key, String value) {
        if (!this.isClosed()) {
            this.containerResponse.addHeader(key, value);
        }
    }

    public Element createElement(String tagName) throws DOMException {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            return doc.createElement(tagName);
        }
        catch (ParserConfigurationException e) {
            throw new DOMException(0, "Initialization failure");
        }
    }

    public void close() {
        this.closed = true;
    }

    public PortletContainer getContainer() {
        return this.container;
    }

    public PortletWindow getPortletWindow() {
        return this.window;
    }

    public HttpServletRequest getContainerRequest() {
        return this.containerRequest;
    }

    public HttpServletResponse getContainerResponse() {
        return this.containerResponse;
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public HttpServletResponse getServletResponse() {
        return this.servletResponse;
    }

    public void release() {
        this.closed = true;
        this.released = true;
        this.container = null;
        this.servletRequest = null;
        this.servletResponse = null;
        this.requestContext = null;
        this.window = null;
    }

    public void setProperty(String key, String value) {
        if (!this.isClosed()) {
            this.containerResponse.setHeader(key, value);
        }
    }

    public ResourceURLProvider getResourceURLProvider() {
        if (!this.isReleased()) {
            return new ResourceURLProviderImpl(this.requestContext, this.window);
        }
        return null;
    }
}

