/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.providers;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.PortletSecurityException;
import javax.portlet.WindowState;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.container.state.MutableNavigationalState;
import org.apache.jetspeed.container.url.PortalURL;
import org.apache.pluto.container.PortletURLProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletURLProviderImpl
implements PortletURLProvider {
    private PortletWindow portletWindow;
    private PortletURLProvider.TYPE type;
    private boolean secure;
    private PortletMode portletMode;
    private WindowState windowState;
    private String cacheLevel;
    private String resourceID;
    private Map<String, String[]> renderParameters;
    private Map<String, String[]> publicRenderParameters;
    private Map<String, List<String>> properties;
    private String actionScopeID;
    private boolean actionScopeRendered;
    private PortalURL url;

    public PortletURLProviderImpl(PortalURL url, PortletWindow portletWindow, PortletURLProvider.TYPE type) {
        this.url = url;
        this.portletWindow = portletWindow;
        this.type = type;
    }

    public PortletURLProvider.TYPE getType() {
        return this.type;
    }

    public void setPortletMode(PortletMode mode) {
        this.portletMode = mode;
    }

    public PortletMode getPortletMode() {
        return this.portletMode;
    }

    public void setWindowState(WindowState state) {
        this.windowState = state;
    }

    public WindowState getWindowState() {
        return this.windowState;
    }

    public void setSecure(boolean secure) throws PortletSecurityException {
        this.secure = secure;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public Map<String, String[]> getRenderParameters() {
        if (this.renderParameters == null) {
            this.renderParameters = new HashMap<String, String[]>();
        }
        return this.renderParameters;
    }

    public Map<String, String[]> getPublicRenderParameters() {
        if (this.publicRenderParameters == null) {
            this.publicRenderParameters = new HashMap<String, String[]>();
        }
        return this.publicRenderParameters;
    }

    public String getCacheability() {
        return this.cacheLevel;
    }

    public void setCacheability(String cacheLevel) {
        this.cacheLevel = cacheLevel;
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public void setResourceID(String resourceID) {
        this.resourceID = resourceID;
    }

    public String getActionScopeID() {
        return this.actionScopeID;
    }

    public void setActionScopeID(String actionScopeID) {
        this.actionScopeID = actionScopeID;
    }

    public boolean isActionScopeRendered() {
        return this.actionScopeRendered;
    }

    public void setActionScopeRendered(boolean actionScopeRendered) {
        this.actionScopeRendered = actionScopeRendered;
    }

    public void apply() {
        this.apply(false);
    }

    public String toURL() {
        return this.apply(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String apply(boolean toURL) {
        MutableNavigationalState navState;
        PortalURL.URLType urlType;
        Map privateRenderParms = null;
        Map<String, String[]> renderParms = null;
        if (PortletURLProvider.TYPE.ACTION == this.type) {
            urlType = PortalURL.URLType.ACTION;
        } else if (PortletURLProvider.TYPE.RENDER == this.type) {
            urlType = PortalURL.URLType.RENDER;
        } else {
            urlType = PortalURL.URLType.RESOURCE;
            if (!"cacheLevelFull".equals(this.cacheLevel)) {
                privateRenderParms = this.url.getNavigationalState().getParameterMap(this.portletWindow);
            }
        }
        if (this.renderParameters != null) {
            if (this.publicRenderParameters == null) {
                renderParms = this.renderParameters;
            } else {
                renderParms = new HashMap<String, String[]>();
                for (Map.Entry<String, String[]> entry : this.renderParameters.entrySet()) {
                    if (this.publicRenderParameters.containsKey(entry.getKey())) continue;
                    renderParms.put(entry.getKey(), entry.getValue());
                }
            }
        }
        if (toURL) {
            return this.url.createPortletURL(this.portletWindow, renderParms, this.actionScopeID, this.actionScopeRendered, this.cacheLevel, this.resourceID, privateRenderParms, this.publicRenderParameters, this.portletMode, this.windowState, urlType, this.secure);
        }
        MutableNavigationalState mutableNavigationalState = navState = (MutableNavigationalState)this.url.getNavigationalState();
        synchronized (mutableNavigationalState) {
            navState.setTargetted(this.portletWindow);
            navState.setMode(this.portletWindow, this.portletMode);
            navState.setState(this.portletWindow, this.windowState);
            navState.setActionScopeId(this.portletWindow, this.actionScopeID);
            navState.setActionScopeRendered(this.portletWindow, this.actionScopeRendered);
            navState.setCacheLevel(this.portletWindow, this.cacheLevel);
            navState.setResourceId(this.portletWindow, this.resourceID);
            navState.setPrivateRenderParametersMap(this.portletWindow, privateRenderParms);
            if (this.publicRenderParameters == null) {
                navState.setParametersMap(this.portletWindow, renderParms);
            } else {
                if (this.renderParameters == null) {
                    navState.setParametersMap(this.portletWindow, null);
                } else {
                    for (String key : this.publicRenderParameters.keySet()) {
                        this.renderParameters.remove(key);
                    }
                    navState.setParametersMap(this.portletWindow, this.renderParameters);
                }
                navState.setPublicRenderParametersMap(this.portletWindow, this.publicRenderParameters);
            }
        }
        return null;
    }

    public void write(Writer out, boolean escapeXML) throws IOException {
        String result = this.toURL();
        if (escapeXML) {
            result = result.replaceAll("&", "&amp;");
            result = result.replaceAll("<", "&lt;");
            result = result.replaceAll(">", "&gt;");
            result = result.replaceAll("'", "&#039;");
            result = result.replaceAll("\"", "&#034;");
        }
        out.write(result);
    }

    public Map<String, List<String>> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, List<String>>();
        }
        return this.properties;
    }
}

