/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.services;

import java.io.IOException;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventPortlet;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import org.apache.jetspeed.container.FilterManager;
import org.apache.jetspeed.container.services.JetspeedFilterChain;
import org.apache.jetspeed.factory.PortletFactory;
import org.apache.jetspeed.factory.PortletFilterInstance;
import org.apache.jetspeed.om.portlet.Filter;
import org.apache.jetspeed.om.portlet.FilterMapping;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JetspeedFilterManager
implements FilterManager {
    private static final Logger log = LoggerFactory.getLogger(JetspeedFilterManager.class);
    private PortletFactory portletFactory;
    private JetspeedFilterChain filterchain;
    private PortletApplication portletApp;
    private String portletName;
    private String lifeCycle;

    public JetspeedFilterManager(PortletFactory portletFactory, PortletApplication portletApp, String portletName, String lifeCycle) {
        this.portletFactory = portletFactory;
        this.portletApp = portletApp;
        this.portletName = portletName;
        this.lifeCycle = lifeCycle;
        this.filterchain = new JetspeedFilterChain(lifeCycle);
        this.initFilterChain();
    }

    private void initFilterChain() {
        List filterMappingList = this.portletApp.getFilterMappings();
        if (filterMappingList != null) {
            for (FilterMapping filterMapping : filterMappingList) {
                if (!this.isFilter(filterMapping, this.portletName)) continue;
                List filterList = this.portletApp.getFilters();
                for (Filter filter : filterList) {
                    if (!filter.getFilterName().equals(filterMapping.getFilterName()) || !this.isLifeCycle(filter, this.lifeCycle)) continue;
                    try {
                        PortletFilterInstance filterInstance = this.portletFactory.getPortletFilterInstance(this.portletApp, filter.getFilterName());
                        this.filterchain.addFilterInstance(filterInstance);
                    }
                    catch (PortletException e) {
                        String message = "The portlet filter is not available: " + filter.getFilterClass();
                        log.error(message, (Throwable)e);
                    }
                }
            }
        }
    }

    public void processFilter(ActionRequest req, ActionResponse res, Portlet portlet, PortletContext portletContext) throws PortletException, IOException {
        this.filterchain.processFilter((PortletRequest)req, (PortletResponse)res, portlet, portletContext);
    }

    public void processFilter(RenderRequest req, RenderResponse res, Portlet portlet, PortletContext portletContext) throws PortletException, IOException {
        this.filterchain.processFilter((PortletRequest)req, (PortletResponse)res, portlet, portletContext);
    }

    public void processFilter(ResourceRequest req, ResourceResponse res, ResourceServingPortlet resourceServingPortlet, PortletContext portletContext) throws PortletException, IOException {
        this.filterchain.processFilter((PortletRequest)req, (PortletResponse)res, resourceServingPortlet, portletContext);
    }

    public void processFilter(EventRequest req, EventResponse res, EventPortlet eventPortlet, PortletContext portletContext) throws PortletException, IOException {
        this.filterchain.processFilter((PortletRequest)req, (PortletResponse)res, eventPortlet, portletContext);
    }

    private boolean isLifeCycle(Filter filter, String lifeCycle) {
        List lifeCyclesList = filter.getLifecycles();
        return lifeCyclesList.contains(lifeCycle);
    }

    private boolean isFilter(FilterMapping filterMapping, String portletName) {
        boolean isFilter = false;
        for (String filterPortletName : filterMapping.getPortletNames()) {
            if (filterPortletName.endsWith("*")) {
                if (filterPortletName.length() == 1) {
                    isFilter = true;
                    break;
                }
                if (!portletName.startsWith(filterPortletName.substring(0, filterPortletName.length() - 1))) continue;
                isFilter = true;
                break;
            }
            if (!filterPortletName.equals(portletName)) continue;
            isFilter = true;
            break;
        }
        return isFilter;
    }
}

