/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.session;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import org.apache.jetspeed.container.session.PortalSessionMonitor;
import org.apache.jetspeed.container.session.PortalSessionsManager;
import org.apache.jetspeed.services.JetspeedPortletServices;
import org.apache.jetspeed.services.PortletServices;

public class PortalSessionMonitorImpl
implements PortalSessionMonitor {
    private static final long serialVersionUID = 1239564779524373742L;
    private long sessionKey;
    private transient String sessionId;
    private transient HttpSession session;
    private boolean forceInvalidate;

    public PortalSessionMonitorImpl(long sessionKey) {
        this(sessionKey, true);
    }

    public PortalSessionMonitorImpl(long sessionKey, boolean forceInvalidate) {
        this.sessionKey = sessionKey;
        this.forceInvalidate = forceInvalidate;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public long getSessionKey() {
        return this.sessionKey;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public void invalidateSession() {
        HttpSession thisSession = this.session;
        if (thisSession != null) {
            this.session = null;
            if (this.forceInvalidate) {
                try {
                    thisSession.invalidate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void valueBound(HttpSessionBindingEvent event) {
        this.session = event.getSession();
        this.sessionId = this.session.getId();
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        if (this.session != null) {
            PortalSessionsManager manager = this.getManager();
            if (manager != null) {
                manager.portalSessionDestroyed((PortalSessionMonitor)this);
            }
            this.session = null;
        }
    }

    public void sessionDidActivate(HttpSessionEvent event) {
        this.session = event.getSession();
        this.sessionId = this.session.getId();
        PortalSessionsManager manager = this.getManager();
        if (manager != null) {
            manager.portalSessionDidActivate((PortalSessionMonitor)this);
        }
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        PortalSessionsManager manager = this.getManager();
        if (manager != null) {
            manager.portalSessionWillPassivate((PortalSessionMonitor)this);
        }
        this.session = null;
    }

    private PortalSessionsManager getManager() {
        PortletServices services = JetspeedPortletServices.getSingleton();
        if (services != null) {
            return (PortalSessionsManager)services.getService(PortalSessionsManager.SERVICE_NAME);
        }
        return null;
    }
}

