/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.state.impl;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.aggregator.PortletContent;
import org.apache.jetspeed.cache.ContentCacheKey;
import org.apache.jetspeed.cache.JetspeedContentCache;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.container.state.MutableNavigationalState;
import org.apache.jetspeed.container.state.impl.NavigationalStateCodec;
import org.apache.jetspeed.container.state.impl.PortletWindowBaseNavigationalState;
import org.apache.jetspeed.container.state.impl.PortletWindowExtendedNavigationalState;
import org.apache.jetspeed.container.state.impl.PortletWindowRequestNavigationalState;
import org.apache.jetspeed.container.state.impl.PortletWindowRequestNavigationalStates;
import org.apache.jetspeed.container.state.impl.SessionNavigationalState;
import org.apache.jetspeed.container.state.impl.ValuesAndWindowUsage;
import org.apache.jetspeed.container.url.PortalURL;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.request.RequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNavigationalState
implements MutableNavigationalState {
    private NavigationalStateCodec codec;
    private PortletWindowRequestNavigationalStates requestStates;
    protected JetspeedContentCache cache;
    protected JetspeedContentCache decorationCache;
    protected Map<String, String[]> requestParameterMap;

    public AbstractNavigationalState(NavigationalStateCodec codec, JetspeedContentCache cache) {
        this(codec, cache, null);
    }

    public AbstractNavigationalState(NavigationalStateCodec codec, JetspeedContentCache cache, JetspeedContentCache decorationCache) {
        this.codec = codec;
        this.cache = cache;
        this.decorationCache = decorationCache;
    }

    public void init(String encodedState, String characterEncoding) throws UnsupportedEncodingException {
        if (this.requestStates == null) {
            this.requestStates = this.codec.decode(encodedState, characterEncoding);
        }
    }

    private static boolean changedParameterValues(String[] requestValues, String[] sessionValues) {
        if (requestValues == null || sessionValues == null || requestValues.length != sessionValues.length) {
            return true;
        }
        for (int ix = 0; ix < requestValues.length; ++ix) {
            if (requestValues[ix].equals(sessionValues[ix])) continue;
            return true;
        }
        return false;
    }

    private static void removeFromCache(RequestContext context, String id, JetspeedContentCache cache) {
        if (cache != null) {
            ContentCacheKey cacheKey = cache.createCacheKey(context, id);
            if (cache.isKeyInCache((Object)cacheKey)) {
                cache.remove((Object)cacheKey);
            }
            cache.invalidate(context);
        }
    }

    protected boolean resolvePortletWindows(RequestContext requestContext) {
        boolean targetResolved = true;
        Iterator<Map.Entry<String, PortletWindowRequestNavigationalState>> entryIter = this.requestStates.getPortletWindowRequestNavigationalStates().entrySet().iterator();
        while (entryIter.hasNext()) {
            WindowState windowState;
            Map.Entry<String, PortletWindowRequestNavigationalState> entry = entryIter.next();
            PortletWindow window = requestContext.resolvePortletWindow(entry.getKey());
            if (window == null || !window.isValid()) {
                entryIter.remove();
                if (this.requestStates.getTargetWindowId() == null || !entry.getKey().equals(this.requestStates.getTargetWindowId())) continue;
                this.requestStates.setTargetWindowId(null);
                if (PortalURL.URLType.RENDER == this.requestStates.getURLType()) continue;
                targetResolved = false;
                continue;
            }
            entry.getValue().setPortletDefinition(window.getPortletDefinition());
            if (this.requestStates.getTargetWindowId() != null && entry.getKey().equals(this.requestStates.getTargetWindowId())) {
                if (PortalURL.URLType.ACTION == this.requestStates.getURLType()) {
                    this.requestStates.setActionWindow(window);
                } else if (PortalURL.URLType.RESOURCE == this.requestStates.getURLType()) {
                    this.requestStates.setResourceWindow(window);
                }
            }
            if ((windowState = entry.getValue().getWindowState()) == null || !windowState.equals((Object)WindowState.MAXIMIZED) && !windowState.equals((Object)JetspeedActions.SOLO_STATE)) continue;
            if (this.requestStates.getMaximizedWindow() == null) {
                this.requestStates.setMaximizedWindow(window);
                continue;
            }
            entry.getValue().setWindowState(null);
        }
        return targetResolved;
    }

    protected void resolveRequestParameterMap(RequestContext context) {
        HttpServletRequest request = context.getRequest();
        this.requestParameterMap = Collections.unmodifiableMap(new HashMap(request.getParameterMap()));
        String encoding = (String)request.getAttribute("org.apache.jetspeed.prefered.characterencoding");
        if (encoding != null && request.getAttribute("org.apache.jetspeed.parameterAlreadyDecoded") == null) {
            request.setAttribute("org.apache.jetspeed.parameterAlreadyDecoded", (Object)new Boolean(true));
            for (Map.Entry<String, String[]> entry : this.requestParameterMap.entrySet()) {
                String[] paramValues = entry.getValue();
                for (int i = 0; i < paramValues.length; ++i) {
                    try {
                        paramValues[i] = new String(paramValues[i].getBytes("ISO-8859-1"), encoding);
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected void resolvePublicParametersMap() {
        HashMap<QName, String[]> map = null;
        for (PortletWindowRequestNavigationalState state : this.requestStates.getPortletWindowRequestNavigationalStates().values()) {
            if (state.getPublicRenderParametersMap() == null) continue;
            state.resolvePublicRenderParametersMapping();
            Iterator<Map.Entry<String, String[]>> iter = state.getPublicRenderParametersMap().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String[]> entry = iter.next();
                QName qname = state.getPublicRenderParameterQNameByIdentifier(entry.getKey());
                if (qname != null) {
                    if (map == null) {
                        map = new HashMap<QName, String[]>();
                    }
                    map.put(qname, entry.getValue());
                    continue;
                }
                iter.remove();
            }
        }
        this.requestStates.setPublicRenderParametersMap(map);
    }

    protected void syncPublicRequestParameters(RequestContext context, boolean transientNavState) {
        HttpSession session;
        Map publicRenderParametersMap = null;
        if (!transientNavState && this.requestStates.getPublicRenderParametersMap() != null) {
            session = context.getRequest().getSession(true);
            publicRenderParametersMap = (Map)session.getAttribute("org.apache.jetspeed.prp");
            if (publicRenderParametersMap == null) {
                publicRenderParametersMap = Collections.synchronizedMap(new HashMap());
                session.setAttribute("org.apache.jetspeed.prp", publicRenderParametersMap);
            }
            Iterator<Map.Entry<QName, String[]>> iter = this.requestStates.getPublicRenderParametersMap().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Object, Object> entry = iter.next();
                ValuesAndWindowUsage vawu = (ValuesAndWindowUsage)publicRenderParametersMap.get(entry.getKey());
                if (vawu != null && !AbstractNavigationalState.changedParameterValues((String[])entry.getValue(), vawu.getValues())) continue;
                if (vawu != null && vawu.getWindowIds() != null) {
                    for (String windowId : vawu.getWindowIds()) {
                        AbstractNavigationalState.removeFromCache(context, windowId, this.cache);
                    }
                    for (String pageId : vawu.getPageIds()) {
                        AbstractNavigationalState.removeFromCache(context, pageId, this.decorationCache);
                    }
                }
                if (entry.getValue() == null) {
                    iter.remove();
                    publicRenderParametersMap.remove(entry.getKey());
                    continue;
                }
                if (vawu == null) {
                    publicRenderParametersMap.put(entry.getKey(), new ValuesAndWindowUsage((String[])entry.getValue()));
                    continue;
                }
                vawu.setValues((String[])entry.getValue());
            }
        }
        if (publicRenderParametersMap == null && (session = context.getRequest().getSession(false)) != null) {
            publicRenderParametersMap = (Map)session.getAttribute("org.apache.jetspeed.prp");
        }
        if (publicRenderParametersMap != null && !publicRenderParametersMap.isEmpty()) {
            Map<QName, String[]> map = this.requestStates.getPublicRenderParametersMap();
            if (map == null) {
                map = new HashMap<QName, String[]>();
            }
            for (Map.Entry<Object, Object> entry : publicRenderParametersMap.entrySet()) {
                if (map.containsKey(entry.getKey())) continue;
                map.put((QName)entry.getKey(), ((ValuesAndWindowUsage)entry.getValue()).getValues());
            }
            this.requestStates.setPublicRenderParametersMap(map);
        }
    }

    protected void resetRequestPortletWindowPublicRenderParameters() {
        for (PortletWindowRequestNavigationalState state : this.requestStates.getPortletWindowRequestNavigationalStates().values()) {
            state.setPublicRenderParametersMap(null);
        }
    }

    protected PortletWindowRequestNavigationalStates getPortletWindowRequestNavigationalStates() {
        return this.requestStates;
    }

    public WindowState getMappedState(String windowId) {
        WindowState windowState = null;
        PortletWindowRequestNavigationalState state = this.requestStates.getPortletWindowNavigationalState(windowId);
        if (state != null) {
            windowState = state.getWindowState();
        }
        return windowState != null ? windowState : WindowState.NORMAL;
    }

    public WindowState getState(String windowId) {
        return this.getMappedState(windowId);
    }

    public WindowState getState(PortletWindow window) {
        WindowState state = this.getMappedState(window.getId().toString());
        if (state != null && !JetspeedActions.getStandardWindowStates().contains(state)) {
            PortletApplication pa = window.getPortletDefinition().getApplication();
            state = pa.getCustomWindowState(state);
        }
        return state;
    }

    public WindowState getMappedState(PortletWindow window) {
        return this.getMappedState(window.getId().toString());
    }

    public void removeState(PortletWindow window) {
        this.requestStates.removePortletWindowNavigationalState(window.getId().toString());
    }

    public void setState(PortletWindow window, WindowState windowState) {
        if (window.isValid()) {
            String windowId;
            PortletWindowRequestNavigationalState state;
            if (windowState != null && !JetspeedActions.getStandardWindowStates().contains(windowState)) {
                PortletApplication pa = window.getPortletDefinition().getApplication();
                windowState = pa.getMappedWindowState(windowState);
            }
            if ((state = this.requestStates.getPortletWindowNavigationalState(windowId = window.getId().toString())) != null) {
                if (state.getWindowState() == null && windowState != null || windowState == null && state.getWindowState() != null || windowState != null && !state.getWindowState().equals((Object)windowState)) {
                    state.setWindowState(windowState);
                }
            } else {
                state = new PortletWindowRequestNavigationalState(windowId);
                state.setPortletDefinition(window.getPortletDefinition());
                state.resolveActionScopedRequestAttributes();
                this.requestStates.addPortletWindowNavigationalState(windowId, state);
                state.setWindowState(windowState);
            }
            if (windowState != null && windowState.equals((Object)WindowState.MAXIMIZED)) {
                this.requestStates.setMaximizedWindow(window);
            }
        }
    }

    public PortletMode getMappedMode(String windowId) {
        PortletMode portletMode = null;
        PortletWindowRequestNavigationalState state = this.requestStates.getPortletWindowNavigationalState(windowId);
        if (state != null) {
            portletMode = state.getPortletMode();
        }
        return portletMode != null ? portletMode : PortletMode.VIEW;
    }

    public PortletMode getMode(String windowId) {
        return this.getMappedMode(windowId);
    }

    public PortletMode getMode(PortletWindow window) {
        PortletMode mode = this.getMappedMode(window.getId().toString());
        if (mode != null && !JetspeedActions.getStandardPortletModes().contains(mode)) {
            PortletApplication pa = window.getPortletDefinition().getApplication();
            mode = pa.getCustomPortletMode(mode);
        }
        return mode;
    }

    public PortletMode getMappedMode(PortletWindow window) {
        return this.getMappedMode(window.getId().toString());
    }

    public void setMode(PortletWindow window, PortletMode portletMode) {
        if (window.isValid()) {
            String windowId;
            PortletWindowRequestNavigationalState state;
            if (portletMode != null && !JetspeedActions.getStandardPortletModes().contains(portletMode)) {
                PortletApplication pa = window.getPortletDefinition().getApplication();
                portletMode = pa.getMappedPortletMode(portletMode);
            }
            if ((state = this.requestStates.getPortletWindowNavigationalState(windowId = window.getId().toString())) != null) {
                if (state.getPortletMode() == null && portletMode != null || portletMode == null && state.getPortletMode() != null || portletMode != null && !state.getPortletMode().equals((Object)portletMode)) {
                    state.setPortletMode(portletMode);
                }
            } else {
                state = new PortletWindowRequestNavigationalState(windowId);
                state.setPortletDefinition(window.getPortletDefinition());
                state.resolveActionScopedRequestAttributes();
                this.requestStates.addPortletWindowNavigationalState(windowId, state);
                state.setPortletMode(portletMode);
            }
        }
    }

    public Map<String, String[]> getRequestParameterMap() {
        if (this.requestParameterMap == null) {
            this.requestParameterMap = Collections.emptyMap();
        }
        return this.requestParameterMap;
    }

    public Map<String, String[]> getParameterMap(PortletWindow window) {
        PortletWindowRequestNavigationalState state = this.requestStates.getPortletWindowNavigationalState(window.getId().toString());
        if (state != null && state.getParametersMap() != null) {
            return state.getParametersMap();
        }
        return null;
    }

    public void clearParameters(PortletWindow window) {
        Map<String, String[]> map;
        PortletWindowRequestNavigationalState state = this.requestStates.getPortletWindowNavigationalState(window.getId().toString());
        if (state != null && (map = state.getParametersMap()) != null) {
            map.clear();
            state.setClearParameters(true);
        }
    }

    public void setParametersMap(PortletWindow window, Map<String, String[]> parametersMap) {
        PortletWindowRequestNavigationalState state = this.requestStates.getPortletWindowNavigationalState(window.getId().toString());
        if (state != null) {
            state.setParametersMap(parametersMap);
        }
    }

    public boolean isActionScopedRequestAttributes(PortletWindow window) {
        PortletWindowRequestNavigationalState state = this.requestStates.getPortletWindowNavigationalState(window.getId().toString());
        return state != null ? state.isActionScopedRequestAttributes() : false;
    }

    public String getActionScopeId(PortletWindow window) {
        PortletWindowRequestNavigationalState state = this.requestStates.getPortletWindowNavigationalState(window.getId().toString());
        return state != null ? state.getActionScopeId() : null;
    }

    public void setActionScopeId(PortletWindow window, String actionScopeId) {
        PortletWindowRequestNavigationalState state = this.requestStates.getPortletWindowNavigationalState(window.getId().toString());
        if (state != null) {
            state.setActionScopeId(actionScopeId);
        }
    }

    public boolean isActionScopeRendered(PortletWindow window) {
        PortletWindowRequestNavigationalState state = this.requestStates.getPortletWindowNavigationalState(window.getId().toString());
        return state != null ? state.isActionScopeRendered() : false;
    }

    public void setActionScopeRendered(PortletWindow window, boolean actionScopeRendered) {
        PortletWindowRequestNavigationalState state = this.requestStates.getPortletWindowNavigationalState(window.getId().toString());
        if (state != null) {
            state.setActionScopeRendered(actionScopeRendered);
        }
    }

    public String getCacheLevel(PortletWindow window) {
        PortletWindowRequestNavigationalState state = this.requestStates.getPortletWindowNavigationalState(window.getId().toString());
        return state != null ? state.getCacheLevel() : null;
    }

    public void setCacheLevel(PortletWindow window, String cacheLevel) {
        PortletWindowRequestNavigationalState state = this.requestStates.getPortletWindowNavigationalState(window.getId().toString());
        if (state != null) {
            state.setCacheLevel(cacheLevel);
        }
    }

    public String getResourceID(PortletWindow window) {
        PortletWindowRequestNavigationalState state = this.requestStates.getPortletWindowNavigationalState(window.getId().toString());
        return state != null ? state.getResourceId() : null;
    }

    public void setResourceId(PortletWindow window, String resourceId) {
        PortletWindowRequestNavigationalState state = this.requestStates.getPortletWindowNavigationalState(window.getId().toString());
        if (state != null) {
            state.setResourceId(resourceId);
        }
    }

    public Map<String, String[]> getPrivateRenderParameterMap(PortletWindow window) {
        PortletWindowRequestNavigationalState state = this.requestStates.getPortletWindowNavigationalState(window.getId().toString());
        return state != null ? state.getPrivateRenderParametersMap() : null;
    }

    public void setPrivateRenderParametersMap(PortletWindow window, Map<String, String[]> privateRenderParametersMap) {
        PortletWindowRequestNavigationalState state = this.requestStates.getPortletWindowNavigationalState(window.getId().toString());
        if (state != null) {
            state.setPrivateRenderParametersMap(privateRenderParametersMap);
        }
    }

    public Map<String, String[]> getPublicRenderParameterMap(PortletWindow window) {
        PortletWindowRequestNavigationalState state = this.requestStates.getPortletWindowNavigationalState(window.getId().toString());
        if (state == null && this.requestStates.getPublicRenderParametersMap() != null && window.isValid() && window.getPortletDefinition().getSupportedPublicRenderParameters() != null) {
            state = new PortletWindowRequestNavigationalState(window.getWindowId());
            state.setPortletDefinition(window.getPortletDefinition());
            state.resolveActionScopedRequestAttributes();
            this.requestStates.addPortletWindowNavigationalState(window.getWindowId(), state);
        }
        if (state != null) {
            return this.requestStates.getPublicRenderParametersMap(window.getWindowId());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPublicRenderParametersMap(PortletWindow window, Map<String, String[]> publicRenderParametersMap) {
        PortletWindowRequestNavigationalState targetState;
        if (publicRenderParametersMap != null && (targetState = this.requestStates.getPortletWindowNavigationalState(window.getId().toString())) != null) {
            PortletWindowRequestNavigationalStates portletWindowRequestNavigationalStates = this.requestStates;
            synchronized (portletWindowRequestNavigationalStates) {
                HashMap<String, String[]> targets = new HashMap<String, String[]>();
                HashMap<QName, String[]> qtargets = new HashMap<QName, String[]>();
                Map<QName, String[]> rsPrpMap = this.requestStates.getPublicRenderParametersMap();
                if (rsPrpMap == null) {
                    rsPrpMap = new HashMap<QName, String[]>();
                }
                for (Map.Entry<String, String[]> entry : publicRenderParametersMap.entrySet()) {
                    QName qname = targetState.getPublicRenderParameterQNameByIdentifier(entry.getKey());
                    if (qname == null) continue;
                    qtargets.put(qname, entry.getValue());
                    targets.put(entry.getKey(), entry.getValue());
                    if (entry.getValue() == null) {
                        rsPrpMap.remove(qname);
                        continue;
                    }
                    rsPrpMap.put(qname, entry.getValue());
                }
                if (!rsPrpMap.isEmpty()) {
                    this.requestStates.setPublicRenderParametersMap(rsPrpMap);
                }
                targetState.setTargetPublicRenderParametersMap(targets);
                for (PortletWindowRequestNavigationalState state : this.requestStates.getPortletWindowRequestNavigationalStates().values()) {
                    if (state == targetState || state.getTargetPublicRenderParametersMap() == null) continue;
                    for (Map.Entry entry : qtargets.entrySet()) {
                        String identifier = state.getPublicRenderParameterIdentifierByQName((QName)entry.getKey());
                        if (identifier == null || !state.getTargetPublicRenderParametersMap().containsKey(identifier)) continue;
                        state.getTargetPublicRenderParametersMap().put(identifier, (String[])entry.getValue());
                    }
                }
            }
        }
    }

    public void setTargetted(PortletWindow window) {
        PortletWindowRequestNavigationalState state = this.requestStates.getPortletWindowNavigationalState(window.getId().toString());
        if (state != null) {
            state.setTargetted(true);
        }
    }

    public PortalURL.URLType getURLType() {
        return this.requestStates.getURLType();
    }

    public PortletWindow getMaximizedWindow() {
        return this.requestStates.getMaximizedWindow();
    }

    public PortletWindow getPortletWindowOfAction() {
        return this.requestStates.getActionWindow();
    }

    public PortletWindow getPortletWindowOfResource() {
        return this.requestStates.getResourceWindow();
    }

    public String encode(PortletWindow window, Map<String, String[]> parameters, String actionScopeId, boolean actionScopeRendered, String cacheLevel, String resourceId, Map<String, String[]> privateRenderParameters, Map<String, String[]> publicRenderParameters, PortletMode mode, WindowState state, boolean action) throws UnsupportedEncodingException {
        return this.encode(window, parameters, actionScopeId, actionScopeRendered, cacheLevel, resourceId, privateRenderParameters, publicRenderParameters, mode, state, action ? PortalURL.URLType.ACTION : PortalURL.URLType.RENDER);
    }

    public String encode(PortletWindow window, Map<String, String[]> parameters, String actionScopeId, boolean actionScopeRendered, String cacheLevel, String resourceId, Map<String, String[]> privateRenderParameters, Map<String, String[]> publicRenderParameters, PortletMode mode, WindowState state, PortalURL.URLType urlType) throws UnsupportedEncodingException {
        if (!window.isValid()) {
            throw new IllegalStateException("Cannot encode Navigational State for invalid window: " + window.getId());
        }
        if (mode != null || state != null) {
            PortletApplication pa = null;
            if (mode != null && !JetspeedActions.getStandardPortletModes().contains(mode)) {
                pa = window.getPortletDefinition().getApplication();
                mode = pa.getMappedPortletMode(mode);
            }
            if (state != null && !JetspeedActions.getStandardWindowStates().contains(state)) {
                if (pa == null) {
                    pa = window.getPortletDefinition().getApplication();
                }
                state = pa.getMappedWindowState(state);
            }
        }
        return this.codec.encode(this.requestStates, window, parameters, actionScopeId, actionScopeRendered, cacheLevel, resourceId, privateRenderParameters, publicRenderParameters, mode, state, urlType, this.isNavigationalParameterStateFull(), this.isRenderParameterStateFull());
    }

    public String encode(PortletWindow window, PortletMode mode, WindowState state) throws UnsupportedEncodingException {
        if (!window.isValid()) {
            throw new IllegalStateException("Cannot encode Navigational State for invalid window: " + window.getId());
        }
        String windowId = window.getWindowId();
        if (mode != null || state != null) {
            PortletApplication pa = window.getPortletDefinition().getApplication();
            if (mode != null && !JetspeedActions.getStandardPortletModes().contains(mode)) {
                mode = pa.getMappedPortletMode(mode);
            }
            if (state != null && !JetspeedActions.getStandardWindowStates().contains(state)) {
                state = pa.getMappedWindowState(state);
            }
        }
        String encodedState = null;
        Map<String, PortletWindowBaseNavigationalState> currentWindowStates = null;
        PortletWindowExtendedNavigationalState windowNavState = null;
        PortletMode targetMode = mode;
        WindowState targetState = state;
        if (this instanceof SessionNavigationalState && (currentWindowStates = ((SessionNavigationalState)this).getCurrentPageWindowStates()) != null && (windowNavState = (PortletWindowExtendedNavigationalState)currentWindowStates.get(windowId)) != null) {
            if (targetMode == null) {
                targetMode = windowNavState.getPortletMode();
            }
            if (targetState == null) {
                targetState = windowNavState.getWindowState();
            }
            encodedState = windowNavState.getDecoratorActionEncoding(targetMode, targetState);
        }
        if (encodedState == null) {
            encodedState = this.codec.encode(this.requestStates, window, mode, state, this.isNavigationalParameterStateFull(), this.isRenderParameterStateFull());
            if (currentWindowStates != null) {
                if (windowNavState == null) {
                    windowNavState = new PortletWindowExtendedNavigationalState();
                    windowNavState.setActionScopedRequestAttributes(this.requestStates.getPortletWindowNavigationalState(windowId).isActionScopedRequestAttributes());
                    currentWindowStates.put(windowId, windowNavState);
                }
                windowNavState.setDecoratorActionEncoding(targetMode, targetState, encodedState);
            }
        }
        return encodedState;
    }

    public String encode() throws UnsupportedEncodingException {
        return this.codec.encode(this.requestStates, this.isNavigationalParameterStateFull(), this.isRenderParameterStateFull());
    }

    public Iterator<String> getWindowIdIterator() {
        return this.requestStates.getWindowIdIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPortletContentCachedForPublicRenderParameters(RequestContext context, PortletContent content) {
        String windowId = content.getCacheKey().getWindowId();
        PortletWindowRequestNavigationalState state = this.requestStates.getPortletWindowNavigationalState(windowId);
        if (state != null && state.getPublicRenderParametersMap() != null && !state.getPublicRenderParametersMap().isEmpty()) {
            HttpSession session;
            HttpSession httpSession = session = context.getRequest().getSession(true);
            synchronized (httpSession) {
                String pageId = context.getPage().getId();
                Map publicRenderParametersMap = (Map)session.getAttribute("org.apache.jetspeed.prp");
                if (publicRenderParametersMap == null) {
                    publicRenderParametersMap = Collections.synchronizedMap(new HashMap());
                    session.setAttribute("org.apache.jetspeed.prp", publicRenderParametersMap);
                }
                for (String identifier : state.getPublicRenderParametersMap().keySet()) {
                    QName qname = state.getPublicRenderParameterQNameByIdentifier(identifier);
                    ValuesAndWindowUsage usage = (ValuesAndWindowUsage)publicRenderParametersMap.get(qname);
                    if (usage == null) continue;
                    usage.registerWindowUsage(pageId, windowId);
                }
            }
        }
    }
}

