/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.state.impl;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.commons.codec.binary.Base64;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.PortalContext;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.container.state.impl.NavigationalStateCodec;
import org.apache.jetspeed.container.state.impl.PortletWindowRequestNavigationalState;
import org.apache.jetspeed.container.state.impl.PortletWindowRequestNavigationalStates;
import org.apache.jetspeed.container.url.PortalURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JetspeedNavigationalStateCodec
implements NavigationalStateCodec {
    protected static final Logger log = LoggerFactory.getLogger(JetspeedNavigationalStateCodec.class);
    protected static final char PARAMETER_SEPARATOR = '|';
    protected static final char PARAMETER_ELEMENT_SEPARATOR = '=';
    protected static final char PARAMETER_SEPARATOR_ESCAPE = '\\';
    protected static final char RENDER_WINDOW_ID_KEY = 'a';
    protected static final char ACTION_WINDOW_ID_KEY = 'b';
    protected static final char MODE_KEY = 'c';
    protected static final char STATE_KEY = 'd';
    protected static final char PARAM_KEY = 'e';
    protected static final char CLEAR_PARAMS_KEY = 'f';
    protected static final char RESOURCE_WINDOW_ID_KEY = 'g';
    protected static final char CACHE_LEVEL_KEY = 'h';
    protected static final char RESOURCE_ID_KEY = 'i';
    protected static final char PRIVATE_RENDER_PARAM_KEY = 'j';
    protected static final char ACTION_SCOPE_ID_KEY = 'k';
    protected static final char PUBLIC_RENDER_PARAM_KEY = 'l';
    protected static final char RENDERED_ACTION_SCOPE_ID_KEY = 'm';
    protected static final char PORTLET_MANAGED_MODE_KEY = 'n';
    protected static final char[] URLTYPE_ID_KEYS = new char[]{'b', 'g', 'a'};
    protected static final String keytable = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    protected final PortletMode[] portletModes;
    protected final WindowState[] windowStates;

    public JetspeedNavigationalStateCodec(PortalContext portalContext) {
        ArrayList modesList = new ArrayList();
        modesList.addAll(JetspeedActions.getStandardPortletModes());
        modesList.addAll(JetspeedActions.getExtendedPortletModes());
        this.portletModes = modesList.toArray(new PortletMode[modesList.size()]);
        if (this.portletModes.length > keytable.length()) {
            throw new UnsupportedOperationException("Too many supported PortletModes found. Can only handle max: " + keytable.length());
        }
        ArrayList statesList = new ArrayList();
        statesList.addAll(JetspeedActions.getStandardWindowStates());
        statesList.addAll(JetspeedActions.getExtendedWindowStates());
        this.windowStates = statesList.toArray(new WindowState[statesList.size()]);
        if (this.windowStates.length > keytable.length()) {
            throw new UnsupportedOperationException("Too many supported WindowModes found. Can only handle max: " + keytable.length());
        }
    }

    @Override
    public PortletWindowRequestNavigationalStates decode(String parameters, String characterEncoding) throws UnsupportedEncodingException {
        PortletWindowRequestNavigationalStates states = new PortletWindowRequestNavigationalStates(characterEncoding);
        if (parameters != null && parameters.length() > 0) {
            String decodedParameters = this.decodeParameters(parameters, characterEncoding);
            int position = 0;
            int length = decodedParameters.length();
            StringBuffer buffer = new StringBuffer();
            PortletWindowRequestNavigationalState currentState = null;
            while ((position = this.decodeArgument(position, length, decodedParameters, buffer, '|')) != -1 && buffer.length() > 0) {
                String parameter = buffer.toString();
                currentState = this.decodeParameter(states, currentState, parameter);
            }
            if (log.isDebugEnabled()) {
                this.logDecode(states, buffer);
                if (buffer.length() > 0) {
                    buffer.append("]");
                    log.debug("navstate decoded=" + buffer.toString());
                }
            }
        }
        return states;
    }

    private void logDecode(PortletWindowRequestNavigationalStates states, StringBuffer buffer) {
        buffer.setLength(0);
        String targetWindowId = states.getTargetWindowId();
        Iterator<String> iter = states.getWindowIdIterator();
        while (iter.hasNext()) {
            if (buffer.length() == 0) {
                buffer.append("[[");
            } else {
                buffer.append(",[");
            }
            PortletWindowRequestNavigationalState currentState = states.getPortletWindowNavigationalState(iter.next());
            buffer.append("window:" + currentState.getWindowId());
            if (targetWindowId != null && currentState.getWindowId().equals(targetWindowId)) {
                buffer.append("," + states.getURLType() + ":true");
            }
            if (currentState.getPortletMode() != null) {
                buffer.append(",mode:" + currentState.getPortletMode());
            }
            if (currentState.getWindowState() != null) {
                buffer.append(",state:" + currentState.getWindowState());
            }
            if (currentState.getCacheLevel() != null) {
                buffer.append(",cache level:" + currentState.getCacheLevel());
            }
            if (currentState.getResourceId() != null) {
                buffer.append(",resource id:" + currentState.getResourceId());
            }
            if (currentState.isActionScopedRequestAttributes() && currentState.getActionScopeId() != null) {
                buffer.append(",action scope id:" + currentState.getActionScopeId());
                buffer.append(",action scope rendered:" + currentState.isActionScopeRendered());
            }
            if (!currentState.isClearParameters()) {
                if (currentState.getParametersMap() != null) {
                    this.logDecode("parameters", currentState.getParametersMap(), buffer);
                }
                if (currentState.getPrivateRenderParametersMap() != null) {
                    this.logDecode("private render parameters", currentState.getPrivateRenderParametersMap(), buffer);
                }
                if (currentState.getPublicRenderParametersMap() != null) {
                    this.logDecode("public render parameters", currentState.getPublicRenderParametersMap(), buffer);
                }
            }
            buffer.append("]");
        }
    }

    private void logDecode(String parameterNameMap, Map<String, String[]> parametersMap, StringBuffer buffer) {
        buffer.append(",");
        buffer.append(parameterNameMap);
        buffer.append(":[");
        boolean first = true;
        Iterator<String> parIter = parametersMap.keySet().iterator();
        while (parIter.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            String name = parIter.next();
            buffer.append(name + ":[");
            String[] values = parametersMap.get(name);
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(values[i]);
            }
            buffer.append("]");
        }
    }

    @Override
    public String encode(PortletWindowRequestNavigationalStates states, PortletWindow window, PortletMode portletMode, WindowState windowState, boolean navParamsStateFull, boolean renderParamsStateFull) throws UnsupportedEncodingException {
        String windowId = window.getWindowId();
        PortletWindowRequestNavigationalState currentState = states.getPortletWindowNavigationalState(windowId);
        if (currentState == null) {
            currentState = new PortletWindowRequestNavigationalState(windowId);
            currentState.setPortletDefinition(window.getPortletDefinition());
            currentState.resolveActionScopedRequestAttributes();
            states.addPortletWindowNavigationalState(windowId, currentState);
        }
        PortletWindowRequestNavigationalState targetState = new PortletWindowRequestNavigationalState(windowId);
        targetState.setPortletDefinition(window.getPortletDefinition());
        targetState.setPortletMode(portletMode != null ? portletMode : currentState.getPortletMode());
        targetState.setWindowState(windowState != null ? windowState : currentState.getWindowState());
        if (!renderParamsStateFull) {
            targetState.setParametersMap(currentState.getParametersMap());
            targetState.setPublicRenderParametersMap(currentState.getParametersMap());
            if (currentState.isActionScopedRequestAttributes()) {
                targetState.setActionScopeId(currentState.getActionScopeId());
                targetState.setActionScopeRendered(currentState.isActionScopeRendered());
            }
        }
        return this.encode(states, targetState, PortalURL.URLType.RENDER, navParamsStateFull, renderParamsStateFull);
    }

    @Override
    public String encode(PortletWindowRequestNavigationalStates states, PortletWindow window, Map<String, String[]> parameters, String actionScopeId, boolean actionScopeRendered, String cacheLevel, String resourceId, Map<String, String[]> privateRenderParameters, Map<String, String[]> publicRenderParameters, PortletMode portletMode, WindowState windowState, PortalURL.URLType urlType, boolean navParamsStateFull, boolean renderParamsStateFull) throws UnsupportedEncodingException {
        String windowId = window.getWindowId();
        PortletWindowRequestNavigationalState currentState = states.getPortletWindowNavigationalState(windowId);
        if (currentState == null) {
            currentState = new PortletWindowRequestNavigationalState(windowId);
            currentState.setPortletDefinition(window.getPortletDefinition());
            currentState.resolveActionScopedRequestAttributes();
            states.addPortletWindowNavigationalState(windowId, currentState);
        }
        PortletWindowRequestNavigationalState targetState = new PortletWindowRequestNavigationalState(windowId);
        targetState.setPortletDefinition(currentState.getPortletDefinition());
        targetState.setPortletMode(portletMode != null ? portletMode : currentState.getPortletMode());
        targetState.setWindowState(windowState != null ? windowState : currentState.getWindowState());
        targetState.setParametersMap(parameters);
        if (currentState.isActionScopedRequestAttributes()) {
            targetState.setActionScopedRequestAttributes(true);
            targetState.setActionScopeId(actionScopeId);
            targetState.setActionScopeRendered(actionScopeRendered);
        }
        targetState.setCacheLevel(cacheLevel);
        targetState.setResourceId(resourceId);
        targetState.setPrivateRenderParametersMap(privateRenderParameters);
        targetState.setTargetPublicRenderParametersMap(publicRenderParameters);
        if (renderParamsStateFull && parameters == null) {
            targetState.setClearParameters(true);
        }
        return this.encode(states, targetState, urlType, navParamsStateFull, renderParamsStateFull);
    }

    @Override
    public String encode(PortletWindowRequestNavigationalStates states, boolean navParamsStateFull, boolean renderParamsStateFull) throws UnsupportedEncodingException {
        return this.encode(states, null, PortalURL.URLType.RENDER, navParamsStateFull, renderParamsStateFull);
    }

    protected String encode(PortletWindowRequestNavigationalStates states, PortletWindowRequestNavigationalState targetState, PortalURL.URLType urlType, boolean navParamsStateFull, boolean renderParamsStateFull) throws UnsupportedEncodingException {
        String encodedState;
        String targetWindowId;
        StringBuffer buffer = new StringBuffer();
        boolean haveState = false;
        String string = targetWindowId = targetState != null ? targetState.getWindowId() : null;
        if (targetState != null && (encodedState = this.encodePortletWindowNavigationalState(targetState, urlType, targetState.getTargetPublicRenderParametersMap(), false, false)).length() > 0) {
            if (!haveState) {
                haveState = true;
            } else {
                buffer.append('|');
            }
            buffer.append(encodedState);
        }
        Iterator<String> iter = states.getWindowIdIterator();
        while (iter.hasNext()) {
            String encodedState2;
            String windowId = iter.next();
            PortletWindowRequestNavigationalState requestState = states.getPortletWindowNavigationalState(windowId);
            if (navParamsStateFull && renderParamsStateFull && !requestState.isTargetted() || targetWindowId != null && windowId.equals(targetWindowId)) continue;
            Map<String, String[]> publicRenderParametersMap = null;
            if (requestState.isTargetted()) {
                publicRenderParametersMap = requestState.getTargetPublicRenderParametersMap();
            }
            if ((encodedState2 = this.encodePortletWindowNavigationalState(requestState, PortalURL.URLType.RENDER, publicRenderParametersMap, navParamsStateFull, renderParamsStateFull)).length() <= 0) continue;
            if (!haveState) {
                haveState = true;
            } else {
                buffer.append('|');
            }
            buffer.append(encodedState2);
        }
        return haveState ? this.encodeParameters(buffer.toString(), states.getCharacterEncoding()) : null;
    }

    protected String encodePortletWindowNavigationalState(PortletWindowRequestNavigationalState state, PortalURL.URLType urlType, Map<String, String[]> publicRenderParametersMap, boolean navParamsStateFull, boolean renderParamsStateFull) {
        boolean encoded;
        String windowId = state.getWindowId();
        StringBuffer buffer = new StringBuffer();
        buffer.append(URLTYPE_ID_KEYS[urlType.ordinal()]);
        buffer.append(windowId);
        boolean bl = encoded = !PortalURL.URLType.RENDER.equals((Object)urlType);
        if (!navParamsStateFull || state.isTargetted() || PortalURL.URLType.ACTION.equals((Object)urlType)) {
            if (state.getPortletMode() != null) {
                buffer.append('|');
                boolean found = false;
                for (int i = 0; i < this.portletModes.length; ++i) {
                    if (!this.portletModes[i].equals((Object)state.getPortletMode())) continue;
                    buffer.append('c');
                    buffer.append(keytable.charAt(i));
                    found = true;
                    break;
                }
                if (!found) {
                    buffer.append('n');
                    buffer.append(state.getPortletMode().toString());
                }
                encoded = true;
            }
            if (state.getWindowState() != null) {
                buffer.append('|');
                buffer.append('d');
                buffer.append(this.encodeWindowState(state.getWindowState()));
                encoded = true;
            }
        }
        if (!renderParamsStateFull || state.isTargetted() || PortalURL.URLType.ACTION.equals((Object)urlType)) {
            if (state.getParametersMap() != null) {
                encoded = this.encodeParameterMap(encoded, 'e', false, state.getParametersMap(), buffer);
            }
            if (state.isActionScopedRequestAttributes() && state.getActionScopeId() != null) {
                encoded = true;
                buffer.append('|');
                if (state.isActionScopeRendered()) {
                    buffer.append('m');
                } else {
                    buffer.append('k');
                }
                buffer.append(this.encodeArgument(state.getActionScopeId(), '|'));
            }
        }
        if (PortalURL.URLType.RESOURCE.equals((Object)urlType)) {
            if (state.getCacheLevel() != null) {
                encoded = true;
                buffer.append('|');
                buffer.append('h');
                buffer.append(this.encodeArgument(state.getCacheLevel(), '|'));
            }
            if (state.getResourceId() != null) {
                encoded = true;
                buffer.append('|');
                buffer.append('i');
                buffer.append(this.encodeArgument(state.getResourceId(), '|'));
            }
            if (state.getPrivateRenderParametersMap() != null) {
                encoded = this.encodeParameterMap(encoded, 'j', false, state.getPrivateRenderParametersMap(), buffer);
            }
        }
        if (state.isClearParameters()) {
            buffer.append('|');
            buffer.append('f');
            encoded = true;
        }
        if ((!renderParamsStateFull || state.isTargetted() || PortalURL.URLType.ACTION.equals((Object)urlType)) && publicRenderParametersMap != null) {
            encoded = this.encodeParameterMap(encoded, 'l', true, publicRenderParametersMap, buffer);
        }
        return encoded ? buffer.toString() : "";
    }

    protected boolean encodeParameterMap(boolean encoded, char paramsKey, boolean allowNullValues, Map<String, String[]> params, StringBuffer buffer) {
        StringBuffer paramBuffer = new StringBuffer();
        for (Map.Entry<String, String[]> entry : params.entrySet()) {
            String parameterName = entry.getKey();
            String[] parameterValues = entry.getValue();
            if (parameterValues == null && !allowNullValues) continue;
            encoded = true;
            buffer.append('|');
            paramBuffer.setLength(0);
            paramBuffer.append(this.encodeArgument(parameterName, '='));
            paramBuffer.append('=');
            if (parameterValues != null) {
                paramBuffer.append(Integer.toHexString(parameterValues.length));
                for (int i = 0; i < parameterValues.length; ++i) {
                    paramBuffer.append('=');
                    paramBuffer.append(this.encodeArgument(parameterValues[i], '='));
                }
            } else {
                paramBuffer.append('0');
            }
            buffer.append(paramsKey);
            buffer.append(this.encodeArgument(paramBuffer.toString(), '|'));
        }
        return encoded;
    }

    protected PortletWindowRequestNavigationalState decodeParameter(PortletWindowRequestNavigationalStates states, PortletWindowRequestNavigationalState currentState, String parameter) {
        block29: {
            char parameterType;
            block28: {
                parameterType = parameter.charAt(0);
                PortalURL.URLType urlType = null;
                switch (parameterType) {
                    case 'a': {
                        urlType = PortalURL.URLType.RENDER;
                        break;
                    }
                    case 'b': {
                        urlType = PortalURL.URLType.ACTION;
                        break;
                    }
                    case 'g': {
                        urlType = PortalURL.URLType.RESOURCE;
                    }
                }
                if (urlType == null) break block28;
                String windowId = parameter.substring(1);
                currentState = states.getPortletWindowNavigationalState(windowId);
                if (currentState == null) {
                    states.setURLType(urlType);
                    currentState = new PortletWindowRequestNavigationalState(windowId);
                    states.addPortletWindowNavigationalState(windowId, currentState);
                    states.setTargetWindowId(windowId);
                }
                break block29;
            }
            if (currentState == null) break block29;
            block5 : switch (parameterType) {
                case 'c': {
                    PortletMode portletMode = this.decodePortletMode(parameter.charAt(1));
                    if (portletMode == null) break;
                    currentState.setPortletMode(portletMode);
                    break;
                }
                case 'n': {
                    currentState.setPortletMode(new PortletMode(parameter.substring(1)));
                    break;
                }
                case 'd': {
                    WindowState windowState = this.decodeWindowState(parameter.charAt(1));
                    if (windowState == null) break;
                    currentState.setWindowState(windowState);
                    break;
                }
                case 'e': 
                case 'j': 
                case 'l': {
                    String[] parameterName = new String[1];
                    String[][] parameterValues = new String[1][1];
                    if (!this.decodeParamsParameter(parameter, parameterName, parameterValues)) break;
                    switch (parameterType) {
                        case 'e': {
                            currentState.setParameters(parameterName[0], parameterValues[0]);
                            break;
                        }
                        case 'j': {
                            if (!PortalURL.URLType.RESOURCE.equals((Object)states.getURLType())) break;
                            currentState.setPrivateRenderParameters(parameterName[0], parameterValues[0]);
                            break;
                        }
                        case 'l': {
                            if (parameterValues[0] == null || parameterValues[0].length == 0) {
                                currentState.setPublicRenderParameters(parameterName[0], null);
                                break;
                            }
                            currentState.setPublicRenderParameters(parameterName[0], parameterValues[0]);
                        }
                    }
                    break;
                }
                case 'f': {
                    currentState.setClearParameters(true);
                    break;
                }
                case 'h': 
                case 'i': 
                case 'k': 
                case 'm': {
                    parameter = parameter.substring(1);
                    switch (parameterType) {
                        case 'h': {
                            if (PortalURL.URLType.RESOURCE.equals((Object)states.getURLType())) {
                                currentState.setCacheLevel(parameter);
                                break block5;
                            }
                            break block29;
                        }
                        case 'i': {
                            if (PortalURL.URLType.RESOURCE.equals((Object)states.getURLType())) {
                                currentState.setResourceId(parameter);
                                break block5;
                            }
                            break block29;
                        }
                        case 'k': {
                            currentState.setActionScopeId(parameter);
                            currentState.setActionScopeRendered(false);
                            break block5;
                        }
                        case 'm': {
                            currentState.setActionScopeId(parameter);
                            currentState.setActionScopeRendered(true);
                        }
                    }
                }
            }
        }
        return currentState;
    }

    protected boolean decodeParamsParameter(String parameter, String[] parameterName, String[][] parameterValues) {
        int position = 1;
        int length = parameter.length();
        StringBuffer buffer = new StringBuffer();
        int parameterValueCount = -1;
        int parameterValueIndex = -1;
        while ((position = this.decodeArgument(position, length, parameter, buffer, '=')) != -1) {
            if (parameterName[0] == null) {
                parameterName[0] = buffer.toString();
                parameterValueCount = -1;
                continue;
            }
            if (parameterValueCount == -1) {
                parameterValueCount = Integer.parseInt(buffer.toString(), 16);
                if (parameterValueCount < 0) {
                    return false;
                }
                if (parameterValueCount == 0) {
                    parameterValues[0] = null;
                    return true;
                }
                parameterValues[0] = new String[parameterValueCount];
                parameterValueIndex = 0;
                continue;
            }
            parameterValues[0][parameterValueIndex++] = buffer.toString();
            if (--parameterValueCount != 0) continue;
            return true;
        }
        return false;
    }

    protected PortletMode decodePortletMode(char mode) {
        PortletMode portletMode = null;
        int index = keytable.indexOf(mode);
        if (index > -1 && index < this.portletModes.length) {
            portletMode = this.portletModes[index];
        }
        return portletMode;
    }

    protected WindowState decodeWindowState(char state) {
        WindowState windowState = null;
        int index = keytable.indexOf(state);
        if (index > -1 && index < this.windowStates.length) {
            windowState = this.windowStates[index];
        }
        return windowState;
    }

    protected char encodeWindowState(WindowState windowState) {
        for (int i = 0; i < this.windowStates.length; ++i) {
            if (!this.windowStates[i].equals((Object)windowState)) continue;
            return keytable.charAt(i);
        }
        throw new IllegalArgumentException("Unsupported WindowState: " + windowState);
    }

    protected String decodeParameters(String value, String characterEncoding) throws UnsupportedEncodingException {
        value = value.replace('-', '/').replace('_', '=').replace('.', '+');
        if (characterEncoding != null) {
            return new String(Base64.decodeBase64((byte[])value.getBytes(characterEncoding)), characterEncoding);
        }
        return new String(Base64.decodeBase64((byte[])value.getBytes()));
    }

    protected String encodeParameters(String value, String characterEncoding) throws UnsupportedEncodingException {
        value = characterEncoding != null ? new String(Base64.encodeBase64((byte[])value.getBytes(characterEncoding))) : new String(Base64.encodeBase64((byte[])value.getBytes()));
        return value.replace('/', '-').replace('=', '_').replace('+', '.');
    }

    protected String encodeArgument(String argument, char terminator) {
        int length = argument.length();
        StringBuffer buffer = new StringBuffer(length);
        buffer.setLength(0);
        for (int i = 0; i < length; ++i) {
            char c = argument.charAt(i);
            if (c == terminator) {
                buffer.append('\\');
            }
            buffer.append(c);
            if (c != '\\') continue;
            buffer.append(c);
        }
        return buffer.toString();
    }

    protected int decodeArgument(int position, int maxLength, String arguments, StringBuffer buffer, char terminator) {
        buffer.setLength(0);
        if (position > maxLength) {
            return -1;
        }
        while (position < maxLength) {
            char c = arguments.charAt(position);
            if (c == terminator) {
                ++position;
                break;
            }
            if (c != '\\') {
                buffer.append(c);
            } else {
                if (++position >= maxLength) break;
                buffer.append(arguments.charAt(position));
            }
            ++position;
        }
        return position;
    }
}

