/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.state.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.jetspeed.cache.ContentCacheKey;
import org.apache.jetspeed.cache.JetspeedContentCache;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.container.state.impl.PortletWindowBaseNavigationalState;
import org.apache.jetspeed.container.state.impl.PortletWindowExtendedNavigationalState;
import org.apache.jetspeed.container.state.impl.PortletWindowRequestNavigationalState;
import org.apache.jetspeed.container.state.impl.PortletWindowRequestNavigationalStates;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.request.RequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletWindowSessionNavigationalStates
implements Serializable {
    private static final long serialVersionUID = -2891442112700830546L;
    private final boolean storeParameters;
    private Map<String, PageState> pageStates = new HashMap<String, PageState>();

    public PortletWindowSessionNavigationalStates(boolean storeParameters) {
        this.storeParameters = storeParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeAllPortletsToViewModeAndNormalWindowState(RequestContext context, ContentPage page, PortletWindowRequestNavigationalStates requestStates, JetspeedContentCache cache, JetspeedContentCache decorationCache) {
        PortletMode viewMode = PortletMode.VIEW;
        WindowState normalWindowState = WindowState.NORMAL;
        PageState pageState = null;
        Map<String, PageState> map = this.pageStates;
        synchronized (map) {
            pageState = this.pageStates.get(page.getId());
            if (pageState == null) {
                pageState = new PageState();
                this.pageStates.put(page.getId(), pageState);
            }
        }
        PortletWindowRequestNavigationalState requestState = null;
        PortletWindowBaseNavigationalState sessionState = null;
        if (null != pageState.maximizedWindowId) {
            pageState.windowStates.remove(pageState.maximizedWindowId);
            this.removeFromCache(context, pageState.maximizedWindowId, cache);
            this.removeFromCache(context, pageState.maximizedWindowId, decorationCache);
            pageState.maximizedWindowId = null;
        }
        Map<String, PortletWindowBaseNavigationalState> map2 = pageState.windowStates;
        synchronized (map2) {
            for (String windowId : pageState.windowStates.keySet()) {
                requestState = requestStates.getPortletWindowNavigationalState(windowId);
                sessionState = pageState.windowStates.get(windowId);
                if (requestState == null) {
                    requestState = new PortletWindowRequestNavigationalState(windowId);
                    requestState.setActionScopedRequestAttributes(sessionState.isActionScopedRequestAttributes());
                }
                requestState.setPortletMode(viewMode);
                requestState.setWindowState(normalWindowState);
                boolean changed = this.syncStates(false, requestStates, requestState, sessionState);
                if (!changed) continue;
                this.removeFromCache(context, windowId, cache);
                this.removeFromCache(context, page.getId(), decorationCache);
                if (!this.storeParameters) continue;
                ((PortletWindowExtendedNavigationalState)sessionState).resetDecoratorActionEncodings();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(RequestContext context, ContentPage page, PortletWindowRequestNavigationalStates requestStates, JetspeedContentCache cache, JetspeedContentCache decorationCache) {
        PageState pageState = null;
        Map<String, PageState> map = this.pageStates;
        synchronized (map) {
            pageState = this.pageStates.get(page.getId());
            if (pageState == null) {
                pageState = new PageState();
                this.pageStates.put(page.getId(), pageState);
            }
        }
        PortletWindowRequestNavigationalState requestState = null;
        PortletWindowBaseNavigationalState sessionState = null;
        if (pageState.maximizedWindowId != null) {
            String requestMaximizedWindowId = null;
            if (requestStates.getMaximizedWindow() != null) {
                requestMaximizedWindowId = requestStates.getMaximizedWindow().getId().toString();
            }
            if (requestMaximizedWindowId == null) {
                requestState = requestStates.getPortletWindowNavigationalState(pageState.maximizedWindowId);
                if (requestState != null) {
                    if (requestState.getWindowState() != null) {
                        pageState.maximizedWindowId = null;
                    } else {
                        requestStates.setMaximizedWindow(context.getPortletWindow(requestState.getWindowId()));
                    }
                } else {
                    PortletWindow maximizedWindow = context.resolvePortletWindow(pageState.maximizedWindowId);
                    if (maximizedWindow == null || !maximizedWindow.isValid()) {
                        pageState.windowStates.remove(pageState.maximizedWindowId);
                        pageState.maximizedWindowId = null;
                    } else {
                        requestStates.setMaximizedWindow(maximizedWindow);
                    }
                }
            } else if (!requestMaximizedWindowId.equals(pageState.maximizedWindowId)) {
                requestState = requestStates.getPortletWindowNavigationalState(pageState.maximizedWindowId);
                sessionState = pageState.windowStates.get(pageState.maximizedWindowId);
                if (requestState == null || requestState.getWindowState() == null) {
                    sessionState.setWindowState(null);
                }
            }
        }
        if (requestStates.getMaximizedWindow() != null) {
            pageState.maximizedWindowId = requestStates.getMaximizedWindow().getId().toString();
        }
        Iterator<String> iter = requestStates.getWindowIdIterator();
        String actionWindowId = requestStates.getActionWindow() != null ? requestStates.getActionWindow().getWindowId() : null;
        boolean actionRequestState = false;
        while (iter.hasNext()) {
            boolean changed;
            requestState = requestStates.getPortletWindowNavigationalState(iter.next());
            sessionState = pageState.windowStates.get(requestState.getWindowId());
            if (sessionState == null) {
                sessionState = this.storeParameters ? new PortletWindowExtendedNavigationalState() : new PortletWindowBaseNavigationalState();
                sessionState.setActionScopedRequestAttributes(requestState.isActionScopedRequestAttributes());
                pageState.windowStates.put(requestState.getWindowId(), sessionState);
            }
            if (!(changed = this.syncStates(actionRequestState = actionWindowId != null && actionWindowId.equals(requestState.getWindowId()), requestStates, requestState, sessionState))) continue;
            this.removeFromCache(context, requestState.getWindowId(), cache);
            this.removeFromCache(context, page.getId(), decorationCache);
            if (!this.storeParameters) continue;
            ((PortletWindowExtendedNavigationalState)sessionState).resetDecoratorActionEncodings();
        }
        Map<String, PortletWindowBaseNavigationalState> map2 = pageState.windowStates;
        synchronized (map2) {
            iter = pageState.windowStates.keySet().iterator();
            while (iter.hasNext()) {
                String windowId = iter.next();
                requestState = requestStates.getPortletWindowNavigationalState(windowId);
                if (requestState != null) continue;
                PortletWindow window = context.resolvePortletWindow(windowId);
                if (window != null) {
                    requestState = new PortletWindowRequestNavigationalState(windowId);
                    requestState.setPortletDefinition(window.getPortletDefinition());
                    sessionState = pageState.windowStates.get(windowId);
                    requestState.setActionScopedRequestAttributes(sessionState.isActionScopedRequestAttributes());
                    requestStates.addPortletWindowNavigationalState(windowId, requestState);
                    boolean changed = this.syncStates(false, requestStates, requestState, sessionState);
                    if (!changed) continue;
                    this.removeFromCache(context, windowId, cache);
                    this.removeFromCache(context, page.getId(), decorationCache);
                    if (!this.storeParameters) continue;
                    sessionState = pageState.windowStates.get(windowId);
                    ((PortletWindowExtendedNavigationalState)sessionState).resetDecoratorActionEncodings();
                    continue;
                }
                this.removeFromCache(context, windowId, cache);
                this.removeFromCache(context, page.getId(), decorationCache);
                iter.remove();
            }
        }
    }

    private boolean modeChanged(PortletMode req, PortletMode ses) {
        if (req == null) {
            return false;
        }
        if (ses == null) {
            return !req.equals((Object)PortletMode.VIEW);
        }
        return !req.equals((Object)ses);
    }

    private boolean stateChanged(WindowState req, WindowState ses) {
        if (req == null) {
            return false;
        }
        if (ses == null) {
            return !req.equals((Object)WindowState.NORMAL);
        }
        return !req.equals((Object)ses);
    }

    private boolean syncStates(boolean actionRequestState, PortletWindowRequestNavigationalStates requestStates, PortletWindowRequestNavigationalState requestState, PortletWindowBaseNavigationalState sessionState) {
        boolean changed = false;
        if (this.modeChanged(requestState.getPortletMode(), sessionState.getPortletMode()) || this.stateChanged(requestState.getWindowState(), sessionState.getWindowState())) {
            changed = true;
        }
        if (requestState.getPortletMode() != null) {
            if (requestState.getPortletMode().equals((Object)PortletMode.VIEW)) {
                sessionState.setPortletMode(null);
            } else {
                sessionState.setPortletMode(requestState.getPortletMode());
            }
        } else if (sessionState.getPortletMode() == null) {
            requestState.setPortletMode(PortletMode.VIEW);
        } else {
            requestState.setPortletMode(sessionState.getPortletMode());
        }
        if (requestState.getWindowState() != null) {
            if (requestState.getWindowState().equals((Object)WindowState.NORMAL)) {
                sessionState.setWindowState(null);
            } else {
                sessionState.setWindowState(requestState.getWindowState());
            }
        } else if (sessionState.getWindowState() == null) {
            requestState.setWindowState(WindowState.NORMAL);
        } else {
            requestState.setWindowState(sessionState.getWindowState());
        }
        if (requestState.isActionScopedRequestAttributes() != sessionState.isActionScopedRequestAttributes()) {
            changed = true;
            sessionState.setActionScopedRequestAttributes(requestState.isActionScopedRequestAttributes());
        }
        if (this.storeParameters) {
            PortletWindowExtendedNavigationalState extendedSessionState = (PortletWindowExtendedNavigationalState)sessionState;
            if (requestState.getParametersMap() != null) {
                if (actionRequestState) {
                    extendedSessionState.setParametersMap(null);
                } else if (this.changedParameters(requestState.getParametersMap(), extendedSessionState.getParametersMap())) {
                    changed = true;
                    extendedSessionState.setParametersMap(new HashMap<String, String[]>(requestState.getParametersMap()));
                }
            } else if (requestState.isClearParameters()) {
                extendedSessionState.setParametersMap(null);
            } else if (extendedSessionState.getParametersMap() != null) {
                requestState.setParametersMap(new HashMap<String, String[]>(extendedSessionState.getParametersMap()));
            }
            if (requestState.isActionScopedRequestAttributes()) {
                if (requestState.getActionScopeId() != null) {
                    if (this.changedActionScope(requestState.getActionScopeId(), extendedSessionState.getActionScopeId())) {
                        changed = true;
                    }
                    extendedSessionState.setActionScopeId(requestState.getActionScopeId());
                    extendedSessionState.setActionScopeRendered(requestState.isActionScopeRendered());
                } else if (requestState.isClearParameters()) {
                    extendedSessionState.setActionScopeId(null);
                    extendedSessionState.setActionScopeRendered(false);
                } else if (extendedSessionState.getActionScopeId() != null) {
                    requestState.setActionScopeId(extendedSessionState.getActionScopeId());
                    requestState.setActionScopeRendered(extendedSessionState.isActionScopeRendered());
                }
            } else {
                requestState.setActionScopeId(null);
                requestState.setActionScopeRendered(false);
                extendedSessionState.setActionScopeId(null);
                extendedSessionState.setActionScopeRendered(false);
            }
            if (requestState.isClearParameters()) {
                requestState.setClearParameters(false);
            }
        }
        return changed;
    }

    protected boolean changedParameters(Map<String, String[]> requestMap, Map<String, String[]> sessionMap) {
        if (requestMap == null || sessionMap == null) {
            return true;
        }
        if (requestMap.size() != sessionMap.size()) {
            return true;
        }
        for (Map.Entry<String, String[]> r : requestMap.entrySet()) {
            if (!this.changedParameterValues(r.getValue(), sessionMap.get(r.getKey()))) continue;
            return true;
        }
        return false;
    }

    protected boolean changedParameterValues(String[] requestValues, String[] sessionValues) {
        if (requestValues == null || sessionValues == null || requestValues.length != sessionValues.length) {
            return true;
        }
        for (int ix = 0; ix < requestValues.length; ++ix) {
            if (requestValues[ix].equals(sessionValues[ix])) continue;
            return true;
        }
        return false;
    }

    protected boolean changedActionScope(String requestActionScope, String sessionActionScope) {
        if (requestActionScope == null || sessionActionScope == null) {
            return true;
        }
        return !requestActionScope.equals(sessionActionScope);
    }

    protected void removeFromCache(RequestContext context, String id, JetspeedContentCache cache) {
        if (cache == null) {
            return;
        }
        ContentCacheKey cacheKey = cache.createCacheKey(context, id);
        if (cache.isKeyInCache((Object)cacheKey)) {
            cache.remove((Object)cacheKey);
        }
        cache.invalidate(context);
    }

    protected Map<String, PortletWindowBaseNavigationalState> getWindowStates(ContentPage page) {
        PageState pageState = this.pageStates.get(page.getId());
        return pageState != null ? pageState.windowStates : null;
    }

    static final class PageState
    implements Serializable {
        private static final long serialVersionUID = -2730733728229116932L;
        public Map<String, PortletWindowBaseNavigationalState> windowStates = Collections.synchronizedMap(new HashMap());
        public String maximizedWindowId;

        PageState() {
        }
    }
}

