/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.url.impl;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import org.apache.jetspeed.PortalContext;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.container.state.NavigationalState;
import org.apache.jetspeed.container.url.BasePortalURL;
import org.apache.jetspeed.container.url.PortalURL;
import org.apache.jetspeed.container.url.impl.BasePortalURLImpl;
import org.apache.jetspeed.util.ArgUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPortalURL
implements PortalURL {
    public static final String DEFAULT_NAV_STATE_PARAMETER = "_ns";
    protected static String navStateParameter;
    protected NavigationalState navState;
    protected BasePortalURL base = null;
    protected static Boolean relativeOnly;
    protected String contextPath;
    protected String basePath;
    protected String path;
    protected String encodedNavState;
    protected String secureBaseURL;
    protected String nonSecureBaseURL;
    protected String characterEncoding = "UTF-8";

    public AbstractPortalURL(NavigationalState navState, PortalContext portalContext, BasePortalURL base) {
        this(navState, portalContext);
        this.base = base;
    }

    public AbstractPortalURL(NavigationalState navState, PortalContext portalContext) {
        if (navStateParameter == null) {
            navStateParameter = portalContext.getConfigurationProperty("portalurl.navigationalstate.parameter.name", DEFAULT_NAV_STATE_PARAMETER);
        }
        this.navState = navState;
        if (relativeOnly == null) {
            relativeOnly = new Boolean(portalContext.getConfiguration().getBoolean("portalurl.relative.only", false));
        }
    }

    public AbstractPortalURL(String characterEncoding, NavigationalState navState, PortalContext portalContext) {
        this(navState, portalContext);
        this.characterEncoding = characterEncoding;
    }

    public AbstractPortalURL(HttpServletRequest request, String characterEncoding, NavigationalState navState, PortalContext portalContext) {
        this(characterEncoding, navState, portalContext);
        this.setRequest(request);
    }

    public boolean isRelativeOnly() {
        return relativeOnly;
    }

    public static String getNavigationalStateParameterName() {
        return navStateParameter;
    }

    public String createNavigationalEncoding(PortletWindow window, Map<String, String[]> parameters, PortletMode mode, WindowState state, boolean action) {
        return this.createNavigationalEncoding(window, parameters, null, false, null, null, null, null, mode, state, action ? PortalURL.URLType.ACTION : PortalURL.URLType.RENDER);
    }

    public String createNavigationalEncoding(PortletWindow window, Map<String, String[]> parameters, PortletMode mode, WindowState state, PortalURL.URLType urlType) {
        return this.createNavigationalEncoding(window, parameters, null, false, null, null, null, null, mode, state, urlType);
    }

    public String createNavigationalEncoding(PortletWindow window, Map<String, String[]> parameters, String actionScopeId, boolean actionScopeRendered, String cacheLevel, String resourceId, Map<String, String[]> privateRenderParameters, Map<String, String[]> publicRenderParameters, PortletMode mode, WindowState state, PortalURL.URLType urlType) {
        try {
            String ns = this.getNavigationalState().encode(window, parameters, actionScopeId, actionScopeRendered, cacheLevel, resourceId, privateRenderParameters, publicRenderParameters, mode, state, urlType);
            return AbstractPortalURL.getNavigationalStateParameterName() + ":" + ns;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String createNavigationalEncoding(PortletWindow window, PortletMode mode, WindowState state) {
        try {
            String ns = this.getNavigationalState().encode(window, mode, state);
            return AbstractPortalURL.getNavigationalStateParameterName() + ":" + ns;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    protected void decodeBaseURL(HttpServletRequest request) {
        if (this.base == null) {
            this.base = new BasePortalURLImpl();
            this.base.setServerScheme(request.getScheme());
            this.base.setServerName(request.getServerName());
            this.base.setServerPort(request.getServerPort());
            this.base.setSecure(request.isSecure());
        }
        if (relativeOnly.booleanValue()) {
            this.nonSecureBaseURL = "";
            this.secureBaseURL = "";
        } else {
            StringBuffer buffer = new StringBuffer("https");
            buffer.append("://").append(this.base.getServerName());
            if (this.base.getServerPort() != 443 && this.base.getServerPort() != 80) {
                buffer.append(":").append(this.base.getServerPort());
            }
            this.secureBaseURL = buffer.toString();
            buffer = new StringBuffer("http");
            buffer.append("://").append(this.base.getServerName());
            if (this.base.getServerPort() != 443 && this.base.getServerPort() != 80) {
                buffer.append(":").append(this.base.getServerPort());
            }
            this.nonSecureBaseURL = buffer.toString();
        }
    }

    protected void decodeBasePath(HttpServletRequest request) {
        String servletPath;
        this.contextPath = (String)request.getAttribute("org.apache.jetspeed.context");
        if (this.contextPath == null) {
            this.contextPath = request.getContextPath();
        }
        if (this.contextPath == null) {
            this.contextPath = "";
        }
        if ((servletPath = request.getServletPath()) == null) {
            servletPath = "";
        }
        this.basePath = this.contextPath + servletPath;
    }

    protected void setEncodedNavigationalState(String encodedNavigationalState) {
        this.encodedNavState = encodedNavigationalState;
        try {
            this.navState.init(this.encodedNavState, this.characterEncoding);
        }
        catch (UnsupportedEncodingException e) {
            IllegalStateException ise = new IllegalStateException("An unsupported encoding was defined for this NavigationalState.");
            ise.initCause(e);
            throw ise;
        }
    }

    protected void setPath(String path) {
        this.path = path;
    }

    public String getBaseURL() {
        return this.getBaseURL(this.base.isSecure());
    }

    public String getBaseURL(boolean secure) {
        return secure ? this.secureBaseURL : this.nonSecureBaseURL;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getPath() {
        return this.path;
    }

    public String getPageBasePath() {
        if (null == this.path || 1 == this.path.length() && '/' == this.path.charAt(0)) {
            return this.basePath;
        }
        if (-1 != this.path.indexOf(47)) {
            return this.basePath + this.path.substring(0, this.path.lastIndexOf(47));
        }
        return this.basePath + this.path;
    }

    public boolean isSecure() {
        return this.base.isSecure();
    }

    public NavigationalState getNavigationalState() {
        return this.navState;
    }

    public String createPortletURL(PortletWindow window, Map<String, String[]> parameters, PortletMode mode, WindowState state, boolean action, boolean secure) {
        return this.createPortletURL(window, parameters, null, false, null, null, null, null, mode, state, action ? PortalURL.URLType.ACTION : PortalURL.URLType.RENDER, secure);
    }

    public String createPortletURL(PortletWindow window, Map<String, String[]> parameters, PortletMode mode, WindowState state, PortalURL.URLType urlType, boolean secure) {
        return this.createPortletURL(window, parameters, null, false, null, null, null, null, mode, state, urlType, secure);
    }

    public String createPortletURL(PortletWindow window, Map<String, String[]> parameters, String actionScopeId, boolean actionScopeRendered, String cacheLevel, String resourceId, Map<String, String[]> privateRenderParameters, Map<String, String[]> publicRenderParameters, PortletMode mode, WindowState state, PortalURL.URLType urlType, boolean secure) {
        try {
            String ns = this.getNavigationalState().encode(window, parameters, actionScopeId, actionScopeRendered, cacheLevel, resourceId, privateRenderParameters, publicRenderParameters, mode, state, urlType);
            return this.createPortletURL(ns, secure);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String createPortletURL(PortletWindow window, PortletMode mode, WindowState state, boolean secure) {
        try {
            String ns = this.navState.encode(window, mode, state);
            return this.createPortletURL(ns, secure);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected abstract void decodePathAndNavigationalState(HttpServletRequest var1);

    protected abstract String createPortletURL(String var1, boolean var2);

    public void setRequest(HttpServletRequest request) {
        ArgUtil.assertNotNull(HttpServletRequest.class, (Object)request, (Object)this, (String)"setRequest");
        this.decodeBaseURL(request);
        this.decodeBasePath(request);
        this.decodePathAndNavigationalState(request);
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getPortalURL() {
        try {
            return this.createPortletURL(this.navState.encode(), this.isSecure());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean hasEncodedNavState() {
        return this.encodedNavState != null;
    }

    public boolean isPathInfoEncodingNavState() {
        return false;
    }
}

