/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.decoration;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import org.apache.jetspeed.cache.CacheElement;
import org.apache.jetspeed.cache.JetspeedCache;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.decoration.Decoration;
import org.apache.jetspeed.decoration.DecorationFactory;
import org.apache.jetspeed.decoration.LayoutDecoration;
import org.apache.jetspeed.decoration.LayoutDecorationImpl;
import org.apache.jetspeed.decoration.LayoutInfoImpl;
import org.apache.jetspeed.decoration.PageTheme;
import org.apache.jetspeed.decoration.PortletDecoration;
import org.apache.jetspeed.decoration.PortletDecorationImpl;
import org.apache.jetspeed.decoration.ResourceValidator;
import org.apache.jetspeed.decoration.Theme;
import org.apache.jetspeed.decoration.caches.SessionPathResolverCache;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.util.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ServletContextAware;

public class DecorationFactoryImpl
implements DecorationFactory,
ServletContextAware {
    private static final Logger log = LoggerFactory.getLogger(DecorationFactoryImpl.class);
    private final Path decorationsPath;
    private final Path portletDecorationsPath;
    private final Path layoutDecorationsPath;
    private final String portletDecorationsPathStr;
    private final String layoutDecorationsPathStr;
    private final ResourceValidator validator;
    private final PortletRegistry registry;
    private JetspeedCache decorationConfigurationCache;
    private ServletContext servletContext;
    private String defaultDesktopLayoutDecoration = null;
    private String defaultDesktopPortletDecoration = null;
    private String defaultLayoutDecoration = null;
    private String defaultPortletDecoration = null;
    private Set layoutDecorationsDir = Collections.EMPTY_SET;
    private Set portletDecorationsDir = Collections.EMPTY_SET;
    private Set desktopLayoutDecorationsDir = Collections.EMPTY_SET;
    private Set desktopPortletDecorationsDir = Collections.EMPTY_SET;
    private Set layoutDecorationsList = Collections.EMPTY_SET;
    private Set portletDecorationsList = Collections.EMPTY_SET;
    private Set desktopLayoutDecorationsList = Collections.EMPTY_SET;
    private Set desktopPortletDecorationsList = Collections.EMPTY_SET;
    private Map portletDecoratorProperties = new HashMap();
    private Map layoutDecoratorProperties = new HashMap();

    public DecorationFactoryImpl(String decorationsPath, ResourceValidator validator) {
        this(null, decorationsPath, validator, null, null, null);
    }

    public DecorationFactoryImpl(String decorationsPath, ResourceValidator validator, JetspeedCache decorationConfigurationCache) {
        this(null, decorationsPath, validator, decorationConfigurationCache, null, null);
    }

    public DecorationFactoryImpl(PortletRegistry registry, String decorationsPath, ResourceValidator validator, JetspeedCache decorationConfigurationCache, String defLayoutDecoration, String defPortletDecoration) {
        this.registry = registry;
        this.decorationsPath = new Path(decorationsPath);
        this.layoutDecorationsPath = this.getBasePath("layout");
        this.layoutDecorationsPathStr = this.layoutDecorationsPath.toString();
        this.portletDecorationsPath = this.getBasePath("portlet");
        this.portletDecorationsPathStr = this.portletDecorationsPath.toString();
        this.validator = validator;
        this.decorationConfigurationCache = decorationConfigurationCache;
        this.defaultLayoutDecoration = defLayoutDecoration;
        this.defaultPortletDecoration = defPortletDecoration;
    }

    public ResourceValidator getResourceValidator() {
        return this.validator;
    }

    protected JetspeedCache getDecorationConfigurationCache() {
        return this.decorationConfigurationCache;
    }

    public Theme getTheme(ContentPage page, RequestContext requestContext) {
        return new PageTheme(page, this, requestContext);
    }

    public Decoration getDecoration(ContentPage page, ContentFragment fragment, RequestContext requestContext) {
        String decorationName = this.getDefaultDecorationName(fragment, page);
        boolean isLayout = fragment.getType().equals("layout");
        Object decoration = isLayout ? this.getLayoutDecoration(decorationName, requestContext) : this.getPortletDecoration(decorationName, requestContext);
        if (this.isDesktopEnabled(requestContext) && (decoration == null || !decoration.supportsDesktop())) {
            String defaultDecoration = null;
            if (isLayout) {
                if (decoration == null || fragment.equals(page.getRootFragment())) {
                    defaultDecoration = this.getDefaultDesktopLayoutDecoration();
                    decoration = this.getLayoutDecoration(defaultDecoration, requestContext);
                }
            } else {
                defaultDecoration = this.getDefaultDesktopPortletDecoration();
                decoration = this.getPortletDecoration(defaultDecoration, requestContext);
            }
            if (decoration == null) {
                String errMsg = "Cannot locate default desktop " + fragment.getType() + " decoration " + (defaultDecoration == null ? "null" : "\"" + defaultDecoration + "\"") + " (decoration " + (defaultDecoration == null ? "null" : "\"" + decorationName + "\"") + " specified for page could either not be located or does not support desktop). No desktop compatible " + fragment.getType() + " decoration is available.";
                log.error(errMsg);
            }
        }
        return decoration;
    }

    public PortletDecoration getPortletDecoration(String name, RequestContext requestContext) {
        Path basePath = this.getPortletDecorationBasePath(name);
        Path baseClientPath = this.createClientPath(name, basePath, requestContext, "portlet");
        Properties configuration = this.getConfiguration(name, "portlet");
        SessionPathResolverCache sessionPathResolver = new SessionPathResolverCache(requestContext.getRequest().getSession());
        return new PortletDecorationImpl(configuration, this.validator, basePath, baseClientPath, sessionPathResolver);
    }

    public LayoutDecoration getLayoutDecoration(String name, RequestContext requestContext) {
        Path basePath = this.getLayoutDecorationBasePath(name);
        Path baseClientPath = this.createClientPath(name, basePath, requestContext, "layout");
        Properties configuration = this.getConfiguration(name, "layout");
        SessionPathResolverCache sessionPathResolver = new SessionPathResolverCache(requestContext.getRequest().getSession());
        return new LayoutDecorationImpl(configuration, this.validator, basePath, baseClientPath, sessionPathResolver);
    }

    public boolean isDesktopEnabled(RequestContext requestContext) {
        Boolean desktopEnabled = (Boolean)requestContext.getAttribute("desktop.enabled");
        return desktopEnabled != null && desktopEnabled != false;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected Properties getCachedConfiguration(String name, String type) {
        if (this.decorationConfigurationCache == null) {
            if (type.equals("portlet")) {
                return (Properties)this.portletDecoratorProperties.get(name);
            }
            return (Properties)this.layoutDecoratorProperties.get(name);
        }
        CacheElement cachedElement = this.decorationConfigurationCache.get((Object)this.getCachedConfigurationKey(type, name));
        if (cachedElement != null) {
            return (Properties)cachedElement.getContent();
        }
        return null;
    }

    protected void setCachedConfiguration(String name, String type, Properties props) {
        if (this.decorationConfigurationCache == null) {
            if (type.equals("portlet")) {
                this.portletDecoratorProperties.put(name, props);
            } else {
                this.layoutDecoratorProperties.put(name, props);
            }
        } else {
            CacheElement cachedElement = this.decorationConfigurationCache.createElement((Object)this.getCachedConfigurationKey(type, name), (Object)props);
            cachedElement.setTimeToIdleSeconds(this.decorationConfigurationCache.getTimeToIdleSeconds());
            cachedElement.setTimeToLiveSeconds(this.decorationConfigurationCache.getTimeToLiveSeconds());
            this.decorationConfigurationCache.put(cachedElement);
        }
    }

    protected String getCachedConfigurationKey(String type, String name) {
        return type + "." + name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Properties getConfiguration(String name, String type) {
        Properties props;
        block40: {
            InputStream is;
            block37: {
                block36: {
                    block39: {
                        block34: {
                            block33: {
                                props = this.getCachedConfiguration(name, type);
                                if (props != null) {
                                    return props;
                                }
                                props = new Properties();
                                is = null;
                                is = this.servletContext.getResourceAsStream(this.decorationsPath + "/" + type + "/" + name + "/" + "decorator.properties");
                                if (is != null) {
                                    props.load(is);
                                    break block33;
                                }
                                log.warn("Could not locate the decorator.properties configuration file for decoration \"" + name + "\".  This decoration may not exist.");
                                props.setProperty("id", name);
                                props.setProperty("name", name);
                            }
                            Object var7_5 = null;
                            if (is == null) break block34;
                            try {
                                is.close();
                            }
                            catch (IOException e2) {
                                log.warn("Failed to close decoration configuration.", (Throwable)e2);
                            }
                        }
                        String decorationIdPropVal = props.getProperty("id");
                        String decorationNamePropVal = props.getProperty("name");
                        if (decorationIdPropVal == null) {
                            decorationIdPropVal = decorationNamePropVal != null ? decorationNamePropVal : name;
                            props.setProperty("id", decorationIdPropVal);
                        }
                        if (decorationNamePropVal == null) {
                            props.setProperty("name", decorationIdPropVal);
                        }
                        break block39;
                        {
                            catch (Throwable e) {
                                log.warn("Failed to load the decorator.properties configuration file for decoration \"" + name + "\".", e);
                                props.setProperty("id", name);
                                props.setProperty("name", name);
                                Object var7_6 = null;
                                if (is != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (IOException e2) {
                                        log.warn("Failed to close decoration configuration.", (Throwable)e2);
                                    }
                                }
                                decorationIdPropVal = props.getProperty("id");
                                decorationNamePropVal = props.getProperty("name");
                                if (decorationIdPropVal == null) {
                                    decorationIdPropVal = decorationNamePropVal != null ? decorationNamePropVal : name;
                                    props.setProperty("id", decorationIdPropVal);
                                }
                                if (decorationNamePropVal == null) {
                                    props.setProperty("name", decorationIdPropVal);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var7_7 = null;
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e2) {
                                    log.warn("Failed to close decoration configuration.", (Throwable)e2);
                                }
                            }
                            decorationIdPropVal = props.getProperty("id");
                            decorationNamePropVal = props.getProperty("name");
                            if (decorationIdPropVal == null) {
                                decorationIdPropVal = decorationNamePropVal != null ? decorationNamePropVal : name;
                                props.setProperty("id", decorationIdPropVal);
                            }
                            if (decorationNamePropVal == null) {
                                props.setProperty("name", decorationIdPropVal);
                            }
                            throw throwable;
                        }
                    }
                    is = this.servletContext.getResourceAsStream(this.decorationsPath + "/" + type + "/" + name + "/" + "decoratordesktop.properties");
                    if (is != null) {
                        props.load(is);
                        if (props.getProperty("desktop.supported") == null) {
                            props.setProperty("desktop.supported", "true");
                        }
                        break block36;
                    }
                    log.debug("Could not locate the decoratordesktop.properties configuration file for decoration \"" + name + "\".  This decoration may not exist.");
                }
                Object var11_17 = null;
                if (is == null) break block37;
                try {
                    is.close();
                }
                catch (IOException e3) {
                    log.warn("Failed to close decoration desktop configuration.", (Throwable)e3);
                }
            }
            if (props.getProperty("desktop.supported") == null) {
                props.setProperty("desktop.supported", "false");
            }
            break block40;
            {
                catch (Throwable e) {
                    log.warn("Failed to load the decoratordesktop.properties configuration file for decoration \"" + name + "\".", e);
                    Object var11_18 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e3) {
                            log.warn("Failed to close decoration desktop configuration.", (Throwable)e3);
                        }
                    }
                    if (props.getProperty("desktop.supported") == null) {
                        props.setProperty("desktop.supported", "false");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_19 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e3) {
                        log.warn("Failed to close decoration desktop configuration.", (Throwable)e3);
                    }
                }
                if (props.getProperty("desktop.supported") == null) {
                    props.setProperty("desktop.supported", "false");
                }
                throw throwable;
            }
        }
        this.setCachedConfiguration(name, type, props);
        return props;
    }

    protected Path createClientPath(String name, RequestContext requestContext, String decorationType) {
        return this.createClientPath(name, null, requestContext, decorationType);
    }

    private Path createClientPath(String name, Path basePath, RequestContext requestContext, String decorationType) {
        if (basePath == null) {
            basePath = this.getBasePath(name, decorationType);
        }
        String mediaType = requestContext.getMediaType();
        Locale locale = requestContext.getLocale();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        basePath = basePath.addSegment(mediaType).addSegment(language);
        if (country != null) {
            basePath = basePath.addSegment(country);
        }
        if (variant != null) {
            basePath = basePath.addSegment(variant);
        }
        return basePath;
    }

    protected String getDefaultDecorationName(ContentFragment fragment, ContentPage page) {
        String decoration = fragment.getDecorator();
        if (decoration == null) {
            if (fragment.getType().equals("layout")) {
                if (fragment.equals(page.getRootFragment())) {
                    decoration = page.getEffectiveDefaultDecorator("layout");
                    if (decoration == null) {
                        decoration = this.defaultLayoutDecoration;
                    }
                } else {
                    decoration = "clear";
                }
            } else {
                decoration = page.getEffectiveDefaultDecorator("portlet");
                if (decoration == null) {
                    decoration = this.defaultPortletDecoration;
                }
            }
        }
        return decoration;
    }

    public void clearCache(RequestContext requestContext) {
        new SessionPathResolverCache(requestContext.getRequest().getSession()).clear();
    }

    protected Path getBasePath(String decorationType) {
        return this.decorationsPath.addSegment(decorationType);
    }

    protected Path getBasePath(String name, String decorationType) {
        return this.decorationsPath.addSegment(decorationType).addSegment(name);
    }

    protected Path getLayoutDecorationBasePath(String name) {
        return this.layoutDecorationsPath.addSegment(name);
    }

    protected Path getPortletDecorationBasePath(String name) {
        return this.portletDecorationsPath.addSegment(name);
    }

    public String getLayoutDecorationsBasePath() {
        return this.layoutDecorationsPathStr;
    }

    public String getPortletDecorationsBasePath() {
        return this.portletDecorationsPathStr;
    }

    public Set getPageDecorations(RequestContext request) {
        Set decorations = this.servletContext.getResourcePaths(this.decorationsPath.toString() + "/layout");
        if (!((Object)this.layoutDecorationsDir).equals(decorations)) {
            this.layoutDecorationsList = this.getListing(decorations, "decorator.properties");
            this.layoutDecorationsDir = decorations;
        }
        return this.layoutDecorationsList;
    }

    public Set getDesktopPageDecorations(RequestContext request) {
        Set decorations = this.servletContext.getResourcePaths(this.decorationsPath.toString() + "/layout");
        if (!((Object)this.desktopLayoutDecorationsDir).equals(decorations)) {
            this.desktopLayoutDecorationsList = this.getListing(decorations, "decoratordesktop.properties");
            this.desktopLayoutDecorationsDir = decorations;
        }
        return this.desktopLayoutDecorationsList;
    }

    public Set getPortletDecorations(RequestContext request) {
        Set decorations = this.servletContext.getResourcePaths(this.decorationsPath.toString() + "/portlet");
        if (!((Object)this.portletDecorationsDir).equals(decorations)) {
            this.portletDecorationsList = this.getListing(decorations, "decorator.properties");
            this.portletDecorationsDir = decorations;
        }
        return this.portletDecorationsList;
    }

    public Set getDesktopPortletDecorations(RequestContext request) {
        Set decorations = this.servletContext.getResourcePaths(this.decorationsPath.toString() + "/portlet");
        if (!((Object)this.desktopPortletDecorationsDir).equals(decorations)) {
            this.desktopPortletDecorationsList = this.getListing(decorations, "decoratordesktop.properties");
            this.desktopPortletDecorationsDir = decorations;
        }
        return this.desktopPortletDecorationsList;
    }

    public List getLayouts(RequestContext request) {
        LinkedList<LayoutInfoImpl> list = new LinkedList<LayoutInfoImpl>();
        for (PortletDefinition portlet : this.registry.getAllPortletDefinitions()) {
            PortletApplication app = portlet.getApplication();
            String appName = app.getName();
            if (appName == null || !appName.equals("jetspeed-layouts")) continue;
            String uniqueName = appName + "::" + portlet.getPortletName();
            list.add(new LayoutInfoImpl(uniqueName, portlet.getDisplayNameText(request.getLocale()), portlet.getDescriptionText(request.getLocale())));
        }
        return list;
    }

    protected Set getListing(Set rawList, String propsFile) {
        Iterator itr = rawList.iterator();
        HashSet<String> filteredList = new HashSet<String>();
        while (itr.hasNext()) {
            Path path = new Path((String)itr.next());
            if (path.getFileName() != null || !this.validator.resourceExists(path.toString() + propsFile)) continue;
            int offset = path.length() - 1;
            filteredList.add(path.getSegment(offset));
        }
        TreeSet<String> decoraters = new TreeSet<String>();
        decoraters.addAll(filteredList);
        return decoraters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultDesktopLayoutDecoration() {
        DecorationFactoryImpl decorationFactoryImpl = this;
        synchronized (decorationFactoryImpl) {
            return this.defaultDesktopLayoutDecoration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultDesktopLayoutDecoration(String newOne) {
        DecorationFactoryImpl decorationFactoryImpl = this;
        synchronized (decorationFactoryImpl) {
            this.defaultDesktopLayoutDecoration = newOne;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultDesktopPortletDecoration() {
        DecorationFactoryImpl decorationFactoryImpl = this;
        synchronized (decorationFactoryImpl) {
            return this.defaultDesktopPortletDecoration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultDesktopPortletDecoration(String newOne) {
        DecorationFactoryImpl decorationFactoryImpl = this;
        synchronized (decorationFactoryImpl) {
            this.defaultDesktopPortletDecoration = newOne;
        }
    }

    public String getDefaultPortletDecoration() {
        return this.defaultPortletDecoration;
    }

    public String getDefaultLayoutDecoration() {
        return this.defaultLayoutDecoration;
    }
}

