/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.decoration;

import java.io.Serializable;
import java.util.HashMap;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.decoration.PageEditAccess;
import org.apache.jetspeed.om.page.ContentPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageActionAccess
implements PageEditAccess,
Serializable {
    protected static final Logger log = LoggerFactory.getLogger(PageActionAccess.class);
    private boolean anonymous;
    private boolean editAllowed;
    private boolean editing;
    private HashMap fragmentActionAccess;

    public PageActionAccess(boolean anonymous, ContentPage page) {
        this.anonymous = anonymous;
        this.editAllowed = this.checkEditPage(page);
        this.fragmentActionAccess = new HashMap();
    }

    public void checkReset(boolean anonymous, ContentPage page) {
        if (this.anonymous != anonymous) {
            this.anonymous = anonymous;
            this.editAllowed = this.checkEditPage(page);
            this.fragmentActionAccess.clear();
            this.editing = false;
        }
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public boolean isEditAllowed() {
        return this.editAllowed;
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setEditing(boolean editing) {
        if (editing && !this.editAllowed) {
            throw new SecurityException();
        }
        this.editing = editing;
    }

    public boolean checkPortletMode(String fragmentId, String portletName, PortletMode mode) {
        return this.checkActionAccess(fragmentId, portletName, mode.toString());
    }

    public boolean checkWindowState(String fragmentId, String portletName, WindowState state) {
        return this.checkActionAccess(fragmentId, portletName, state.toString());
    }

    protected synchronized boolean checkActionAccess(String fragmentId, String portletName, String action) {
        try {
            int actionIndex = JetspeedActions.getContainerActionMask((String)action);
            ActionAccess actionAccess = (ActionAccess)this.fragmentActionAccess.get(fragmentId);
            if (actionAccess == null) {
                actionAccess = new ActionAccess();
                this.fragmentActionAccess.put(fragmentId, actionAccess);
            }
            if ((actionAccess.checkedFlags & actionIndex) != actionIndex) {
                boolean access = true;
                if (access) {
                    actionAccess.actionFlags |= actionIndex;
                }
                actionAccess.checkedFlags |= actionIndex;
            }
            return (actionAccess.actionFlags & actionIndex) == actionIndex;
        }
        catch (IndexOutOfBoundsException e) {
            log.error("Unknown action: " + action, (Throwable)e);
            return false;
        }
    }

    protected boolean checkEditPage(ContentPage page) {
        boolean allowed = false;
        try {
            page.checkAccess(JetspeedActions.EDIT);
            allowed = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return allowed;
    }

    private static final class ActionAccess
    implements Serializable {
        int checkedFlags;
        int actionFlags;

        private ActionAccess() {
        }
    }
}

