/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.deployment.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.deployment.DeploymentEvent;
import org.apache.jetspeed.deployment.DeploymentEventListener;
import org.apache.jetspeed.deployment.DeploymentException;
import org.apache.jetspeed.deployment.DeploymentManager;
import org.apache.jetspeed.deployment.DeploymentStatus;
import org.apache.jetspeed.deployment.impl.DeploymentEventImpl;
import org.apache.jetspeed.deployment.impl.StandardDeploymentObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardDeploymentManager
implements DeploymentManager {
    private static final FileFilter readmeIgnoringFileFilter = new FileFilter(){

        public boolean accept(File file) {
            return !file.getName().equalsIgnoreCase("README.txt");
        }
    };
    protected Logger log = LoggerFactory.getLogger((String)"deployment");
    protected FileSystemScanner scanner;
    protected PortletRegistry registry;
    protected Collection deploymentListeners;
    protected long scanningDelay;
    protected String stagingDirectories;
    protected File[] stagingDirectoriesAsFiles;
    protected HashMap ignoredFiles;

    public StandardDeploymentManager(String stagingDirectories, long scanningDelay, Collection deploymentListeners) {
        this.scanningDelay = scanningDelay;
        this.stagingDirectories = stagingDirectories;
        StringTokenizer dirTokenizer = new StringTokenizer(stagingDirectories, ",");
        this.stagingDirectoriesAsFiles = new File[dirTokenizer.countTokens()];
        int i = 0;
        while (dirTokenizer.hasMoreTokens()) {
            this.stagingDirectoriesAsFiles[i] = new File(dirTokenizer.nextToken());
            ++i;
        }
        this.deploymentListeners = deploymentListeners;
        this.ignoredFiles = new HashMap();
    }

    public void start() {
        this.log.info("Starting auto deployment service: " + this.getClass().getName());
        this.log.info("Deployment scanning delay: " + this.scanningDelay);
        this.log.info("Deployment staging directory: " + this.stagingDirectories);
        for (int i = 0; i < this.stagingDirectoriesAsFiles.length; ++i) {
            if (this.stagingDirectoriesAsFiles[i].exists()) continue;
            this.log.error(this.stagingDirectoriesAsFiles[i].getAbsolutePath() + " does not exist, auto deployment disabled.");
            this.stop();
            return;
        }
        Iterator itr = this.deploymentListeners.iterator();
        while (itr.hasNext()) {
            ((DeploymentEventListener)itr.next()).initialize();
        }
        if (this.scanningDelay > -1L) {
            try {
                this.scanner = new FileSystemScanner(Thread.currentThread().getThreadGroup(), "Autodeployment File Scanner Thread");
                this.scanner.setDaemon(true);
                this.scanner.setContextClassLoader(this.getClass().getClassLoader());
                this.scanner.start();
                this.log.info("Deployment scanner successfuly started!");
            }
            catch (Exception e) {
                this.log.warn("Unable to intialize Catalina Portlet Application Manager.  Auto deployment will be disabled: " + e.toString(), (Throwable)e);
                this.stop();
                return;
            }
        } else {
            this.log.info("Scanning delay set to " + this.scanningDelay + " has disabled automatic scanning of staging directory.");
        }
    }

    public void stop() {
        if (this.scanner != null) {
            this.scanner.safeStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized DeploymentStatus deploy(File aFile) throws DeploymentException {
        StandardDeploymentObject deploymentObject = new StandardDeploymentObject(aFile);
        DeploymentEventImpl event = null;
        try {
            event = new DeploymentEventImpl(deploymentObject);
            this.dispatch(event);
            Object var5_4 = null;
            if (deploymentObject == null) return event;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (deploymentObject == null) throw throwable;
            try {
                deploymentObject.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            deploymentObject.close();
            return event;
        }
        catch (IOException e) {}
        return event;
    }

    public void fireDeploymentEvent() {
        File[] stagedFiles = this.getAllStagedFiles();
        for (int i = 0; i < stagedFiles.length; ++i) {
            File aFile = stagedFiles[i];
            if (!aFile.isFile() || this.ignoreFile(aFile)) continue;
            DeploymentStatus status = null;
            Exception de = null;
            try {
                status = this.deploy(aFile);
            }
            catch (Exception e) {
                de = e;
            }
            if (status != null && status.getStatus() == 1) {
                if (!aFile.exists()) continue;
                this.log.info("File: " + aFile.getAbsolutePath() + " deployed");
                boolean result = aFile.delete();
                if (result) continue;
                this.log.error("Failed to remove: " + aFile);
                continue;
            }
            if (status == null || status.getStatus() == 0) {
                this.log.warn("Unrecognized file " + aFile.getAbsolutePath());
            } else if (de != null) {
                this.log.error("Failure deploying " + aFile.getAbsolutePath(), (Throwable)de);
            } else {
                this.log.error("Failure deploying " + aFile.getAbsolutePath());
            }
            this.ignoredFiles.put(aFile.getAbsolutePath(), new Long(aFile.lastModified()));
        }
    }

    public void dispatch(DeploymentEvent event) {
        try {
            for (DeploymentEventListener listener : this.deploymentListeners) {
                listener.invokeDeploy(event);
                if (event.getStatus() == 0) continue;
                break;
            }
        }
        catch (DeploymentException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            event.setStatus(-1);
        }
    }

    protected boolean ignoreFile(File aFile) {
        Long previousModified = (Long)this.ignoredFiles.get(aFile.getAbsolutePath());
        if (previousModified != null) {
            if (previousModified.longValue() != aFile.lastModified()) {
                this.ignoredFiles.remove(aFile.getAbsolutePath());
            } else {
                return true;
            }
        }
        return false;
    }

    protected File[] getAllStagedFiles() {
        ArrayList<File> fileList = new ArrayList<File>();
        for (int i = 0; i < this.stagingDirectoriesAsFiles.length; ++i) {
            fileList.addAll(Arrays.asList(this.stagingDirectoriesAsFiles[i].listFiles(readmeIgnoringFileFilter)));
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    public class FileSystemScanner
    extends Thread {
        private boolean started;

        public FileSystemScanner(ThreadGroup threadGroup, String name) throws FileNotFoundException, IOException {
            super(threadGroup, name);
            this.started = true;
            this.setPriority(1);
        }

        public synchronized void run() {
            try {
                this.wait(StandardDeploymentManager.this.scanningDelay);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            while (this.started) {
                StandardDeploymentManager.this.fireDeploymentEvent();
                try {
                    this.wait(StandardDeploymentManager.this.scanningDelay);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void safeStop() {
            FileSystemScanner fileSystemScanner = this;
            synchronized (fileSystemScanner) {
                this.started = false;
                this.notifyAll();
            }
            try {
                this.join(StandardDeploymentManager.this.scanningDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

