/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.desktop.impl;

import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.jetspeed.container.url.BasePortalURL;
import org.apache.jetspeed.decoration.LayoutDecoration;
import org.apache.jetspeed.decoration.Theme;
import org.apache.jetspeed.desktop.JetspeedDesktopContext;
import org.apache.jetspeed.headerresource.HeaderResource;
import org.apache.jetspeed.headerresource.HeaderResourceLib;
import org.apache.jetspeed.request.RequestContext;

public class JetspeedDesktopContextImpl
implements JetspeedDesktopContext {
    RequestContext context;
    private BasePortalURL baseUrlAccess = null;
    private LayoutDecoration layoutDecoration;
    private String defaultLayoutTemplateExtension;
    private String portalBaseUrl;
    private String portalUrl;
    private HeaderResource headerResource;

    public JetspeedDesktopContextImpl(RequestContext context, BasePortalURL baseUrlAccess, Theme theme, HeaderResource headerResource, String defaultLayoutTemplateExtension) {
        this.context = context;
        this.baseUrlAccess = baseUrlAccess;
        this.layoutDecoration = theme.getPageLayoutDecoration();
        this.headerResource = headerResource;
        this.defaultLayoutTemplateExtension = defaultLayoutTemplateExtension;
    }

    public String getPortalBaseUrl() {
        if (this.portalBaseUrl == null) {
            this.portalBaseUrl = HeaderResourceLib.getPortalBaseUrl((RequestContext)this.context, (BasePortalURL)this.baseUrlAccess);
        }
        return this.portalBaseUrl;
    }

    public String getPortalBaseUrl(boolean encode) {
        String baseurl = this.getPortalBaseUrl();
        if (!encode) {
            return baseurl;
        }
        return this.context.getResponse().encodeURL(baseurl);
    }

    public String getPortalResourceUrl(String relativePath) {
        return this.getPortalResourceUrl(relativePath, false);
    }

    public String getPortalResourceUrl(String relativePath, boolean encode) {
        return HeaderResourceLib.getPortalResourceUrl((String)relativePath, (String)this.getPortalBaseUrl(), (boolean)encode, (RequestContext)this.context);
    }

    public String getPortalUrl() {
        if (this.portalUrl == null) {
            this.portalUrl = HeaderResourceLib.getPortalUrl((String)this.getPortalBaseUrl(), (RequestContext)this.context);
        }
        return this.portalUrl;
    }

    public String getPortalUrl(boolean encode) {
        return this.getPortalUrl(null, encode);
    }

    public String getPortalUrl(String relativePath) {
        return this.getPortalUrl(relativePath, false);
    }

    public String getPortalUrl(String relativePath, boolean encode) {
        return HeaderResourceLib.getPortalResourceUrl((String)relativePath, (String)this.getPortalUrl(), (boolean)encode, (RequestContext)this.context);
    }

    public String getLayoutDecorationName() {
        return this.layoutDecoration.getName();
    }

    public String getLayoutTemplatePath() {
        return this.getLayoutTemplatePath(null);
    }

    public String getLayoutTemplatePath(String layoutTemplateIdPropertyName) {
        String ext;
        String id = null;
        if (layoutTemplateIdPropertyName != null) {
            id = this.layoutDecoration.getProperty(layoutTemplateIdPropertyName);
        }
        if (id == null || id.length() == 0) {
            id = this.layoutDecoration.getProperty("template.id");
        }
        if (id == null || id.length() == 0) {
            id = "desktop";
        }
        if ((ext = this.layoutDecoration.getProperty("desktop.template.extension")) == null) {
            ext = this.layoutDecoration.getProperty("template.extension");
        }
        if (ext == null) {
            ext = this.defaultLayoutTemplateExtension;
        }
        return this.layoutDecoration.getBasePath(id + ext);
    }

    public String getLayoutBasePath() {
        return this.layoutDecoration.getBasePath();
    }

    public String getLayoutBasePath(String relativePath) {
        return this.layoutDecoration.getBasePath(relativePath);
    }

    public String getLayoutBaseUrl() {
        return this.getPortalResourceUrl(this.getLayoutBasePath(), false);
    }

    public String getLayoutBaseUrl(String relativePath) {
        return this.getPortalResourceUrl(this.getLayoutBasePath(relativePath), false);
    }

    public ResourceBundle getLayoutResourceBundle(Locale locale) {
        return this.layoutDecoration.getResourceBundle(locale, this.context);
    }

    public HeaderResource getHeaderResource() {
        return this.headerResource;
    }
}

