/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.engine;

import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletConfig;
import org.apache.commons.configuration.Configuration;
import org.apache.jetspeed.JetspeedPortalContext;
import org.apache.jetspeed.PortalContext;
import org.apache.jetspeed.administration.PortalConfiguration;
import org.apache.jetspeed.administration.PortalConfigurationImpl;
import org.apache.jetspeed.components.ComponentManager;
import org.apache.jetspeed.engine.Engine;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.factory.PortletFactory;
import org.apache.jetspeed.pipeline.Pipeline;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.request.RequestContextComponent;
import org.apache.jetspeed.statistics.PortalStatistics;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletContainerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JetspeedEngine
implements Engine {
    private final PortalContext context;
    private final ServletConfig config;
    private final ComponentManager componentManager;
    private Map pipelineMapper;
    private PortalStatistics statistics;
    protected static final Logger log = LoggerFactory.getLogger(JetspeedEngine.class);
    protected String defaultPipelineName;

    public JetspeedEngine(Configuration configuration, String applicationRoot, ServletConfig config, ComponentManager componentManager) {
        this(new PortalConfigurationImpl(configuration), applicationRoot, config, componentManager);
    }

    public JetspeedEngine(PortalConfiguration configuration, String applicationRoot, ServletConfig config, ComponentManager componentManager) {
        this.componentManager = componentManager;
        this.context = new JetspeedPortalContext(this, configuration, applicationRoot);
        this.config = config;
        this.context.setApplicationRoot(applicationRoot);
        this.context.setConfiguration(configuration);
        this.defaultPipelineName = configuration.getString("pipeline.default", "jetspeed-pipeline");
        configuration.setString("applicationRoot", applicationRoot);
        componentManager.addComponent("Engine", (Object)this);
        componentManager.addComponent("PortalContext", (Object)this.context);
        componentManager.addComponent("PortalConfiguration", (Object)configuration);
    }

    public void start() throws JetspeedException {
        Date endTime2;
        DateFormat format = DateFormat.getInstance();
        Date startTime = new Date();
        try {
            try {
                log.info("Starting Jetspeed Engine (" + this.getClass().getName() + ") at " + format.format(startTime));
                ClassLoader ploader2 = this.getClass().getClassLoader();
                ClassHelper.setClassLoader((ClassLoader)ploader2);
                this.componentManager.start();
                this.pipelineMapper = (Map)this.componentManager.getComponent((Object)"pipeline-map");
                ((PortletFactory)this.componentManager.getComponent((Object)"portletFactory")).setPortalContext(this.context);
                try {
                    this.statistics = (PortalStatistics)this.componentManager.getComponent((Object)"PortalStatistics");
                }
                catch (Exception e) {
                }
                Object var6_6 = null;
                endTime2 = new Date();
            }
            catch (Throwable e) {
                e.printStackTrace();
                log.error(e.toString());
                throw new JetspeedException("Jetspeed Initialization exception!", e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            Date endTime2 = new Date();
            long elapsedTime = (endTime2.getTime() - startTime.getTime()) / 1000L;
            log.info("Finished starting Jetspeed Engine (" + this.getClass().getName() + ") at " + format.format(endTime2) + ".  Elapsed time: " + elapsedTime + " seconds.");
            throw throwable;
        }
        long elapsedTime = (endTime2.getTime() - startTime.getTime()) / 1000L;
        log.info("Finished starting Jetspeed Engine (" + this.getClass().getName() + ") at " + format.format(endTime2) + ".  Elapsed time: " + elapsedTime + " seconds.");
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public void shutdown() throws JetspeedException {
        try {
            PortletContainer container = null;
            if (this.componentManager.containsComponent(PortletContainer.class)) {
                container = (PortletContainer)this.componentManager.getComponent(PortletContainer.class);
            }
            if (container != null) {
                container.destroy();
            }
            this.componentManager.stop();
        }
        catch (PortletContainerException e) {
            throw new JetspeedException((Throwable)e);
        }
        System.gc();
    }

    public void service(RequestContext context) throws JetspeedException {
        long start = System.currentTimeMillis();
        String targetPipeline = (String)context.getAttribute("pipeline");
        if (null == targetPipeline) {
            String pipelineKey = context.getRequest().getServletPath();
            targetPipeline = null != pipelineKey ? (pipelineKey.equals("/portal") ? this.defaultPipelineName : (String)this.pipelineMapper.get(pipelineKey)) : this.defaultPipelineName;
        }
        Pipeline pipeline = null;
        if (targetPipeline != null) {
            Pipeline specificPipeline = this.getPipeline(targetPipeline);
            if (specificPipeline != null) {
                pipeline = specificPipeline;
            }
        } else {
            pipeline = this.getPipeline();
        }
        context.setPipeline(pipeline);
        pipeline.invoke(context);
        long end = System.currentTimeMillis();
        if (this.statistics != null) {
            this.statistics.logPageAccess(context, "200", end - start);
        }
    }

    public PortalContext getContext() {
        return this.context;
    }

    public String getRealPath(String path) {
        String result = "";
        String base = this.context.getApplicationRoot();
        if (base.endsWith(File.separator)) {
            if (path.startsWith("/")) {
                result = base.concat(path.substring(1));
                return result;
            }
        } else if (!path.startsWith("/")) {
            result = base.concat("/").concat(path);
            return result;
        }
        return base.concat(path);
    }

    public Pipeline getPipeline(String pipelineName) {
        return (Pipeline)this.componentManager.getComponent((Object)pipelineName);
    }

    public Pipeline getPipeline() {
        return this.getPipeline(this.defaultPipelineName);
    }

    public RequestContext getCurrentRequestContext() {
        RequestContextComponent contextComponent = (RequestContextComponent)this.getComponentManager().getComponent(RequestContextComponent.class);
        return contextComponent.getRequestContext();
    }

    public ComponentManager getComponentManager() {
        return this.componentManager;
    }
}

