/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.events;

import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import javax.portlet.Event;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.jetspeed.aggregator.PortletTrackingManager;
import org.apache.jetspeed.container.providers.EventProviderImpl;
import org.apache.jetspeed.events.JetspeedEventCoordinationService;
import org.apache.jetspeed.events.PortletEventQueue;
import org.apache.jetspeed.events.ProcessEvent;
import org.apache.jetspeed.events.ProcessEventImpl;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SecurityAccessController;
import org.apache.jetspeed.statistics.PortalStatistics;
import org.apache.pluto.container.EventProvider;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.om.portlet.EventDefinition;
import org.apache.pluto.container.om.portlet.EventDefinitionReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventCoordinationServiceImpl
implements JetspeedEventCoordinationService {
    private static Logger log = LoggerFactory.getLogger(EventProviderImpl.class);
    private final PortalStatistics statistics;
    private final PortletTrackingManager portletTracking;
    private final SecurityAccessController accessController;
    private boolean checkSecurityConstraints = true;

    public EventCoordinationServiceImpl(PortletEventQueue eventQueue, PortalStatistics statistics, PortletTrackingManager portletTracking, SecurityAccessController accessController, boolean checkSecurityConstraints) {
        this.statistics = statistics;
        this.portletTracking = portletTracking;
        this.accessController = accessController;
        this.checkSecurityConstraints = checkSecurityConstraints;
    }

    @Override
    public EventProvider createEventProvider(HttpServletRequest request, PortletWindow portletWindow) {
        return new EventProviderImpl(request, (org.apache.jetspeed.container.PortletWindow)portletWindow, this);
    }

    @Override
    public Event createEvent(HttpServletRequest request, org.apache.jetspeed.container.PortletWindow portletWindow, QName qname, Serializable value) throws IllegalArgumentException {
        if (this.isDeclaredAsPublishingEvent(portletWindow, qname)) {
            if (value != null && !this.isValueInstanceOfDefinedClass(portletWindow, qname, value)) {
                throw new IllegalArgumentException("Payload has not the right class");
            }
            if (value == null) {
                return new ProcessEventImpl(portletWindow, qname, null, null, this);
            }
            String result = null;
            Serializable out = this.serialize(value, qname);
            if (out != null) {
                result = out.toString();
            }
            if (result != null) {
                return new ProcessEventImpl(portletWindow, qname, value.getClass().getName(), (Serializable)((Object)result), this);
            }
            return new ProcessEventImpl(portletWindow, qname, value.getClass().getName(), value, this);
        }
        return null;
    }

    @Override
    public void processEvents(PortletContainer container, PortletWindow wnd, HttpServletRequest servletRequest, HttpServletResponse servletResponse, List<Event> events) {
        org.apache.jetspeed.container.PortletWindow portletWindow = (org.apache.jetspeed.container.PortletWindow)wnd;
        long start = System.currentTimeMillis();
        for (Event portletEvent : events) {
            ProcessEvent event = (ProcessEvent)portletEvent;
            if (event.isProcessed()) continue;
            event.setProcessed(true);
            List<org.apache.jetspeed.container.PortletWindow> windows = this.getAllPortletsRegisteredForEvent(portletWindow.getRequestContext(), (Event)event);
            for (org.apache.jetspeed.container.PortletWindow window : windows) {
                try {
                    container.doEvent((PortletWindow)window, servletRequest, servletResponse, (Event)event);
                }
                catch (Exception e) {
                    log.error("Failed to process event: " + event, (Throwable)e);
                }
            }
        }
        long end = System.currentTimeMillis();
        if (this.statistics != null) {
            this.statistics.logPortletAccess(portletWindow.getRequestContext(), portletWindow.getPortletDefinition().getUniqueName(), "901", end - start);
        }
    }

    private boolean isDeclaredAsPublishingEvent(org.apache.jetspeed.container.PortletWindow portletWindow, QName qname) {
        PortletDefinition pd = portletWindow.getPortletDefinition();
        List events = pd.getSupportedPublishingEvents();
        if (events != null) {
            String defaultNamespace = pd.getApplication().getDefaultNamespace();
            for (EventDefinitionReference ref : events) {
                QName name = ref.getQualifiedName(defaultNamespace);
                if (name == null || !qname.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isValueInstanceOfDefinedClass(org.apache.jetspeed.container.PortletWindow portletWindow, QName qname, Serializable value) {
        PortletApplication app = portletWindow.getPortletDefinition().getApplication();
        List events = app.getEventDefinitions();
        if (events != null) {
            for (EventDefinition def : events) {
                QName tmp;
                if (def.getValueType() == null || !(def.getQName() != null ? def.getQName().equals(qname) : (tmp = new QName(app.getDefaultNamespace(), def.getName())).equals(qname))) continue;
                return value.getClass().getName().equals(def.getValueType());
            }
        }
        return true;
    }

    private List<org.apache.jetspeed.container.PortletWindow> getAllPortletsRegisteredForEvent(RequestContext rc, Event event) {
        ContentFragment root = rc.getPage().getRootFragment();
        LinkedList<org.apache.jetspeed.container.PortletWindow> eventTargets = new LinkedList<org.apache.jetspeed.container.PortletWindow>();
        return this.getPortletsRegisteredOnPage(rc, root, event, eventTargets);
    }

    private List<org.apache.jetspeed.container.PortletWindow> getPortletsRegisteredOnPage(RequestContext rc, ContentFragment fragment, Event event, List<org.apache.jetspeed.container.PortletWindow> eventTargets) {
        org.apache.jetspeed.container.PortletWindow portletWindow;
        List fragments = fragment.getFragments();
        if (fragments != null && fragments.size() > 0) {
            for (ContentFragment child : fragments) {
                this.getPortletsRegisteredOnPage(rc, child, event, eventTargets);
            }
        }
        if ((portletWindow = rc.getPortletWindow(fragment)) == null || !portletWindow.isValid()) {
            return eventTargets;
        }
        PortletDefinition portlet = portletWindow.getPortletDefinition();
        if (this.checkSecurityConstraints && !this.checkSecurityConstraint(portlet, fragment)) {
            return eventTargets;
        }
        if (this.portletTracking.isOutOfService(portletWindow)) {
            return eventTargets;
        }
        List processingEvents = portlet.getSupportedProcessingEvents();
        if (this.isEventSupported(processingEvents, event.getQName(), portlet.getApplication().getDefaultNamespace())) {
            eventTargets.add(portletWindow);
        }
        return eventTargets;
    }

    protected boolean checkSecurityConstraint(PortletDefinition portlet, ContentFragment fragment) {
        if (fragment.getType().equals("portlet") && this.accessController != null) {
            return this.accessController.checkPortletAccess(portlet, 8);
        }
        return true;
    }

    private boolean isEventSupported(List<? extends EventDefinitionReference> supportedEvents, QName eventName, String defaultNamespace) {
        if (supportedEvents != null) {
            for (EventDefinitionReference eventDefinitionReference : supportedEvents) {
                QName refQName = eventDefinitionReference.getQualifiedName(defaultNamespace);
                if (refQName == null || !refQName.equals(eventName)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable serialize(Serializable value, QName eventQName) {
        String xmlData = null;
        if (value != null) {
            ClassLoader savedLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{value.getClass()});
                Marshaller marshaller = jaxbContext.createMarshaller();
                StringWriter out = new StringWriter();
                JAXBElement element = new JAXBElement(eventQName, value.getClass(), (Object)value);
                marshaller.marshal((Object)element, (Writer)out);
                xmlData = ((Object)out).toString();
            }
            catch (JAXBException e) {
                log.error("Failed to serialize: " + value, (Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(savedLoader);
            }
        }
        return xmlData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable deserialize(Event event) {
        ProcessEvent processEvent = (ProcessEvent)event;
        ClassLoader savedLoader = Thread.currentThread().getContextClassLoader();
        Serializable deserializedValue = null;
        Serializable value = processEvent.getRawValue();
        if (value != null) {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            XMLStreamReader xml = null;
            if (value instanceof String) {
                try {
                    xml = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader((String)((Object)value)));
                }
                catch (Exception e) {
                    log.error("Failed to stream for de-serialization: " + value, (Throwable)e);
                    xml = null;
                }
                finally {
                    if (xml == null) {
                        Thread.currentThread().setContextClassLoader(savedLoader);
                    }
                }
            }
            if (xml != null) {
                try {
                    Class<Serializable> clazz = savedLoader.loadClass(processEvent.getClassName()).asSubclass(Serializable.class);
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
                    Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                    JAXBElement result = unmarshaller.unmarshal(xml, clazz);
                    deserializedValue = (Serializable)result.getValue();
                }
                catch (Exception e) {
                    log.error("Failed to de-serializee: " + value, (Throwable)e);
                    xml = null;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(savedLoader);
                }
            }
        }
        return deserializedValue;
    }
}

