/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.events;

import java.io.Serializable;
import javax.portlet.Event;
import javax.xml.namespace.QName;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.events.JetspeedEventCoordinationService;
import org.apache.jetspeed.events.ProcessEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessEventImpl
implements ProcessEvent {
    private PortletWindow window;
    private QName qname;
    private Serializable value;
    private String className;
    private JetspeedEventCoordinationService eventService;
    private boolean processed = false;
    private static Logger log = LoggerFactory.getLogger(ProcessEventImpl.class);

    public ProcessEventImpl(PortletWindow window, QName qname, String className, Serializable value, JetspeedEventCoordinationService eventService) {
        this.window = window;
        this.qname = qname;
        this.value = value;
        this.className = className;
        this.eventService = eventService;
    }

    public QName getQName() {
        return this.qname;
    }

    public Serializable getRawValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable getValue() {
        if (this.value != null && this.value instanceof String) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Serializable object;
                Serializable serializable = object = this.eventService.deserialize((Event)this);
                Object var5_5 = null;
                Thread.currentThread().setContextClassLoader(cl);
                return serializable;
            }
            catch (Exception e) {
                try {
                    log.error(e.getMessage(), (Throwable)e);
                    Object var5_6 = null;
                    Thread.currentThread().setContextClassLoader(cl);
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    Thread.currentThread().setContextClassLoader(cl);
                    throw throwable;
                }
            }
        }
        return this.value;
    }

    public String getName() {
        return this.qname.getLocalPart();
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public PortletWindow getPortletWindow() {
        return this.window;
    }

    public String getClassName() {
        return this.className;
    }
}

