/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.healthcheck.validators;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.jetspeed.healthcheck.validators.DataSourcesValidationBean;
import org.apache.jetspeed.healthcheck.validators.HealthCheckValidator;
import org.apache.jetspeed.healthcheck.validators.HealthCheckValidatorResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.support.JdbcUtils;

public class DatasourceAvailableHealthCheckValidator
implements HealthCheckValidator {
    private static final Logger log = LoggerFactory.getLogger(DatasourceAvailableHealthCheckValidator.class);
    public static boolean isInfoEnabled = log.isInfoEnabled();
    public static boolean isDebugEnabled = log.isDebugEnabled();
    private Map resources;
    private int numberOfRetries;
    private long retryDelay;
    private boolean stopValidationOnError;
    private boolean requireAllValid;

    public DatasourceAvailableHealthCheckValidator(Map resources, int numberOfRetries, long retryDelay, boolean stopValidationOnError, boolean requireAllValid) {
        this.resources = resources;
        this.numberOfRetries = numberOfRetries;
        this.retryDelay = retryDelay;
        this.stopValidationOnError = stopValidationOnError;
        this.requireAllValid = requireAllValid;
    }

    public HealthCheckValidatorResult validate() {
        if (isDebugEnabled) {
            log.debug("Starting method: DatasourceAvailableHealthCheckValidator.validate()");
        }
        HealthCheckValidatorResult result = new HealthCheckValidatorResult();
        boolean allDataSourcesStatus = true;
        StringBuffer messages = new StringBuffer();
        try {
            Set dbNames = this.resources.keySet();
            for (String dbName : dbNames) {
                DataSource ds;
                if (messages.length() > 0) {
                    messages.append(LINE_SEPARATOR);
                }
                messages.append(dbName + ":");
                if (isDebugEnabled) {
                    log.debug("Database: " + dbName);
                }
                DataSourcesValidationBean dsBean = (DataSourcesValidationBean)this.resources.get(dbName);
                String validationQuery = dsBean.getValidationQuery();
                boolean dbStatus = true;
                Iterator it2 = dsBean.getDatasources().iterator();
                while (it2.hasNext() && !((dbStatus = this.isDatasourceValid(validationQuery, ds = (DataSource)it2.next())) ? !this.requireAllValid : this.requireAllValid)) {
                }
                if (dbStatus) {
                    messages.append(" is up");
                } else {
                    allDataSourcesStatus = false;
                    messages.append(" is down");
                }
                if (!this.stopValidationOnError || allDataSourcesStatus) continue;
                break;
            }
            if (!allDataSourcesStatus) {
                result.setHealthCheckResult(100);
            }
        }
        catch (Exception e) {
            log.error("Exception while running the datasource validator", (Throwable)e);
            result.setHealthCheckResult(100);
            messages.append("Exception while running the datasource validator: " + e.getMessage());
        }
        if (isDebugEnabled) {
            log.debug(messages.toString());
        }
        result.setResultMessage(messages.toString());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDatasourceValid(String validationQuery, DataSource dataSource) {
        boolean dsStatus = true;
        Connection con = null;
        Statement stmt = null;
        try {
            try {
                con = dataSource.getConnection();
                stmt = con.createStatement();
                stmt.execute(validationQuery);
            }
            catch (SQLException ex) {
                dsStatus = false;
                log.error("The datasource is not available", (Throwable)ex);
                Object var8_7 = null;
                JdbcUtils.closeStatement((Statement)stmt);
                JdbcUtils.closeConnection((Connection)con);
                return dsStatus;
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            JdbcUtils.closeStatement((Statement)stmt);
            JdbcUtils.closeConnection((Connection)con);
            throw throwable;
        }
        JdbcUtils.closeStatement((Statement)stmt);
        JdbcUtils.closeConnection((Connection)con);
        return dsStatus;
    }

    public int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }
}

