/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.util.Map;
import org.apache.jetspeed.ajax.AJAXException;
import org.apache.jetspeed.ajax.AjaxAction;
import org.apache.jetspeed.ajax.AjaxBuilder;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.layout.impl.Constants;
import org.apache.jetspeed.layout.impl.NestedFragmentContext;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePortletAction
implements AjaxAction,
AjaxBuilder,
Constants {
    protected static final Logger log = LoggerFactory.getLogger(BasePortletAction.class);
    protected String template = null;
    protected PageManager pageManager = null;
    protected String errorTemplate = null;
    protected PortletActionSecurityBehavior securityBehavior;

    public BasePortletAction(String template, String errorTemplate, PortletActionSecurityBehavior securityBehavior) {
        this.template = template;
        this.errorTemplate = errorTemplate;
        this.securityBehavior = securityBehavior;
    }

    public BasePortletAction(String template, String errorTemplate, PageManager pageManager) {
        this.template = template;
        this.errorTemplate = errorTemplate;
        this.pageManager = pageManager;
        this.securityBehavior = null;
    }

    public BasePortletAction(String template, String errorTemplate, PageManager pageManager, PortletActionSecurityBehavior securityBehavior) {
        this(template, errorTemplate, securityBehavior);
        this.pageManager = pageManager;
    }

    public boolean buildContext(RequestContext requestContext, Map responseContext) {
        return true;
    }

    public boolean buildErrorContext(RequestContext requestContext, Map responseContext) {
        responseContext.put("status", "failure");
        if (responseContext.get("action") == null) {
            responseContext.put("action", "unknown");
        }
        if (responseContext.get("id") == null) {
            responseContext.put("id", "unknown");
        }
        return true;
    }

    public String getErrorTemplate() {
        return this.errorTemplate;
    }

    public String getTemplate() {
        return this.template;
    }

    public boolean checkAccess(RequestContext context, String action) {
        boolean access = true;
        if (null != this.securityBehavior) {
            access = this.securityBehavior.checkAccess(context, action);
        }
        return access;
    }

    public boolean isCreateNewPageOnEditEnabled() {
        if (this.securityBehavior == null) {
            return false;
        }
        return this.securityBehavior.isCreateNewPageOnEditEnabled();
    }

    public boolean isPageQualifiedForCreateNewPageOnEdit(RequestContext context) {
        if (this.securityBehavior == null) {
            return false;
        }
        return this.securityBehavior.isPageQualifiedForCreateNewPageOnEdit(context);
    }

    public boolean createNewPageOnEdit(RequestContext context) {
        if (this.securityBehavior == null) {
            return false;
        }
        return this.securityBehavior.createNewPageOnEdit(context);
    }

    public ContentFragment getFragmentIdFromLocation(int row, int column, ContentPage page) {
        return this.getFragmentIdFromLocation(row, column, page.getRootFragment());
    }

    public ContentFragment getFragmentIdFromLocation(int row, int column, ContentFragment parentFragment) {
        for (ContentFragment fragment : parentFragment.getFragments()) {
            if (fragment.getLayoutColumn() != column || fragment.getLayoutRow() != row) continue;
            return fragment;
        }
        return null;
    }

    public boolean runBatch(RequestContext requestContext, Map resultMap) throws AJAXException {
        return this.run(requestContext, resultMap);
    }

    public String getActionParameter(RequestContext requestContext, String name) {
        Object o;
        String parameter = requestContext.getRequestParameter(name);
        if (parameter == null && (o = requestContext.getAttribute(name)) != null && o instanceof String) {
            return (String)o;
        }
        return parameter;
    }

    public String getNonNullActionParameter(RequestContext requestContext, String name) {
        String result = this.getActionParameter(requestContext, name);
        if (result == null) {
            return "";
        }
        return result;
    }

    public ContentFragment getParentFragmentById(String id, ContentFragment root) {
        return NestedFragmentContext.getParentFragmentById(id, root);
    }
}

