/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.jetspeed.ajax.AJAXException;
import org.apache.jetspeed.ajax.AjaxAction;
import org.apache.jetspeed.ajax.AjaxBuilder;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.layout.impl.BasePortletAction;
import org.apache.jetspeed.layout.impl.Constants;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.portlet.LocalizedField;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSiteUpdateAction
extends BasePortletAction
implements AjaxAction,
AjaxBuilder,
Constants {
    protected static final Logger log = LoggerFactory.getLogger(BaseSiteUpdateAction.class);

    public BaseSiteUpdateAction(String template, String errorTemplate, PageManager pageManager) {
        super(template, errorTemplate, pageManager);
    }

    public BaseSiteUpdateAction(String template, String errorTemplate, PortletActionSecurityBehavior securityBehavior) {
        super(template, errorTemplate, securityBehavior);
    }

    public BaseSiteUpdateAction(String template, String errorTemplate, PageManager pageManager, PortletActionSecurityBehavior securityBehavior) {
        super(template, errorTemplate, pageManager, securityBehavior);
    }

    protected abstract int updateInformation(RequestContext var1, Map var2, Node var3, String var4) throws AJAXException;

    protected int insertMetadata(RequestContext requestContext, Map resultMap, Node node) throws AJAXException {
        String name = this.getActionParameter(requestContext, "name");
        String language = this.getActionParameter(requestContext, "lang");
        String value = this.getActionParameter(requestContext, "value");
        if (this.isBlank(name) || this.isBlank(language)) {
            throw new AJAXException("Invalid Metadata: name, language invalid data.");
        }
        Locale locale = new Locale(language);
        node.getMetadata().addField(locale, name, value);
        return 1;
    }

    protected int updateMetadata(RequestContext requestContext, Map resultMap, Node node) throws AJAXException {
        String name = this.getActionParameter(requestContext, "name");
        String language = this.getActionParameter(requestContext, "lang");
        String value = this.getActionParameter(requestContext, "value");
        String oldName = this.getActionParameter(requestContext, "oldname");
        String oldLanguage = this.getActionParameter(requestContext, "oldlang");
        if (this.isBlank(name) || this.isBlank(language) || this.isBlank(oldName) || this.isBlank(oldLanguage)) {
            throw new AJAXException("Invalid Metadata: name, language invalid data.");
        }
        Collection cfields = node.getMetadata().getFields(oldName);
        if (cfields == null || cfields.size() == 0) {
            return this.insertMetadata(requestContext, resultMap, node);
        }
        boolean found = false;
        for (LocalizedField field : cfields) {
            if (!this.areFieldsSame(field.getName(), oldName) || !this.areFieldsSame(field.getLocale().toString(), oldLanguage)) continue;
            field.setName(name);
            field.setLocale(new Locale(language));
            field.setValue(value);
            found = true;
            break;
        }
        if (!found) {
            return this.insertMetadata(requestContext, resultMap, node);
        }
        return 1;
    }

    protected int removeMetadata(RequestContext requestContext, Map resultMap, Node node) throws AJAXException {
        String name = this.getActionParameter(requestContext, "name");
        String language = this.getActionParameter(requestContext, "lang");
        if (this.isBlank(name) || this.isBlank(language)) {
            throw new AJAXException("Invalid Metadata: name, language invalid data.");
        }
        Collection cfields = node.getMetadata().getFields(name);
        Collection allFields = node.getMetadata().getFields();
        if (cfields == null || cfields.size() == 0) {
            return 0;
        }
        boolean found = false;
        for (LocalizedField field : cfields) {
            if (!this.areFieldsSame(field.getName(), name) || !this.areFieldsSame(field.getLocale().toString(), language)) continue;
            cfields.remove(field);
            if (allFields.remove(field)) {
                node.getMetadata().setFields(allFields);
            }
            found = true;
            break;
        }
        return found ? 1 : 0;
    }

    protected int insertSecurityReference(RequestContext requestContext, Map resultMap, Node node) throws AJAXException {
        String name = this.getActionParameter(requestContext, "name");
        String kind = this.getActionParameter(requestContext, "kind");
        if (this.isBlank(name) || this.isBlank(kind)) {
            throw new AJAXException("Invalid Security Ref: name invalid data.");
        }
        if (node.getSecurityConstraints() == null) {
            SecurityConstraints cons = node.newSecurityConstraints();
            node.setSecurityConstraints(cons);
        }
        if (kind.equals("Owner")) {
            node.getSecurityConstraints().setOwner(name);
        } else {
            List refs = node.getSecurityConstraints().getSecurityConstraintsRefs();
            if (refs.contains(name)) {
                return 0;
            }
            refs.add(name);
        }
        return 1;
    }

    protected int updateSecurityReference(RequestContext requestContext, Map resultMap, Node node) throws AJAXException {
        List refs;
        String name = this.getActionParameter(requestContext, "name");
        String oldName = this.getActionParameter(requestContext, "oldname");
        String kind = this.getActionParameter(requestContext, "kind");
        if (this.isBlank(name) || this.isBlank(oldName) || this.isBlank(kind)) {
            throw new AJAXException("Invalid Security Ref: name invalid data.");
        }
        if (node.getSecurityConstraints() == null) {
            SecurityConstraints cons = node.newSecurityConstraints();
            node.setSecurityConstraints(cons);
        }
        if ((refs = node.getSecurityConstraints().getSecurityConstraintsRefs()) == null || refs.size() == 0) {
            return this.insertSecurityReference(requestContext, resultMap, node);
        }
        boolean found = false;
        if (kind.equals("Owner")) {
            node.getSecurityConstraints().setOwner(name);
            found = true;
        } else {
            for (int ix = 0; ix < refs.size(); ++ix) {
                String ref = (String)refs.get(ix);
                if (!this.areFieldsSame(ref, oldName)) continue;
                refs.set(ix, name);
                found = true;
                break;
            }
        }
        if (!found) {
            return this.insertSecurityReference(requestContext, resultMap, node);
        }
        return 1;
    }

    protected int removeSecurityReference(RequestContext requestContext, Map resultMap, Node node) throws AJAXException {
        String name = this.getActionParameter(requestContext, "name");
        String kind = this.getActionParameter(requestContext, "kind");
        if (this.isBlank(name) || this.isBlank(kind)) {
            throw new AJAXException("Invalid Security Ref: name invalid data.");
        }
        if (node.getSecurityConstraints() == null) {
            return 0;
        }
        if (kind.equals("Owner")) {
            node.getSecurityConstraints().setOwner(null);
        } else {
            List refs = node.getSecurityConstraints().getSecurityConstraintsRefs();
            if (!refs.contains(name)) {
                return 0;
            }
            refs.remove(name);
        }
        return 1;
    }

    protected int removeSecurityDef(RequestContext requestContext, Map resultMap, Node node) throws AJAXException {
        String id = this.getActionParameter(requestContext, "id");
        if (this.isBlank(id)) {
            throw new AJAXException("Invalid Security Ref: id invalid data.");
        }
        if (node.getSecurityConstraints() == null) {
            return 0;
        }
        List defs = node.getSecurityConstraints().getSecurityConstraints();
        if (defs == null || defs.size() == 0) {
            return 0;
        }
        if (id.length() == 1) {
            return 0;
        }
        int index = Integer.parseInt(id = id.substring(1)) - 1;
        if (index < 0) {
            return 0;
        }
        defs.remove(index);
        return 1;
    }

    protected boolean isBlank(String field) {
        return field == null || field.trim().length() == 0;
    }

    protected boolean isFieldModified(String paramValue, String prevValue) {
        if (paramValue == null) {
            return prevValue != null;
        }
        if (prevValue == null) {
            return true;
        }
        return !prevValue.equals(paramValue);
    }

    protected boolean areFieldsSame(String f1, String f2) {
        return !this.isFieldModified(f1, f2);
    }

    protected boolean isBooleanModified(String paramValue, boolean prevValue) {
        if (paramValue == null) {
            return prevValue;
        }
        return !prevValue;
    }
}

