/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.util.List;
import java.util.Map;
import org.apache.jetspeed.ajax.AJAXException;
import org.apache.jetspeed.ajax.AjaxAction;
import org.apache.jetspeed.ajax.AjaxBuilder;
import org.apache.jetspeed.layout.impl.Constants;
import org.apache.jetspeed.layout.impl.RolesSecurityBehavior;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.UserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseUserAction
implements AjaxAction,
AjaxBuilder,
Constants {
    protected Logger log = LoggerFactory.getLogger(BaseUserAction.class);
    protected String template = null;
    protected UserManager userManager = null;
    protected String errorTemplate = null;
    protected RolesSecurityBehavior securityBehavior;

    public BaseUserAction(String template, String errorTemplate, RolesSecurityBehavior securityBehavior) {
        this.template = template;
        this.errorTemplate = errorTemplate;
        this.securityBehavior = securityBehavior;
    }

    public BaseUserAction(String template, String errorTemplate, UserManager userManager) {
        this.template = template;
        this.errorTemplate = errorTemplate;
        this.userManager = userManager;
        this.securityBehavior = null;
    }

    public BaseUserAction(String template, String errorTemplate, UserManager userManager, RolesSecurityBehavior securityBehavior) {
        this(template, errorTemplate, securityBehavior);
        this.userManager = userManager;
    }

    public boolean buildContext(RequestContext requestContext, Map responseContext) {
        return true;
    }

    public boolean buildErrorContext(RequestContext requestContext, Map responseContext) {
        responseContext.put("status", "failure");
        if (responseContext.get("action") == null) {
            responseContext.put("action", "unknown");
        }
        if (responseContext.get("id") == null) {
            responseContext.put("id", "unknown");
        }
        return true;
    }

    public String getErrorTemplate() {
        return this.errorTemplate;
    }

    public String getTemplate() {
        return this.template;
    }

    public boolean checkAccess(RequestContext context, String action) {
        boolean access = true;
        if (null != this.securityBehavior) {
            access = this.securityBehavior.checkAccess(context, action);
        }
        return access;
    }

    public boolean createNewPageOnEdit(RequestContext context) {
        if (this.securityBehavior == null) {
            return false;
        }
        return this.securityBehavior.createNewPageOnEdit(context);
    }

    public ContentFragment getFragmentIdFromLocation(int row, int column, ContentPage page) {
        ContentFragment root = page.getRootFragment();
        for (ContentFragment fragment : root.getFragments()) {
            if (fragment.getLayoutColumn() != column || fragment.getLayoutRow() != row) continue;
            return fragment;
        }
        return null;
    }

    public boolean runBatch(RequestContext requestContext, Map resultMap) throws AJAXException {
        return this.run(requestContext, resultMap);
    }

    public String getActionParameter(RequestContext requestContext, String name) {
        Object o;
        String parameter = requestContext.getRequestParameter(name);
        if (parameter == null && (o = requestContext.getAttribute(name)) != null && o instanceof String) {
            return (String)o;
        }
        return parameter;
    }

    public ContentFragment getParentFragmentById(String id, ContentFragment root) {
        if (id == null) {
            return null;
        }
        return this.searchForParentFragmentById(id, root);
    }

    protected ContentFragment searchForParentFragmentById(String id, ContentFragment parent) {
        ContentFragment matchedParent = null;
        if (parent != null) {
            List children = parent.getFragments();
            int cSize = children.size();
            for (int i = 0; i < cSize; ++i) {
                ContentFragment childFrag = (ContentFragment)children.get(i);
                if (childFrag == null) continue;
                if (id.equals(childFrag.getId())) {
                    matchedParent = parent;
                    break;
                }
                matchedParent = this.searchForParentFragmentById(id, childFrag);
                if (matchedParent != null) break;
            }
        }
        return matchedParent;
    }

    public boolean isTrue(String parameter) {
        boolean isTrue = false;
        if (parameter != null && parameter.equalsIgnoreCase("true")) {
            isTrue = true;
        }
        return isTrue;
    }
}

